/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.OpenBrowserUtil;
import org.tizen.common.util.StringUtil;

public class HelpToolTip
extends DefaultToolTip {
    final Logger logger = LoggerFactory.getLogger(HelpToolTip.class);
    private Cursor helpCursor;
    private TooltipShowListener showListener;
    private TooltipHideListener hideListener;
    private Composite composite;
    private Control tooltipControl = (Control)this.getToolTipArea(null);
    private int popupDelay;
    private boolean showOnMouseDown;
    private boolean focusOnHover;
    private SelectionListener linkListener;

    public HelpToolTip(Composite c) {
        this(c, true, false);
    }

    public HelpToolTip(Composite c, boolean showOnMouseDown, boolean hideOnMouseDown) {
        super((Control)HelpToolTip.createHelpIcon(c), 2, false);
        this.helpCursor = new Cursor((Device)this.tooltipControl.getShell().getDisplay(), 21);
        this.tooltipControl.setCursor(this.helpCursor);
        this.showListener = new TooltipShowListener();
        this.hideListener = new TooltipHideListener();
        this.linkListener = new TooltipSelectionListener();
        this.tooltipControl.addListener(3, (Listener)this.showListener);
        this.setPopupDelay(1000);
        this.setShowOnMouseDown(showOnMouseDown);
        this.setHideOnMouseDown(hideOnMouseDown);
    }

    public void addControlSelectionListener(Listener listener) {
        this.tooltipControl.addListener(3, listener);
    }

    public void deactivate() {
        super.deactivate();
        if (this.tooltipControl != null) {
            this.tooltipControl.removeListener(3, (Listener)this.showListener);
        }
    }

    public void activate() {
        super.activate();
        this.setShowOnMouseDown(this.showOnMouseDown);
    }

    protected final Composite createToolTipContentArea(Event event, Composite parent) {
        this.composite = this.doCreateToolTipContentArea(event, parent);
        this.tooltipControl.removeListener(3, (Listener)this.showListener);
        if (this.composite != null) {
            this.tooltipControl.addListener(7, (Listener)this.hideListener);
        }
        return this.composite;
    }

    protected Composite doCreateToolTipContentArea(Event event, Composite parent) {
        Label label;
        String text = this.getText(event);
        Color fgColor = this.getForegroundColor(event);
        Color bgColor = this.getBackgroundColor(event);
        Font font = this.getFont(event);
        SelectionListener listener = this.getLinkListener(event);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        if (listener != null) {
            this.setFocusOnHover(true);
            label = new Link(composite, this.getStyle(event) | 0x40);
            ((Link)label).addSelectionListener(listener);
            if (text != null) {
                ((Link)label).setText(text);
            }
        } else {
            label = new Label(composite, this.getStyle(event) | 0x40);
            if (text != null) {
                label.setText(text);
            }
        }
        if (label.computeSize((int)-1, (int)-1).x > 350) {
            GridData gd = new GridData();
            gd.widthHint = 350;
            label.setLayoutData((Object)gd);
        }
        if (fgColor != null) {
            label.setForeground(fgColor);
        }
        if (bgColor != null) {
            composite.setBackground(bgColor);
            label.setBackground(bgColor);
        }
        if (font != null) {
            label.setFont(font);
        }
        return composite;
    }

    protected void afterHideToolTip(Event event) {
        this.tooltipControl.removeListener(3, (Listener)this.showListener);
        if (this.showOnMouseDown) {
            this.tooltipControl.addListener(3, (Listener)this.showListener);
        }
        this.tooltipControl.removeListener(7, (Listener)this.hideListener);
        super.afterHideToolTip(event);
    }

    public void setPopupDelay(int popupDelay) {
        this.popupDelay = popupDelay;
        super.setPopupDelay(popupDelay);
    }

    protected SelectionListener getLinkListener(Event event) {
        return this.linkListener;
    }

    public void setShowOnMouseDown(boolean showOnMouseDown) {
        this.showOnMouseDown = showOnMouseDown;
        if (this.tooltipControl != null) {
            this.tooltipControl.removeListener(3, (Listener)this.showListener);
            if (showOnMouseDown) {
                this.tooltipControl.addListener(3, (Listener)this.showListener);
            }
        }
    }

    public boolean isShowOnMouseDown() {
        return this.showOnMouseDown;
    }

    public void setFocusOnHover(boolean focusOnHover) {
        this.focusOnHover = focusOnHover;
    }

    public boolean isFocusOnHover() {
        return this.focusOnHover;
    }

    private static Label createHelpIcon(Composite c) {
        Label helpIcon = new Label(c, 0);
        helpIcon.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP"));
        return helpIcon;
    }

    public void dispose() {
        if (this.helpCursor != null) {
            this.helpCursor.dispose();
        }
    }

    class TooltipHideListener
    implements Listener {
        TooltipHideListener() {
        }

        public void handleEvent(Event event) {
            if (HelpToolTip.this.composite.isDisposed()) {
                return;
            }
            Shell shell = HelpToolTip.this.composite.getShell();
            switch (event.type) {
                case 3: {
                    if (!HelpToolTip.this.isHideOnMouseDown()) break;
                    HelpToolTip.this.hide();
                    break;
                }
                case 7: {
                    Listener[] listeners;
                    if (!shell.getBounds().contains(HelpToolTip.this.composite.getDisplay().getCursorLocation())) {
                        HelpToolTip.this.hide();
                        break;
                    }
                    if (!HelpToolTip.this.focusOnHover) break;
                    shell.setActive();
                    HelpToolTip.this.composite.setFocus();
                    if (!OSChecker.isLinux() || (listeners = shell.getListeners(7)) == null) break;
                    shell.removeListener(7, listeners[0]);
                    break;
                }
            }
        }
    }

    class TooltipSelectionListener
    extends SelectionAdapter {
        TooltipSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            HelpToolTip.this.hide();
            String link = e.text.toLowerCase();
            if (link == null) {
                return;
            }
            if (link.startsWith("http://")) {
                try {
                    OpenBrowserUtil.openExternal(new URL(e.text), HelpToolTip.this.tooltipControl.getDisplay());
                }
                catch (MalformedURLException e1) {
                    HelpToolTip.this.logger.error(e1.getMessage());
                }
            } else if (link.startsWith("help://")) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/" + StringUtil.removeStart(link, "help://"));
            }
        }
    }

    class TooltipShowListener
    implements Listener {
        TooltipShowListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 3: {
                    HelpToolTip.this.hide();
                    HelpToolTip.this.setPopupDelay(0);
                    Point cursorAbsLocation = HelpToolTip.this.tooltipControl.getDisplay().getCursorLocation();
                    Point containerAbsLocation = HelpToolTip.this.tooltipControl.getParent().toDisplay(HelpToolTip.this.tooltipControl.getLocation());
                    int relativeX = cursorAbsLocation.x - containerAbsLocation.x;
                    int relativeY = cursorAbsLocation.y - containerAbsLocation.y;
                    HelpToolTip.this.show(new Point(relativeX, relativeY));
                    HelpToolTip.this.setPopupDelay(HelpToolTip.this.popupDelay);
                    break;
                }
            }
        }
    }
}

