/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.tizen.common.rest.model.RepositoryManager;
import org.tizen.common.rest.model.schema.AbstractWadlModel;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.model.schema.Param;
import org.tizen.common.rest.ui.dialogs.RestParamEditing;

public class RestViewerManager {
    public static void addModel(IRestUiModel target, IRestUiModel[] models) {
        int i = 0;
        while (i < models.length) {
            if (target == null) {
                target = models[i];
            } else {
                target.addChild(models[i]);
                target = models[i];
            }
            ++i;
        }
        RepositoryManager.getInstance().updateOrAddApplication(target.getRoot());
    }

    public static void updateModel(IRestUiModel[] modelsFromTree, IRestUiModel[] modelsOnDialog) {
        int i = 0;
        while (i < modelsFromTree.length) {
            modelsFromTree[i].update(modelsOnDialog[i]);
            ++i;
        }
        RepositoryManager.getInstance().updateOrAddApplication((Application)modelsFromTree[0]);
    }

    public static void updateParam(IRestUiModel[] targets, Map<Param, Param> params, Param[] newParams) {
        for (Param key : params.keySet()) {
            if (params.get(key) == null) {
                key.delete();
                continue;
            }
            key.update(params.get(key));
        }
        Param[] paramArray = newParams;
        int n = newParams.length;
        int n2 = 0;
        while (n2 < n) {
            Param param = paramArray[n2];
            IRestUiModel[] iRestUiModelArray = targets;
            int n3 = targets.length;
            int n4 = 0;
            while (n4 < n3) {
                IRestUiModel target = iRestUiModelArray[n4];
                if (RestParamEditing.isParent(param, target)) {
                    param.setStyle(param.getStyle());
                    target.addChild(param);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        RepositoryManager.getInstance().updateOrAddApplication(targets[0].getRoot());
    }

    public static IRestUiModel updateModel(IRestUiModel target, IRestUiModel updateModel) {
        AbstractWadlModel targetModel = (AbstractWadlModel)((Object)target);
        Application application = targetModel.getRoot();
        IRestUiModel model = target.update(updateModel);
        RepositoryManager.getInstance().updateOrAddApplication(application);
        return model;
    }

    public static void deleteModel(TreeViewer viewer, IRestUiModel[] models) {
        IRestUiModel[] iRestUiModelArray = models = RestViewerManager.getAncestors(models);
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IRestUiModel model = iRestUiModelArray[n2];
            Application application = ((AbstractWadlModel)((Object)model)).getRoot();
            model.delete();
            if (!(model instanceof Application)) {
                RepositoryManager.getInstance().updateOrAddApplication(application);
            }
            ++n2;
        }
    }

    public static IRestUiModel[] getAncestors(IRestUiModel[] models) {
        ArrayList<IRestUiModel> dList = new ArrayList<IRestUiModel>();
        boolean bAdd = true;
        IRestUiModel[] iRestUiModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IRestUiModel model = iRestUiModelArray[n2];
            if (dList.size() == 0) {
                dList.add(model);
            } else {
                Iterator iter = dList.iterator();
                bAdd = true;
                while (iter.hasNext()) {
                    IRestUiModel higher;
                    IRestUiModel listModel = (IRestUiModel)iter.next();
                    if (listModel.equals(higher = RestViewerManager.getAncestor(listModel, model, null))) {
                        bAdd = false;
                        break;
                    }
                    if (!model.equals(higher)) continue;
                    iter.remove();
                    bAdd = true;
                    break;
                }
                if (bAdd) {
                    dList.add(model);
                }
            }
            ++n2;
        }
        return dList.toArray(new IRestUiModel[0]);
    }

    private static IRestUiModel getAncestor(IRestUiModel model1, IRestUiModel model2, IElementComparer comparator) {
        TreePath pathB;
        TreePath pathA = ((AbstractWadlModel)((Object)model1)).getFullPath();
        if (pathA.startsWith(pathB = ((AbstractWadlModel)((Object)model2)).getFullPath(), comparator)) {
            return model2;
        }
        if (pathB.startsWith(pathA, comparator)) {
            return model1;
        }
        return null;
    }
}

