/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.explorer.ConnectionUIMessages;
import org.tizen.common.connection.explorer.RemoteDeviceManagerDeviceItem;
import org.tizen.common.connection.explorer.RemoteDeviceManagerSubDialog;
import org.tizen.common.connection.explorer.RemoteDeviceManagerTableLabelProvider;
import org.tizen.common.connection.explorer.RemoteDeviceMangerScanWorker;
import org.tizen.common.connection.toolbar.DeviceDescriptor;
import org.tizen.common.connection.toolbar.TargetToolBarManager;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.ui.widget.ImageButton;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.HostUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.SWTUtil;
import org.tizen.sdblib.util.IOUtil;

public class RemoteDeviceManagerDialog
extends Dialog {
    private static final Logger logger = LoggerFactory.getLogger((String)"RemoteDeviceManagerDialog.class");
    protected static final String AUTO_SCAN_PORT = "26101";
    private static final String SDB_CONNECT_CMD_PREFIX = "\"" + InstallPathConfig.getSDBPath() + "\"" + " connect ";
    private static final String SDB_DISCONNECT_CMD_PREFIX = "\"" + InstallPathConfig.getSDBPath() + "\"" + " disconnect ";
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final String PORT_PATTERN = "^(6553[0-5]|655[0-2]\\d|65[0-4]\\d\\d|6[0-4]\\d{3}|[1-5]\\d{4}|[1-9]\\d{0,3}|0)$";
    private static final String REMOTE_DEVICE_LIST_FILE = String.valueOf(InstallPathConfig.getUserDataPath()) + File.separator + "device-manager" + File.separator + "config" + File.separator + "remote_device_scan.list";
    private static final String[] NEW_IMAGES = new String[]{"icons/connection/remote/btn_add_nor.png", "icons/connection/remote/btn_add_over.png", "icons/connection/remote/btn_add_sel.png", "icons/connection/remote/btn_add_dim.png"};
    private static final String[] EDIT_IMAGES = new String[]{"icons/connection/remote/btn_edit_nor.png", "icons/connection/remote/btn_edit_over.png", "icons/connection/remote/btn_edit_sel.png", "icons/connection/remote/btn_edit_dim.png"};
    private static final String[] DELETE_IMAGES = new String[]{"icons/connection/remote/btn_delete_nor.png", "icons/connection/remote/btn_delete_over.png", "icons/connection/remote/btn_delete_sel.png", "icons/connection/remote/btn_delete_dim.png"};
    private static final String[] CONNECT_IMAGES = new String[]{"icons/connection/remote/toggle_s_on.png", "icons/connection/remote/toggle_s_off.png"};
    private static final String PROGRESS_IMAGE = "icons/connection/remote/loading_seq_l_3.gif";
    protected static final int TABLE_COLUMN_INDEX_NAME = 0;
    protected static final int TABLE_COLUMN_INDEX_IP = 1;
    protected static final int TABLE_COLUMN_INDEX_PORT = 2;
    protected static final int TABLE_COLUMN_INDEX_CONNECT = 3;
    private static final int TABLE_TOTAL_HEIGHT = 198;
    private static final int TABLE_HEADER_HEIGHT = 28;
    protected static final int TABLE_ITEM_HEIGHT = 25;
    private static final int TABLE_SHOW_ITEM_COUNT = 6;
    private static final int TABLE_ITEM_NAME_WIDTH = 110;
    protected static final int TABLE_ITEM_IP_WIDTH = 118;
    private static final int TABLE_ITEM_PORT_WIDTH = 80;
    private static final int TABLE_ITEM_CONNECT_WIDTH = 91;
    protected static final int TABLE_ITEM_CONTEXT_LEFT_MARGIN = 20;
    protected static final int TABLE_ITEM_CONTEXT_TOP_MARGIN = 4;
    private static final int TABLE_VSCROL_WIDTH = 17;
    private static final int DIALOGBOX_TOP_AREA_HEIGHT = 45;
    private static final int DIALOGBOX_CENTER_AREA_HEIGHT = 218;
    private static final int DIALOGBOX_BOTTOM_AREA_HEIGHT = 60;
    private static final int DIALOGBOX_TOTAL_AREA_WIDTH = 470;
    private static final int DIALOGBOX_TOTAL_AREA_HEIGHT = 328;
    ResourceManager resManager = new LocalResourceManager(JFaceResources.getResources());
    protected Color activeBgColor = this.resManager.createColor(new RGB(248, 248, 248));
    protected Color selectBgColor = this.resManager.createColor(new RGB(0, 138, 238));
    protected Color tableLineColor = this.resManager.createColor(new RGB(141, 141, 141));
    protected Color tableFontColor = this.resManager.createColor(new RGB(51, 51, 51));
    protected Image connectedToggleOnImages = this.findOrCreateImage(CONNECT_IMAGES[0]);
    protected Image connectedToggleOffImages = this.findOrCreateImage(CONNECT_IMAGES[1]);
    private ImageButton newButton = null;
    private ImageButton editButton = null;
    private ImageButton deleteButton = null;
    private Button scanButton = null;
    private Button closeButton = null;
    private static RemoteDeviceMangerScanWorker scanWorker = null;
    protected ArrayList<ImageData> imageDataList = new ArrayList();
    private int progressImgIndex = 0;
    private TableViewer tableViewer = null;
    protected Table table = null;
    private TableViewerColumn nameColumn = null;
    private Composite tableHeaderComposite = null;
    protected ArrayList<RemoteDeviceManagerDeviceItem> deviceItemsArray = new ArrayList();
    protected TableItem selectedItem = null;

    public RemoteDeviceManagerDialog(Shell parentShell) {
        super(parentShell);
        scanWorker = new RemoteDeviceMangerScanWorker(this);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ConnectionUIMessages.Remote_Device_Manager_Name);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(470, 328));
        RemoteDeviceManagerDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RemoteDeviceManagerDialog.this.resManager.dispose();
            }
        });
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(470, 263));
        this.createTopButtonArea(composite);
        this.createTableArea(composite);
        Composite bottomArea = new Composite(composite, 0);
        layout = new GridLayout(1, false);
        bottomArea.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.heightHint = 20;
        bottomArea.setLayoutData((Object)gd);
        bottomArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(RemoteDeviceManagerDialog.this.tableLineColor);
                e.gc.drawLine(0, 18, 470, 18);
            }
        });
        return parent;
    }

    private void createTopButtonArea(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compLayout = new GridLayout(4, false);
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 3;
        gd.heightHint = 45;
        composite.setLayoutData((Object)gd);
        compLayout.marginTop = 20;
        compLayout.marginRight = 8;
        compLayout.horizontalSpacing = 12;
        composite.setLayout((Layout)compLayout);
        gd = new GridData(18, 18);
        gd.horizontalAlignment = 3;
        this.newButton = new ImageButton(composite, this.findOrCreateImage(NEW_IMAGES[0]), this.findOrCreateImage(NEW_IMAGES[1]), this.findOrCreateImage(NEW_IMAGES[2]), this.findOrCreateImage(NEW_IMAGES[3]));
        this.newButton.setToolTipText(ConnectionUIMessages.Remote_Device_Manager_New_Button_Tooltip_Name);
        this.newButton.addListener(4, new Listener(){

            public void handleEvent(Event e) {
                RemoteDeviceManagerSubDialog dialog = new RemoteDeviceManagerSubDialog(parent.getShell(), RemoteDeviceManagerDialog.this, true);
                dialog.open();
            }
        });
        this.newButton.setLayoutData((Object)gd);
        gd = new GridData(18, 18);
        gd.horizontalAlignment = 3;
        this.editButton = new ImageButton(composite, this.findOrCreateImage(EDIT_IMAGES[0]), this.findOrCreateImage(EDIT_IMAGES[1]), this.findOrCreateImage(EDIT_IMAGES[2]), this.findOrCreateImage(EDIT_IMAGES[3]));
        this.editButton.setToolTipText(ConnectionUIMessages.Remote_Device_Manager_Edit_Button_Tooltip_Name);
        this.editButton.addListener(4, new Listener(){

            public void handleEvent(Event e) {
                if (RemoteDeviceManagerDialog.this.selectedItem == null || RemoteDeviceManagerDialog.this.selectedItem.isDisposed()) {
                    return;
                }
                RemoteDeviceManagerSubDialog dialog = new RemoteDeviceManagerSubDialog(parent.getShell(), RemoteDeviceManagerDialog.this, false);
                dialog.open();
                RemoteDeviceManagerDialog.this.tableViewer.refresh();
            }
        });
        this.editButton.setLayoutData((Object)gd);
        gd = new GridData(18, 18);
        gd.horizontalAlignment = 3;
        this.deleteButton = new ImageButton(composite, this.findOrCreateImage(DELETE_IMAGES[0]), this.findOrCreateImage(DELETE_IMAGES[1]), this.findOrCreateImage(DELETE_IMAGES[2]), this.findOrCreateImage(DELETE_IMAGES[3]));
        this.deleteButton.setToolTipText(ConnectionUIMessages.Remote_Device_Manager_Delete_Button_Tooltip_Name);
        this.deleteButton.addListener(4, new Listener(){

            public void handleEvent(Event e) {
                if (RemoteDeviceManagerDialog.this.selectedItem == null || RemoteDeviceManagerDialog.this.selectedItem.isDisposed()) {
                    return;
                }
                RemoteDeviceManagerDeviceItem selectItem = (RemoteDeviceManagerDeviceItem)RemoteDeviceManagerDialog.this.selectedItem.getData();
                RemoteDeviceManagerDialog.this.deviceItemsArray.remove(selectItem);
                RemoteDeviceManagerDialog.this.tableViewer.refresh();
                RemoteDeviceManagerDialog.this.writeDeviceUnits();
                if (RemoteDeviceManagerDialog.this.selectedItem != null && !RemoteDeviceManagerDialog.this.selectedItem.isDisposed()) {
                    RemoteDeviceManagerDialog.this.enableButtons(true);
                } else {
                    RemoteDeviceManagerDialog.this.enableButtons(false);
                }
            }
        });
        this.deleteButton.setLayoutData((Object)gd);
    }

    public boolean addDeviceInfo(String name, String ip, String port) {
        for (RemoteDeviceManagerDeviceItem item : this.deviceItemsArray) {
            if (!item.getIP().equals(ip) || !item.getPort().equals(port)) continue;
            DialogUtil.openErrorDialog((String)ConnectionUIMessages.Remote_Message_SameValue);
            return false;
        }
        if (this.isValidRemoteDevice(name, ip, port)) {
            this.addRemoteDeviceToTable(name, ip, port);
            this.writeDeviceUnits();
            return true;
        }
        return false;
    }

    public boolean modifyDeviceInfo(String name, String ip, String port) {
        if (this.selectedItem == null || this.selectedItem.isDisposed()) {
            return false;
        }
        RemoteDeviceManagerDeviceItem selectItem = (RemoteDeviceManagerDeviceItem)this.selectedItem.getData();
        for (RemoteDeviceManagerDeviceItem item : this.deviceItemsArray) {
            if (selectItem == item || !item.getIP().equals(ip) || !item.getPort().equals(port)) continue;
            DialogUtil.openErrorDialog((String)ConnectionUIMessages.Remote_Message_SameValue);
            return false;
        }
        if (this.isValidRemoteDevice(name, ip, port)) {
            selectItem.setName(name);
            selectItem.setIP(ip);
            selectItem.setPort(port);
            this.writeDeviceUnits();
            return true;
        }
        return false;
    }

    private void createTableArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout compLayout = new GridLayout(1, false);
        compLayout.marginTop = 7;
        compLayout.marginLeft = 20;
        compLayout.marginRight = 20;
        container.setLayout((Layout)compLayout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 218;
        container.setLayoutData((Object)gridData);
        this.createTable(container);
        this.readRemoteDeviceList();
        this.updateRemoteDeviceStateFromTargetToolbarManager();
        this.loadProgressImage();
    }

    private void createTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compLayout = new GridLayout(1, false);
        compLayout.verticalSpacing = 0;
        compLayout.marginTop = 0;
        compLayout.marginBottom = 0;
        compLayout.marginLeft = 0;
        compLayout.marginRight = 0;
        compLayout.marginWidth = 0;
        compLayout.marginHeight = 0;
        composite.setLayout((Layout)compLayout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        this.createTableHeaderArea(composite, compLayout, gd);
        Composite contentContainer = new Composite(composite, 0);
        contentContainer.setLayout((Layout)compLayout);
        gd = new GridData(768);
        gd.heightHint = 153;
        contentContainer.setLayoutData((Object)gd);
        this.tableViewer = new TableViewer(contentContainer, 67586);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer paramViewer, Object paramObject1, Object paramObject2) {
            }

            public Object[] getElements(Object paramObject) {
                return ((ArrayList)paramObject).toArray();
            }
        });
        this.tableViewer.setInput(this.deviceItemsArray);
        this.table = this.tableViewer.getTable();
        this.table.setVisible(true);
        this.table.setEnabled(true);
        this.table.setHeaderVisible(false);
        gd = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)gd);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDeviceManagerDialog.this.enableButtons(true);
            }
        });
        this.table.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (!scanWorker.isRunning()) {
                    return;
                }
                if (RemoteDeviceManagerDialog.this.progressImgIndex >= RemoteDeviceManagerDialog.this.imageDataList.size()) {
                    RemoteDeviceManagerDialog.this.progressImgIndex = 0;
                }
                Rectangle clientArea = RemoteDeviceManagerDialog.this.table.getClientArea();
                int xMiddle = clientArea.width / 2;
                int yMiddle = clientArea.height / 2;
                int xImgMiddle = RemoteDeviceManagerDialog.this.imageDataList.get((int)0).width / 2;
                int yimgMiddle = RemoteDeviceManagerDialog.this.imageDataList.get((int)0).height / 2;
                Image image = new Image((Device)event.display, RemoteDeviceManagerDialog.this.imageDataList.get(RemoteDeviceManagerDialog.this.progressImgIndex));
                event.gc.drawImage(image, xMiddle - xImgMiddle, yMiddle - yimgMiddle);
                Point e = event.gc.textExtent(ConnectionUIMessages.Remote_Device_Manager_Scanning, 8);
                event.gc.setForeground(RemoteDeviceManagerDialog.this.tableFontColor);
                event.gc.drawString(ConnectionUIMessages.Remote_Device_Manager_Scanning, xMiddle - e.x / 2, yMiddle - e.y / 2, true);
                image.dispose();
                RemoteDeviceManagerDialog remoteDeviceManagerDialog = RemoteDeviceManagerDialog.this;
                remoteDeviceManagerDialog.progressImgIndex = remoteDeviceManagerDialog.progressImgIndex + 1;
            }
        });
        this.table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                RemoteDeviceManagerDialog.this.table.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).RemoteDeviceManagerDialog.this.table.getVerticalBar().isVisible() || (this).RemoteDeviceManagerDialog.this.deviceItemsArray.size() > 6) {
                            RemoteDeviceManagerDialog.this.nameColumn.getColumn().setWidth(110);
                            RemoteDeviceManagerDialog.this.tableHeaderComposite.redraw();
                            RemoteDeviceManagerDialog.this.tableHeaderComposite.update();
                        } else if ((this).RemoteDeviceManagerDialog.this.deviceItemsArray.size() < 6) {
                            RemoteDeviceManagerDialog.this.nameColumn.getColumn().setWidth(127);
                            RemoteDeviceManagerDialog.this.tableHeaderComposite.redraw();
                            RemoteDeviceManagerDialog.this.tableHeaderComposite.update();
                        }
                    }
                });
            }
        });
        this.setTableColumn(parent);
        this.setButtonEventListener();
    }

    private void createTableHeaderArea(Composite composite, GridLayout compLayout, GridData gd) {
        this.tableHeaderComposite = new Composite(composite, 0);
        this.tableHeaderComposite.setLayout((Layout)compLayout);
        gd = new GridData(784);
        gd.heightHint = 28;
        this.tableHeaderComposite.setLayoutData((Object)gd);
        this.tableHeaderComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(RemoteDeviceManagerDialog.this.tableLineColor);
                e.gc.drawLine(0, 0, 470, 0);
                e.gc.drawLine(0, 0, 0, 28);
                e.gc.drawLine(419, 0, 419, 27);
                int columnWidth = 2;
                if (RemoteDeviceManagerDialog.this.table.getVerticalBar().isVisible() || RemoteDeviceManagerDialog.this.deviceItemsArray.size() > 6) {
                    columnWidth = 2;
                } else if (RemoteDeviceManagerDialog.this.deviceItemsArray.size() < 6) {
                    columnWidth = 19;
                }
                e.gc.setForeground(RemoteDeviceManagerDialog.this.tableFontColor);
                e.gc.drawText(ConnectionUIMessages.Remote_Device_Manager_Table_Header_Name, columnWidth + 20, 7, true);
                e.gc.setForeground(RemoteDeviceManagerDialog.this.tableLineColor);
                int top_margin = 8;
                e.gc.drawLine(columnWidth += 110, top_margin, columnWidth, 28 - top_margin);
                e.gc.setForeground(RemoteDeviceManagerDialog.this.tableFontColor);
                e.gc.drawText(ConnectionUIMessages.Remote_Device_Manager_Table_Header_Ip, columnWidth + 20, 7, true);
                e.gc.setForeground(RemoteDeviceManagerDialog.this.tableLineColor);
                e.gc.drawLine(columnWidth += 118, top_margin, columnWidth, 28 - top_margin);
                e.gc.setForeground(RemoteDeviceManagerDialog.this.tableFontColor);
                e.gc.drawText(ConnectionUIMessages.Remote_Device_Manager_Table_Header_Port, columnWidth + 20, 7, true);
                e.gc.setForeground(RemoteDeviceManagerDialog.this.tableLineColor);
                e.gc.drawLine(columnWidth += 80, top_margin, columnWidth, 28 - top_margin);
                e.gc.setForeground(RemoteDeviceManagerDialog.this.tableFontColor);
                e.gc.drawText(ConnectionUIMessages.Remote_Device_Manager_Table_Header_Connect, columnWidth + 20, 7, true);
                e.gc.setForeground(RemoteDeviceManagerDialog.this.tableLineColor);
            }
        });
    }

    private void setTableColumn(Composite parent) {
        this.nameColumn = new TableViewerColumn(this.tableViewer, 16384);
        this.nameColumn.setLabelProvider((CellLabelProvider)new RemoteDeviceManagerTableLabelProvider(this));
        this.nameColumn.getColumn().setWidth(110);
        TableViewerColumn ipColumn = new TableViewerColumn(this.tableViewer, 16384);
        ipColumn.setLabelProvider((CellLabelProvider)new RemoteDeviceManagerTableLabelProvider(this));
        ipColumn.getColumn().setWidth(118);
        TableViewerColumn portColumn = new TableViewerColumn(this.tableViewer, 16384);
        portColumn.setLabelProvider((CellLabelProvider)new RemoteDeviceManagerTableLabelProvider(this));
        portColumn.getColumn().setWidth(80);
        TableViewerColumn connectColumn = new TableViewerColumn(this.tableViewer, 16384);
        connectColumn.setLabelProvider((CellLabelProvider)new RemoteDeviceManagerTableLabelProvider(this));
        connectColumn.getColumn().setWidth(91);
    }

    private void setButtonEventListener() {
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    TableItem selItem;
                    if (RemoteDeviceManagerDialog.this.selectedItem != null && !RemoteDeviceManagerDialog.this.selectedItem.isDisposed()) {
                        RemoteDeviceManagerDialog.this.selectedItem.setData("isSelect", (Object)false);
                    }
                    if ((selItem = RemoteDeviceManagerDialog.this.table.getSelection()[0]) != null && !selItem.isDisposed()) {
                        selItem.setData("isSelect", (Object)true);
                        RemoteDeviceManagerDialog.this.selectedItem = selItem;
                    }
                    RemoteDeviceManagerDialog.this.tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    RemoteDeviceManagerDialog.this.tableViewer.refresh();
                }
            }
        });
        this.table.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                Point pt = new Point(event.x, event.y);
                ViewerCell cell = RemoteDeviceManagerDialog.this.tableViewer.getCell(pt);
                if (cell == null) {
                    for (RemoteDeviceManagerDeviceItem item : RemoteDeviceManagerDialog.this.deviceItemsArray) {
                        if (item.isHover()) {
                            RemoteDeviceManagerDialog.this.tableViewer.refresh();
                        }
                        item.enableHover(false);
                    }
                    return;
                }
                RemoteDeviceManagerDeviceItem selectItem = (RemoteDeviceManagerDeviceItem)cell.getElement();
                boolean hover = RemoteDeviceManagerDialog.this.isHoverConnectImage(event);
                if (hover == selectItem.isHover()) {
                    return;
                }
                for (RemoteDeviceManagerDeviceItem item : RemoteDeviceManagerDialog.this.deviceItemsArray) {
                    item.enableHover(false);
                }
                selectItem.enableHover(hover);
                RemoteDeviceManagerDialog.this.tableViewer.refresh();
            }
        });
        this.table.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (!RemoteDeviceManagerDialog.this.isHoverConnectImage(event)) {
                    return;
                }
                Point pt = new Point(event.x, event.y);
                ViewerCell cell = RemoteDeviceManagerDialog.this.tableViewer.getCell(pt);
                if (cell == null) {
                    return;
                }
                RemoteDeviceManagerDeviceItem selectItem = (RemoteDeviceManagerDeviceItem)cell.getElement();
                if (selectItem.isRunning()) {
                    return;
                }
                if (selectItem.isConnect()) {
                    RemoteDeviceManagerDialog.this.disconnectRemoteDevice();
                } else {
                    RemoteDeviceManagerDialog.this.connectRemoteDevice();
                }
            }
        });
    }

    protected Control createButtonBar(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout compLayout = new GridLayout(2, false);
        compLayout.marginRight = 20;
        compLayout.horizontalSpacing = 8;
        container.setLayout((Layout)compLayout);
        GridData gd = new GridData(1808);
        gd.horizontalAlignment = 3;
        gd.verticalAlignment = 2;
        container.setLayoutData((Object)gd);
        Button firstButton = null;
        Button seconderButton = null;
        if (OSChecker.isWindows()) {
            firstButton = this.createScanButton(container);
            seconderButton = this.createCloseButton(container, parent);
        } else {
            firstButton = this.createCloseButton(container, parent);
            seconderButton = this.createScanButton(container);
        }
        gd = new GridData();
        gd.horizontalAlignment = 3;
        gd.widthHint = 86;
        firstButton.setLayoutData((Object)gd);
        gd = new GridData();
        gd.widthHint = 86;
        gd.horizontalAlignment = 3;
        gd.grabExcessHorizontalSpace = true;
        seconderButton.setLayoutData((Object)gd);
        this.enableButtons(false);
        return container;
    }

    private Button createScanButton(Composite container) {
        this.scanButton = new Button(container, 8);
        this.scanButton.setText(ConnectionUIMessages.Remote_Device_Manager_Btn_Scan);
        this.scanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDeviceManagerDialog.this.enableScanButton(!scanWorker.isRunning());
                RemoteDeviceManagerDialog.this.scanDevice();
            }
        });
        return this.scanButton;
    }

    private Button createCloseButton(Composite container, final Composite parent) {
        this.closeButton = new Button(container, 8);
        this.closeButton.setText(ConnectionUIMessages.Remote_Device_Manager_Btn_Close);
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                scanWorker.finish();
                RemoteDeviceManagerDialog.this.writeDeviceUnits();
                parent.getShell().close();
            }
        });
        return this.closeButton;
    }

    private boolean isHoverConnectImage(Event event) {
        boolean isContainY;
        Point pt = new Point(event.x, event.y);
        ViewerCell cell = this.tableViewer.getCell(pt);
        if (cell == null) {
            return false;
        }
        if (cell.getColumnIndex() != 3) {
            return false;
        }
        boolean isContainX = cell.getBounds().x + 20 < pt.x && pt.x < cell.getBounds().x + 20 + this.connectedToggleOffImages.getBounds().width;
        boolean bl = isContainY = cell.getBounds().y + 4 < pt.y && pt.y < cell.getBounds().y + 4 + this.connectedToggleOffImages.getBounds().height;
        return isContainX && isContainY;
    }

    private void loadProgressImage() {
        ImageLoader loader = new ImageLoader();
        Bundle bundle = Platform.getBundle((String)"org.tizen.common.connection");
        Path path = new Path(PROGRESS_IMAGE);
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)path, null);
        InputStream in = null;
        if (fileURL == null) {
            return;
        }
        try {
            try {
                in = fileURL.openStream();
                loader.load(in);
                ImageData[] imageDataArray = loader.data;
                int n = loader.data.length;
                int n2 = 0;
                while (n2 < n) {
                    ImageData data = imageDataArray[n2];
                    if (data.width == 90) {
                        this.imageDataList.add(data);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                logger.error("Failed to find loading image", (Throwable)e);
                IOUtil.tryClose((Closeable)in);
            }
        }
        finally {
            IOUtil.tryClose((Closeable)in);
        }
    }

    private void writeDeviceUnits() {
        block6: {
            BufferedWriter out = null;
            try {
                try {
                    TableItem[] tableItems;
                    out = new BufferedWriter(new FileWriter(REMOTE_DEVICE_LIST_FILE));
                    TableItem[] tableItemArray = tableItems = this.table.getItems();
                    int n = tableItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem tableItem = tableItemArray[n2];
                        RemoteDeviceManagerDeviceItem selectItem = (RemoteDeviceManagerDeviceItem)tableItem.getData();
                        String remoteDeviceInfo = RemoteDeviceManagerDialog.makeRemoteDeviceInfo(selectItem.getName(), selectItem.getIP(), selectItem.getPort());
                        out.write(remoteDeviceInfo);
                        out.newLine();
                        ++n2;
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                    IOUtil.tryClose((Closeable)out);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(out);
                throw throwable;
            }
            IOUtil.tryClose((Closeable)out);
        }
    }

    public static String makeRemoteDeviceInfo(String name, String ip, String port) {
        return String.valueOf(name) + "/" + ip + "/" + port;
    }

    private void readRemoteDeviceList() {
        block10: {
            File file;
            BufferedReader br;
            FileReader fr;
            block9: {
                fr = null;
                br = null;
                file = new File(REMOTE_DEVICE_LIST_FILE);
                if (file.exists() && file.isFile()) break block9;
                FileUtil.createDirectory((File)file.getParentFile());
                FileUtil.createTextFile((File)file, (String)"", null);
                IOUtil.tryClose((Closeable)fr);
                IOUtil.tryClose(br);
                return;
            }
            try {
                fr = new FileReader(file);
                br = new BufferedReader(fr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    String[] deviceInfo = this.getRemoteDeviceInfoFromLine(line);
                    if (deviceInfo == null || deviceInfo.length != 3) continue;
                    this.addRemoteDeviceToTable(deviceInfo[0], deviceInfo[1], deviceInfo[2]);
                }
            }
            catch (FileNotFoundException e) {
                logger.error("Remote device file is not found", (Object)e.getMessage(), (Object)e);
                IOUtil.tryClose(fr);
                IOUtil.tryClose(br);
                break block10;
            }
            catch (IOException e) {
                try {
                    logger.error(e.getMessage(), (Throwable)e);
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtil.tryClose(fr);
                    IOUtil.tryClose(br);
                }
            }
            IOUtil.tryClose((Closeable)fr);
            IOUtil.tryClose((Closeable)br);
        }
    }

    private String[] getRemoteDeviceInfoFromLine(String line) {
        String[] deviceInfo = null;
        deviceInfo = line.split("/");
        return deviceInfo;
    }

    private void connectRemoteDevice() {
        SWTUtil.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (RemoteDeviceManagerDialog.this.selectedItem == null || RemoteDeviceManagerDialog.this.selectedItem.isDisposed()) {
                    return;
                }
                RemoteDeviceManagerDeviceItem RemoteDeviceManagerDeviceItem2 = null;
                RemoteDeviceManagerDeviceItem selecttem = (RemoteDeviceManagerDeviceItem)RemoteDeviceManagerDialog.this.selectedItem.getData();
                for (RemoteDeviceManagerDeviceItem item : RemoteDeviceManagerDialog.this.deviceItemsArray) {
                    if (!item.getIP().equals(selecttem.getIP()) || !item.getPort().equals(selecttem.getPort())) continue;
                    RemoteDeviceManagerDeviceItem2 = item;
                }
                try {
                    RemoteDeviceManagerDialog.this.tryToConnectDevice(selecttem.getIP(), selecttem.getPort(), RemoteDeviceManagerDeviceItem2);
                }
                catch (IOException err) {
                    DialogUtil.openErrorDialog((String)err.getMessage());
                }
            }
        });
    }

    private void disconnectRemoteDevice() {
        if (this.selectedItem == null || this.selectedItem.isDisposed()) {
            return;
        }
        final RemoteDeviceManagerDeviceItem selectItem = (RemoteDeviceManagerDeviceItem)this.selectedItem.getData();
        final String sdbDisconnectDeviceCommand = String.valueOf(SDB_DISCONNECT_CMD_PREFIX) + selectItem.getIP() + ":" + selectItem.getPort();
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                if (HostUtil.execute((String)sdbDisconnectDeviceCommand)) {
                    RemoteDeviceManagerDialog.this.updateRemoteDeviceState(selectItem.getIP(), selectItem.getPort(), false);
                }
            }
        });
        th.start();
    }

    private void tryToConnectDevice(final String deviceIP, final String devicePort, final RemoteDeviceManagerDeviceItem RemoteDeviceManagerDeviceItem2) throws IOException {
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                String sdbConnectDeviceCommand = String.valueOf(SDB_CONNECT_CMD_PREFIX) + deviceIP + ":" + devicePort;
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (RemoteDeviceManagerDeviceItem2 == null) {
                            return;
                        }
                        RemoteDeviceManagerDeviceItem2.enableRunning(true);
                        RemoteDeviceManagerDialog.this.tableViewer.refresh();
                    }
                });
                String retStr = HostUtil.returnExecute((String)sdbConnectDeviceCommand);
                if (retStr == null) {
                    return;
                }
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (RemoteDeviceManagerDeviceItem2 == null) {
                            return;
                        }
                        RemoteDeviceManagerDeviceItem2.enableRunning(false);
                        RemoteDeviceManagerDialog.this.tableViewer.refresh();
                    }
                });
                if (retStr.contains("failed")) {
                    try {
                        throw new IOException(retStr);
                    }
                    catch (IOException iOException) {
                        DialogUtil.openErrorDialog((String)(String.valueOf(retStr) + "\n\n" + ConnectionUIMessages.Remote_Device_Manager_Connect_failure));
                    }
                } else {
                    RemoteDeviceManagerDialog.this.updateRemoteDeviceState(deviceIP, devicePort, true);
                }
            }
        });
        th.start();
    }

    private void scanDevice() {
        if (!scanWorker.isRunning()) {
            Thread t = new Thread((Runnable)scanWorker, "Remote Scan Worker");
            t.start();
        } else {
            scanWorker.finish();
            this.enableScanButton(true);
            Thread t = this.getThreadByName("Remote Scan Worker");
            if (t == null) {
                return;
            }
            t.interrupt();
        }
    }

    private Thread getThreadByName(String threadName) {
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            if (!t.getName().equals(threadName)) continue;
            return t;
        }
        return null;
    }

    protected void enableScanButton(final boolean enabled) {
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (RemoteDeviceManagerDialog.this.scanButton.isDisposed()) {
                    return;
                }
                String name = ConnectionUIMessages.Remote_Device_Manager_Btn_Stop;
                if (enabled) {
                    name = ConnectionUIMessages.Remote_Device_Manager_Btn_Scan;
                }
                RemoteDeviceManagerDialog.this.scanButton.setText(name);
                RemoteDeviceManagerDialog.this.scanButton.redraw();
                RemoteDeviceManagerDialog.this.scanButton.update();
                RemoteDeviceManagerDialog.this.newButton.setEnabled(enabled);
                RemoteDeviceManagerDialog.this.editButton.setEnabled(false);
                RemoteDeviceManagerDialog.this.deleteButton.setEnabled(false);
            }
        });
    }

    private void enableButtons(boolean isEnable) {
        this.editButton.setEnabled(isEnable);
        this.deleteButton.setEnabled(isEnable);
    }

    private void updateRemoteDeviceState(String ip, String port, final boolean isConnected) {
        if (this.table.isDisposed()) {
            return;
        }
        for (final RemoteDeviceManagerDeviceItem item : this.deviceItemsArray) {
            if (!item.getIP().equals(ip) || !item.getPort().equals(port)) continue;
            this.table.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    item.enableConnect(isConnected);
                    RemoteDeviceManagerDialog.this.tableViewer.refresh();
                }
            });
            return;
        }
    }

    private void updateRemoteDeviceStateFromTargetToolbarManager() {
        TargetToolBarManager toolbarMgr = ConnectionPlugin.getDefault().getTargetToolBarManager();
        if (toolbarMgr == null) {
            return;
        }
        Collection<DeviceDescriptor> descs = toolbarMgr.getDeviceDescriptors().values();
        for (DeviceDescriptor desc : descs) {
            String info;
            String[] data;
            if (desc.getDeviceState() != 32 || (data = (info = desc.getIDevice().getSerialNumber()).split(":")).length <= 1) continue;
            this.updateRemoteDeviceState(data[0], data[1], true);
        }
    }

    protected void addRemoteDeviceToTable(String name, String ip, String port) {
        if (this.table.isDisposed()) {
            return;
        }
        for (RemoteDeviceManagerDeviceItem item : this.deviceItemsArray) {
            if (!item.getIP().equals(ip) || !item.getPort().equals(port)) continue;
            return;
        }
        this.deviceItemsArray.add(new RemoteDeviceManagerDeviceItem(name, ip, port));
        this.tableViewer.setInput(this.deviceItemsArray);
        this.updateRemoteDeviceStateFromTargetToolbarManager();
    }

    private Image findOrCreateImage(String path) {
        ImageDescriptor imageDescriptor = ConnectionPlugin.getImageDescriptorFromPlugin(path);
        if (imageDescriptor == null) {
            return null;
        }
        Image image = (Image)this.resManager.find((DeviceResourceDescriptor)imageDescriptor);
        if (image == null) {
            try {
                image = this.resManager.createImage(imageDescriptor);
            }
            catch (DeviceResourceException e) {
                logger.error(e.getMessage());
            }
        }
        return image;
    }

    protected boolean isValidRemoteDevice(String name, String ip, String port) {
        if (!name.equals("")) {
            Pattern ipPattern = Pattern.compile(IPADDRESS_PATTERN);
            Matcher ipMatcher = ipPattern.matcher(ip);
            if (ipMatcher.find()) {
                Pattern portPattern = Pattern.compile(PORT_PATTERN);
                Matcher portMatcher = portPattern.matcher(port);
                if (portMatcher.find()) {
                    return true;
                }
                DialogUtil.openErrorDialog((String)("\"" + port + "\" " + ConnectionUIMessages.Remote_Message_InvalidPort));
            } else {
                DialogUtil.openErrorDialog((String)("\"" + ip + "\" " + ConnectionUIMessages.Remote_Message_InvalidIp));
            }
        } else {
            DialogUtil.openErrorDialog((String)ConnectionUIMessages.Remote_Message_EmptyName);
        }
        return false;
    }

    protected boolean isResizable() {
        return false;
    }
}

