/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.ui.part.ViewPart;
import org.tizen.common.lv.manager.LVManager;
import org.tizen.common.lv.ui.LVLocalizationTab;
import org.tizen.common.lv.ui.LVOverviewTab;
import org.tizen.common.lv.ui.LVResourceTab;
import org.tizen.common.lv.ui.LVStringTab;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.ViewUtil;

public class LocalizationView
extends ViewPart
implements ISelectionListener,
IResourceChangeListener {
    public LVLocalizationTab tab_over;
    public LVLocalizationTab tab_str;
    public LVLocalizationTab tab_res;
    private ISelection currentSelection;
    protected IWorkbenchWindow workbenchWindow = ViewUtil.getWorkbenchWindow();
    public Composite compMain = null;
    public CTabFolder folder = null;
    private IProject project = null;

    public LocalizationView() {
        IStructuredSelection sel;
        Object res;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (selection instanceof IStructuredSelection && (res = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            this.project = ((IResource)res).getProject();
        }
        this.addListener();
    }

    private void addListener() {
        if (this.workbenchWindow != null && this.workbenchWindow.getSelectionService() != null) {
            this.workbenchWindow.getSelectionService().addPostSelectionListener((ISelectionListener)this);
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void removeListener() {
        if (this.workbenchWindow != null && this.workbenchWindow.getSelectionService() != null) {
            this.workbenchWindow.getSelectionService().removePostSelectionListener((ISelectionListener)this);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void createPartControl(Composite composite) {
        this.compMain = new Composite(composite, 0);
        this.compMain.setLayoutData((Object)new GridData(1040));
        this.compMain.setLayout((Layout)new GridLayout(1, false));
        this.folder = new CTabFolder(this.compMain, 3072);
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LVLocalizationTab currentTab = (LVLocalizationTab)(this).LocalizationView.this.folder.getSelection();
                        currentTab.outerTabSelected();
                        currentTab.selectionChanged(LocalizationView.this.currentSelection);
                    }
                });
            }
        });
        GridData data = new GridData(4, 4, true, true, 1, 1);
        this.folder.setLayoutData((Object)data);
        this.createOverviewTab(this.folder);
        this.createStringTab(this.folder);
        this.createResourceTab(this.folder);
    }

    public void setFocus() {
    }

    private void createOverviewTab(CTabFolder folder) {
        this.tab_over = new LVOverviewTab(this.project, folder);
        folder.setSelection((CTabItem)this.tab_over);
    }

    private void createStringTab(CTabFolder folder) {
        this.tab_str = new LVStringTab(this.project, folder);
    }

    private void createResourceTab(CTabFolder folder) {
        this.tab_res = new LVResourceTab(this.project, folder);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == null || selection == null || !(part instanceof ProjectExplorer)) {
            return;
        }
        if (selection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = selection;
        IProject newProject = this.getProject(part, selection);
        LVLocalizationTab currentTab = (LVLocalizationTab)this.folder.getSelection();
        if (this.isLocalizableProject(newProject)) {
            if (newProject.equals((Object)this.project)) {
                currentTab.selectionChanged(this.currentSelection);
                return;
            }
            this.project = newProject;
        } else {
            if (this.project == null) {
                return;
            }
            this.project = null;
        }
        LVManager.getManager(this.project);
        currentTab.projectChanged(this.project);
        currentTab.selectionChanged(this.currentSelection);
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (this.project == null) {
            return;
        }
        if (event.getType() == 4) {
            SWTUtil.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    LVManager.getManager(LocalizationView.this.project).projectDeleted(event);
                    LVLocalizationTab currentTab = (LVLocalizationTab)LocalizationView.this.folder.getSelection();
                    currentTab.notifyProjectDeleted();
                    currentTab.projectChanged(null);
                }
            });
        } else if (event.getType() == 1) {
            LVManager.getManager(this.project).updateDelta(event.getDelta());
            SWTUtil.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    LVLocalizationTab currentTab = (LVLocalizationTab)LocalizationView.this.folder.getSelection();
                    currentTab.resourceChanged();
                }
            });
        }
    }

    private IProject getProject(Object sourcePart, Object selection) {
        IProject tempProj = null;
        if (selection instanceof IStructuredSelection) {
            tempProj = this.getProject(((IStructuredSelection)selection).toArray());
        }
        return tempProj;
    }

    private IProject getProject(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r;
            Object element = objectArray[n2];
            if (element instanceof IAdaptable && (r = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null) {
                return r.getProject();
            }
            ++n2;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.removeListener();
        LVManager.getManager(this.project).clear();
    }

    public IProject getProject() {
        return this.project;
    }

    public void viewmodeChanged() {
        LVLocalizationTab.KEY_MODE = !LVLocalizationTab.KEY_MODE;
        this.tab_str.setDirty().viewmodeChanged();
        this.tab_res.setDirty().viewmodeChanged();
    }

    private boolean isLocalizableProject(IProject project) {
        boolean result = false;
        if (project != null && project.isOpen() && ProjectUtil.isTizenProject((IProject)project) && ProjectUtil.isTizenWebProject((IProject)project)) {
            result = true;
        }
        return result;
    }
}

