/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.logview.data;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.device.manager.data.DeviceDescriptor;
import org.tizen.device.manager.data.SettingsPageInfo;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.logview.data.LimitedQueue;
import org.tizen.device.manager.logview.data.Log;
import org.tizen.device.manager.logview.data.LogMatcher;
import org.tizen.device.manager.logview.parser.DlogParser_Mobile_2_4;
import org.tizen.device.manager.logview.parser.DlogParser_Mobile_3_0;
import org.tizen.device.manager.logview.parser.DlogParser_TV;
import org.tizen.device.manager.logview.parser.DlogParser_TV_4_0;
import org.tizen.device.manager.logview.parser.DlogParser_Wearable_2_3;
import org.tizen.device.manager.logview.parser.DlogParser_Wearable_3_0;
import org.tizen.device.manager.logview.parser.IDlogParser;
import org.tizen.device.manager.logview.service.LogModelChangedListener;
import org.tizen.device.manager.service.impl.SettingsInfoChangedListener;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.util.DeviceUtil;

public class LogModel {
    private DeviceDescriptor device;
    private LogMatcher logMatcher;
    private LimitedQueue<Log> logs;
    private IDlogParser dlogParser;
    private Thread logReceiverThread;
    private LogReceiver logReceiver;
    private int limitedBufferSize;
    private ArrayList<LogModelChangedListener> logModelChangedListeners;
    private SettingsInfoChangedListener settingsChangedListener = new SettingsInfoChangedListener(){

        @Override
        public void settingsInfoChanged(SettingsPageInfo settingsPageInfo) {
            int newSize = settingsPageInfo.getLogBufferSize();
            if (LogModel.this.limitedBufferSize != newSize) {
                LogModel.this.stopLogReceiverThread();
                LogModel.this.logs = new LimitedQueue(newSize);
                LogModel.this.limitedBufferSize = newSize;
                LogModel.this.startLogReceiverThread();
            }
        }
    };

    public LogModel(DeviceDescriptor device, LogMatcher logMatcher) throws Exception {
        this.device = device;
        this.logMatcher = logMatcher;
        this.logs = new LimitedQueue(SettingsPageInfo.getInstance().getLogBufferSize());
        this.limitedBufferSize = SettingsPageInfo.getInstance().getLogBufferSize();
        this.logModelChangedListeners = new ArrayList();
        this.logReceiver = new LogReceiver();
        SettingsPageInfo.getInstance().addChangedListener(this.settingsChangedListener);
        Pattern version_pattern = Pattern.compile("^.+\\-[.+\\-]*(\\d+[\\.\\d]+).*$");
        Matcher matcher = version_pattern.matcher(device.getPlatformName());
        if (matcher.matches()) {
            String profileName = device.getProfileName();
            String version = matcher.group(1);
            block5 : switch (profileName) {
                case "tv": {
                    switch (version) {
                        case "4.0": {
                            this.dlogParser = new DlogParser_TV_4_0();
                            break block5;
                        }
                    }
                    this.dlogParser = new DlogParser_TV();
                    break;
                }
                case "mobile": {
                    switch (version) {
                        case "4.0": 
                        case "3.0": {
                            this.dlogParser = new DlogParser_Mobile_3_0();
                            break block5;
                        }
                    }
                    this.dlogParser = new DlogParser_Mobile_2_4();
                    break;
                }
                case "wearable": {
                    switch (version) {
                        case "4.0": 
                        case "3.0": {
                            this.dlogParser = new DlogParser_Wearable_3_0();
                            break block5;
                        }
                    }
                    this.dlogParser = new DlogParser_Wearable_2_3();
                    break;
                }
                default: {
                    throw new Exception("cannot create parser for " + device.getPlatformName());
                }
            }
        } else {
            throw new Exception("cannot parse platform version for " + device.getPlatformName());
        }
    }

    private void startLogReceiverThread() {
        if (this.logReceiverThread != null) {
            this.logReceiverThread.interrupt();
        }
        this.logReceiverThread = new Thread(this.device.getSerialId() + " Logger"){

            @Override
            public void run() {
                while (!DeviceUtil.isOnline((IDevice)LogModel.this.device.getIDevice()) || LogModel.this.logReceiver == null || ((LogModel)LogModel.this).logReceiver.isCancelled) {
                    try {
                        2.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("LogModel : Device is not online or logger is null/cancelled");
                        return;
                    }
                }
                if (LogModel.this.logReceiver == null || ((LogModel)LogModel.this).logReceiver.isCancelled) {
                    return;
                }
                try {
                    String command = null;
                    command = String.format(LogModel.this.dlogParser.getDlogUtilCommandFormat(), "*");
                    LogModel.this.device.getIDevice().executeShellCommand(command, (IShellOutputReceiver)LogModel.this.logReceiver, 0, "ISO-8859-1");
                }
                catch (Exception e) {
                    DeviceLogger.getLogger().log(Level.FINE, e.getMessage());
                }
            }
        };
        this.logReceiverThread.start();
    }

    private void stopLogReceiverThread() {
        if (this.logReceiverThread != null) {
            this.logReceiverThread.interrupt();
        }
    }

    public LimitedQueue<Log> getLogs() {
        return this.logs;
    }

    public ArrayList<Log> getMatchedLogs() {
        ArrayList<Log> matchedLogs = new ArrayList<Log>();
        if (this.logMatcher.isEmptyMatcher()) {
            for (Log log : this.logs) {
                matchedLogs.add(log);
            }
        } else {
            for (Log log : this.logs) {
                if (!this.logMatcher.isMatched(log)) continue;
                matchedLogs.add(log);
            }
        }
        return matchedLogs;
    }

    public ArrayList<String> getUniqLogLevels() {
        ArrayList<String> levels = new ArrayList<String>();
        for (Log log : this.logs) {
            String level = log.getLevelName();
            if (levels.contains(level)) continue;
            levels.add(level);
        }
        return levels;
    }

    public ArrayList<String> getUniqPids() {
        ArrayList<String> pids = new ArrayList<String>();
        for (Log log : this.logs) {
            String pid = log.getPid();
            if (pids.contains(pid)) continue;
            pids.add(pid);
        }
        return pids;
    }

    public ArrayList<String> getUniqTids() {
        ArrayList<String> tids = new ArrayList<String>();
        for (Log log : this.logs) {
            String tid = log.getTid();
            if (tids.contains(tid)) continue;
            tids.add(tid);
        }
        return tids;
    }

    public ArrayList<String> getUniqTags() {
        ArrayList<String> tags = new ArrayList<String>();
        for (Log log : this.logs) {
            String tag = log.getTag();
            if (tags.contains(tag)) continue;
            tags.add(tag);
        }
        return tags;
    }

    public void addModelChangedListener(LogModelChangedListener listener) {
        this.logModelChangedListeners.add(listener);
    }

    public void removeModelChangedListener(LogModelChangedListener listener) {
        this.logModelChangedListeners.remove(listener);
    }

    public void listen() {
        this.startLogReceiverThread();
    }

    public void release() {
        this.stopLogReceiverThread();
    }

    public boolean isSameDevice(DeviceDescriptor targetDevice) {
        return this.device.getSerialId().equalsIgnoreCase(targetDevice.getSerialId()) && this.device.getDeviceName().equalsIgnoreCase(targetDevice.getDeviceName());
    }

    public void setDevice(DeviceDescriptor targetDevice) {
        this.device = targetDevice;
    }

    public ArrayList<String> getLogLevelCriterion() {
        return this.logMatcher.getLogLevel();
    }

    public ArrayList<String> getPidCriterion() {
        return this.logMatcher.getPids();
    }

    public ArrayList<String> getTidCriterion() {
        return this.logMatcher.getTids();
    }

    public ArrayList<String> getTagCriterion() {
        return this.logMatcher.getTags();
    }

    public void setLogLevelCriterion(ArrayList<String> levels) {
        this.logMatcher.setLogLevels(levels);
        for (LogModelChangedListener listener : this.logModelChangedListeners) {
            listener.matcherChanged(this.logMatcher);
        }
    }

    public void setPidCriterion(ArrayList<String> pids) {
        this.logMatcher.setPids(pids);
        for (LogModelChangedListener listener : this.logModelChangedListeners) {
            listener.matcherChanged(this.logMatcher);
        }
    }

    public void setTidCriterion(ArrayList<String> tids) {
        this.logMatcher.setTids(tids);
        for (LogModelChangedListener listener : this.logModelChangedListeners) {
            listener.matcherChanged(this.logMatcher);
        }
    }

    public void setTagCriterion(ArrayList<String> tags) {
        this.logMatcher.setTags(tags);
        for (LogModelChangedListener listener : this.logModelChangedListeners) {
            listener.matcherChanged(this.logMatcher);
        }
    }

    public void setMessageCriterion(ArrayList<String> messages) {
        this.logMatcher.setMessages(messages);
        for (LogModelChangedListener listener : this.logModelChangedListeners) {
            listener.matcherChanged(this.logMatcher);
        }
    }

    public void clearAllLogs() {
        this.logs.clear();
        for (LogModelChangedListener listener : this.logModelChangedListeners) {
            listener.logCleared();
        }
    }

    private class LogReceiver
    extends MultiLineReceiver {
        public boolean isCancelled = false;

        public LogReceiver() {
            this.setTrimLines(false);
        }

        public void processNewLines(String[] lines) {
            if (!this.isCancelled) {
                ArrayList<Log> matchedLogs = new ArrayList<Log>();
                ArrayList<Log> parsedLogs = LogModel.this.dlogParser.parse(lines);
                LogModel.this.logs.addAll(parsedLogs);
                for (Log log : parsedLogs) {
                    if (!LogModel.this.logMatcher.isMatched(log)) continue;
                    matchedLogs.add(log);
                }
                if (0 < matchedLogs.size()) {
                    for (LogModelChangedListener listener : LogModel.this.logModelChangedListeners) {
                        listener.logAdded(matchedLogs);
                    }
                }
            }
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }
    }
}

