/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.util;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.tizen.device.manager.util.IteratingAcceptor;
import org.tizen.device.manager.util.IteratingRunner;
import org.tizen.sdblib.util.Assert;
import org.tizen.sdblib.util.CollectionUtil;
import org.tizen.sdblib.util.ObjectUtil;

public class ArrayUtil {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static <T> boolean isEmpty(T[] array) {
        if (null == array) {
            return true;
        }
        return 0 == array.length;
    }

    public static <T> T pickupFirst(T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return null;
        }
        return array[0];
    }

    public static <T> T pickupLast(T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return null;
        }
        return array[array.length - 1];
    }

    public static <T> T[] newArray(Class<? extends T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> Iterator<T> iterator(T[] array) {
        return new ArrayIterator<T>(array);
    }

    public static <T> void iterate(T[] array, IteratingRunner<T> runner) {
        try {
            ArrayUtil.iterate(array, runner, true);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> void iterate(T[] array, IteratingRunner<T> runner, boolean bForceProcess) throws InvocationTargetException {
        if (null == runner) {
            return;
        }
        for (T arg : ArrayUtil.safe(array)) {
            if (null == arg && !bForceProcess) continue;
            try {
                runner.run(arg);
            }
            catch (Throwable e) {
                if (bForceProcess) continue;
                throw new InvocationTargetException(e);
            }
        }
    }

    public static <T> T[] filter(T[] array, IteratingAcceptor<T> runner) {
        try {
            return ArrayUtil.filter(array, runner, true);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T[] filter(T[] array, IteratingAcceptor<T> runner, boolean bForceProcess) throws InvocationTargetException {
        ArrayList<T> list = new ArrayList<T>();
        for (T arg : ArrayUtil.safe(array)) {
            if (null == arg && !bForceProcess) continue;
            try {
                if (!runner.accept(arg)) continue;
                list.add(arg);
            }
            catch (Throwable e) {
                if (bForceProcess) continue;
                throw new InvocationTargetException(e);
            }
        }
        return list.toArray(ArrayUtil.newArray(array.getClass().getComponentType(), list.size()));
    }

    public static Object[] toObjectArray(Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (null == source) {
            return EMPTY_OBJECT_ARRAY;
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("source must be an array");
        }
        int length = Array.getLength(source);
        if (0 == length) {
            return EMPTY_OBJECT_ARRAY;
        }
        Class<?> wrapperType = null;
        for (int i = 0; null == wrapperType && i < length; ++i) {
            Object obj = Array.get(source, 0);
            if (null == obj) continue;
            wrapperType = obj.getClass();
        }
        if (null == wrapperType) {
            return (Object[])source;
        }
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            newArray[i] = Array.get(source, i);
        }
        return newArray;
    }

    public static int size(Object obj) {
        if (obj instanceof Object[]) {
            return ArrayUtil.size((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return ArrayUtil.size((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return ArrayUtil.size((byte[])obj);
        }
        if (obj instanceof char[]) {
            return ArrayUtil.size((char[])obj);
        }
        if (obj instanceof short[]) {
            return ArrayUtil.size((short[])obj);
        }
        if (obj instanceof int[]) {
            return ArrayUtil.size((int[])obj);
        }
        if (obj instanceof long[]) {
            return ArrayUtil.size((long[])obj);
        }
        if (obj instanceof float[]) {
            return ArrayUtil.size((float[])obj);
        }
        if (obj instanceof double[]) {
            return ArrayUtil.size((double[])obj);
        }
        if (obj instanceof Collection) {
            return CollectionUtil.size((Collection)((Collection)obj));
        }
        return 0;
    }

    public static int size(boolean[] objs) {
        if (null == objs) {
            return 0;
        }
        return objs.length;
    }

    public static int size(byte[] objs) {
        if (null == objs) {
            return 0;
        }
        return objs.length;
    }

    public static int size(char[] objs) {
        if (null == objs) {
            return 0;
        }
        return objs.length;
    }

    public static int size(short[] objs) {
        if (null == objs) {
            return 0;
        }
        return objs.length;
    }

    public static int size(int[] objs) {
        if (null == objs) {
            return 0;
        }
        return objs.length;
    }

    public static int size(long[] objs) {
        if (null == objs) {
            return 0;
        }
        return objs.length;
    }

    public static int size(float[] objs) {
        if (null == objs) {
            return 0;
        }
        return objs.length;
    }

    public static int size(double[] objs) {
        if (null == objs) {
            return 0;
        }
        return objs.length;
    }

    public static <T> int size(T[] objs) {
        if (null == objs) {
            return 0;
        }
        return objs.length;
    }

    public static <T> T[] add(T[] array, T obj) {
        Class compType = Object.class;
        if (null != array) {
            compType = array.getClass().getComponentType();
        } else if (null != obj) {
            compType = obj.getClass();
        }
        int newArrLength = ArrayUtil.size(array) + 1;
        Object[] newArr = (Object[])Array.newInstance(compType, newArrLength);
        if (null != array) {
            System.arraycopy(array, 0, newArr, 0, array.length);
        }
        newArr[newArrLength - 1] = obj;
        return newArr;
    }

    public static <T> T[] prepend(T[] array, T obj) {
        Class compType = Object.class;
        if (null != array) {
            compType = array.getClass().getComponentType();
        } else if (null != obj) {
            compType = obj.getClass();
        }
        int newArrLength = ArrayUtil.size(array) + 1;
        Object[] newArr = (Object[])Array.newInstance(compType, newArrLength);
        if (null != array) {
            System.arraycopy(array, 0, newArr, 1, array.length);
        }
        newArr[0] = obj;
        return newArr;
    }

    public static <T> T[] remove(Object[] array, int start, int end) {
        Assert.notNull((Object)array);
        Assert.isTrue((start <= end ? 1 : 0) != 0, (String)("start indnex(" + start + ") is greater than end index(" + end + ")"));
        int startIndex = Math.max(0, start);
        int endIndex = Math.min(array.length, end);
        if (endIndex <= startIndex) {
            return array;
        }
        Class<?> compType = array.getClass().getComponentType();
        int removeSize = endIndex - startIndex;
        int newArrLength = ArrayUtil.size(array) - removeSize;
        Object[] newArr = (Object[])Array.newInstance(compType, newArrLength);
        System.arraycopy(array, 0, newArr, 0, startIndex);
        System.arraycopy(array, endIndex, newArr, startIndex, array.length - endIndex);
        return newArr;
    }

    public static <T> T[] remove(Object[] array, int index) {
        return ArrayUtil.remove(array, index, index + 1);
    }

    public static <K, V> boolean contains(K[] array, V element) {
        if (null == array) {
            return false;
        }
        for (K candidate : array) {
            if (!ObjectUtil.equals(candidate, element)) continue;
            return true;
        }
        return false;
    }

    public static <K> K get(K[] array, int index) {
        if (null == array) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        if (array.length <= index) {
            return null;
        }
        return array[index];
    }

    public static Boolean[] convertToWrapper(boolean[] array) {
        int nArray = ArrayUtil.size(array);
        Boolean[] ret = new Boolean[nArray];
        for (int i = 0; i < nArray; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static Byte[] convertToWrapper(byte[] array) {
        int nArray = ArrayUtil.size(array);
        Byte[] ret = new Byte[nArray];
        for (int i = 0; i < nArray; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static Character[] convertToWrapper(char[] array) {
        int nArray = ArrayUtil.size(array);
        Character[] ret = new Character[nArray];
        for (int i = 0; i < nArray; ++i) {
            ret[i] = Character.valueOf(array[i]);
        }
        return ret;
    }

    public static Short[] convertToWrapper(short[] array) {
        int nArray = ArrayUtil.size(array);
        Short[] ret = new Short[nArray];
        for (int i = 0; i < nArray; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static Integer[] convertToWrapper(int[] array) {
        int nArray = ArrayUtil.size(array);
        Integer[] ret = new Integer[nArray];
        for (int i = 0; i < nArray; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static Long[] convertToWrapper(long[] array) {
        int nArray = ArrayUtil.size(array);
        Long[] ret = new Long[nArray];
        for (int i = 0; i < nArray; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static Float[] convertToWrapper(float[] array) {
        int nArray = ArrayUtil.size(array);
        Float[] ret = new Float[nArray];
        for (int i = 0; i < nArray; ++i) {
            ret[i] = Float.valueOf(array[i]);
        }
        return ret;
    }

    public static Double[] convertToWrapper(double[] array) {
        int nArray = ArrayUtil.size(array);
        Double[] ret = new Double[nArray];
        for (int i = 0; i < nArray; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static <T> T[] safe(T[] unsafe) {
        return (Object[])ObjectUtil.nvl((Object[])new Object[][]{unsafe, EMPTY_OBJECT_ARRAY});
    }

    public static Object[] subarray(Object[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        int newSize = endIndexExclusive - startIndexInclusive;
        Class<?> type = array.getClass().getComponentType();
        if (newSize <= 0) {
            return (Object[])Array.newInstance(type, 0);
        }
        Object[] subarray = (Object[])Array.newInstance(type, newSize);
        System.arraycopy(array, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static class ArrayIterator<K>
    implements Iterator<K> {
        protected final K[] objs;
        protected final K[] origin;
        protected int index = 0;

        public ArrayIterator(K[] objs) {
            this.origin = objs;
            this.objs = null == this.origin ? null : (Object[])this.origin.clone();
        }

        @Override
        public boolean hasNext() {
            if (null == this.objs) {
                return false;
            }
            return this.index < this.objs.length;
        }

        @Override
        public K next() {
            if (null == this.objs) {
                throw new NoSuchElementException();
            }
            if (this.objs.length <= this.index) {
                throw new NoSuchElementException();
            }
            if (this.objs[this.index] != this.origin[this.index]) {
                throw new ConcurrentModificationException();
            }
            return this.objs[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

