/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.controller;

import java.io.IOException;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import org.tizen.device.manager.control.ButtonToggleEvent;
import org.tizen.device.manager.control.DeviceToggleButton;
import org.tizen.device.manager.model.RemoteDeviceItem;
import org.tizen.device.manager.service.impl.ActionProcessor;
import org.tizen.device.manager.ui.diaglog.FileDialogUtils;

public class RemoteConnectionCell
extends TableCell<RemoteDeviceItem, String> {
    private DeviceToggleButton deviceConnectButton;

    protected void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (this.isEmpty()) {
            this.setGraphic(null);
            return;
        }
        final RemoteDeviceItem remoteItem = (RemoteDeviceItem)this.getTableRow().getItem();
        if (item == null || remoteItem == null) {
            return;
        }
        this.deviceConnectButton = new DeviceToggleButton();
        this.deviceConnectButton.setOn((Boolean)remoteItem.connectionProperty().getValue());
        this.deviceConnectButton.setOnSelected(new EventHandler<ButtonToggleEvent>(){

            public void handle(ButtonToggleEvent event) {
                if (event.isSelected()) {
                    RemoteConnectionCell.this.clickConnected(remoteItem);
                } else {
                    RemoteConnectionCell.this.clickDisConnected(remoteItem);
                }
            }
        });
        this.setGraphic((Node)this.deviceConnectButton);
    }

    protected void clickConnected(RemoteDeviceItem remoteItem) {
        this.tryToConnectDevice(remoteItem);
    }

    protected void clickDisConnected(RemoteDeviceItem remoteItem) {
        this.tryToDisConnectDevice(remoteItem);
    }

    public static Callback<TableColumn<RemoteDeviceItem, String>, TableCell<RemoteDeviceItem, String>> extractor() {
        return new Callback<TableColumn<RemoteDeviceItem, String>, TableCell<RemoteDeviceItem, String>>(){

            public TableCell<RemoteDeviceItem, String> call(TableColumn<RemoteDeviceItem, String> param) {
                RemoteConnectionCell cell = new RemoteConnectionCell();
                return cell;
            }
        };
    }

    private void tryToConnectDevice(final RemoteDeviceItem remoteDeviceItem) {
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (null == remoteDeviceItem) {
                            return;
                        }
                        remoteDeviceItem.setRunning(true);
                    }
                });
                String retStr = "";
                try {
                    retStr = ActionProcessor.remoteDeviceConnect(remoteDeviceItem.ipProperty().getValue(), remoteDeviceItem.portProperty().getValue());
                }
                catch (IOException e) {
                    FileDialogUtils.remoteDeviceConnectErrorMessage(e.getMessage());
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RemoteConnectionCell.this.deviceConnectButton.setOn(false);
                        remoteDeviceItem.setRunning(false);
                    }
                });
                if (retStr.contains("failed")) {
                    final String message = retStr;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FileDialogUtils.remoteDeviceConnectErrorMessage(message);
                        }
                    });
                } else {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            RemoteConnectionCell.this.deviceConnectButton.setOn(true);
                            remoteDeviceItem.setConnect(true);
                        }
                    });
                }
            }
        });
        th.start();
    }

    private void tryToDisConnectDevice(final RemoteDeviceItem remoteDeviceItem) {
        if (null == remoteDeviceItem) {
            return;
        }
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        boolean isSuccess = ActionProcessor.remoteDeviceDisConnect(remoteDeviceItem.ipProperty().getValue(), remoteDeviceItem.portProperty().getValue());
                        if (isSuccess) {
                            remoteDeviceItem.setConnect(false);
                        }
                    }
                });
            }
        });
        th.start();
    }
}

