/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.file.explorer;

import org.tizen.device.manager.data.DeviceDescriptor;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.FileEntryType;

public class FileEntryTreeData {
    private TreeItemState treeItemState = TreeItemState.CHILD_NOT_CHECKED;
    private final FileEntry entry;

    public FileEntryTreeData(DeviceDescriptor deviceDesc) {
        this.entry = deviceDesc == null || deviceDesc.getIDevice() == null ? null : deviceDesc.getIDevice().getRoot();
    }

    public FileEntryTreeData(FileEntry entry) {
        this.entry = entry;
    }

    public boolean isDirectory() {
        if (this.entry == null) {
            return false;
        }
        return this.entry.isDirectory();
    }

    public String getFileName() {
        return this.entry.getName();
    }

    public FileEntryTypeState getFileType() {
        FileEntryTypeState entryType = FileEntryTypeState.TYPE_OTHER;
        if (this.entry.getType() == FileEntryType.File) {
            entryType = FileEntryTypeState.TYPE_FILE;
        } else if (this.entry.getType() == FileEntryType.Link) {
            entryType = FileEntryTypeState.TYPE_FILE_LINK;
        } else if (this.entry.getType() == FileEntryType.Directory) {
            entryType = FileEntryTypeState.TYPE_DIRECTORY;
        } else if (this.entry.getType() == FileEntryType.DirectoryLink) {
            entryType = FileEntryTypeState.TYPE_DIRECTORY_LINK;
        } else if (this.entry.getType() == FileEntryType.RootEmulator) {
            entryType = FileEntryTypeState.TYPE_ROOT_EMULATOR;
        } else if (this.entry.getType() == FileEntryType.RootDevice) {
            entryType = FileEntryTypeState.TYPE_ROOT_DEVICE;
        }
        return entryType;
    }

    public FileEntry getFileEntry() {
        return this.entry;
    }

    public String getFullPath() {
        return this.entry.getFullPath();
    }

    public void setTreeItemState(TreeItemState state) {
        this.treeItemState = state;
    }

    public boolean isChildChecking() {
        return this.treeItemState == TreeItemState.CHILD_CHECKING;
    }

    public boolean isChildChecked() {
        return this.treeItemState == TreeItemState.CHILD_CHECKED;
    }

    public static enum FileEntryTypeState {
        TYPE_FILE,
        TYPE_FILE_LINK,
        TYPE_DIRECTORY,
        TYPE_DIRECTORY_LINK,
        TYPE_ROOT_EMULATOR,
        TYPE_ROOT_DEVICE,
        TYPE_OTHER;

    }

    public static enum TreeItemState {
        CHILD_NOT_CHECKED,
        CHILD_CHECKING,
        CHILD_CHECKED;

    }
}

