/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.controller;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import org.tizen.device.manager.control.ButtonToggleEvent;
import org.tizen.device.manager.control.DeviceToggleButton;
import org.tizen.device.manager.controller.RemoteDeviceConnectController;
import org.tizen.device.manager.data.DeviceStateType;
import org.tizen.device.manager.model.DeviceItem;

class DeviceConnectionCell
extends TableCell<DeviceItem, String> {
    private DeviceToggleButton deviceConnectButton;

    DeviceConnectionCell() {
    }

    protected void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (this.isEmpty()) {
            this.setGraphic(null);
            return;
        }
        final DeviceItem deviceItem = (DeviceItem)this.getTableRow().getItem();
        if (item == null || deviceItem == null) {
            return;
        }
        this.deviceConnectButton = new DeviceToggleButton();
        if (deviceItem.connectProperty().getValue().equalsIgnoreCase(DeviceStateType.OFFLINE.name())) {
            this.deviceConnectButton.setOn(false);
        } else {
            this.deviceConnectButton.setOn(true);
        }
        if (!deviceItem.getDeviceType().isRemoteDevice()) {
            this.deviceConnectButton.setDisableLabel(true);
        }
        this.deviceConnectButton.setOnSelected(new EventHandler<ButtonToggleEvent>(){

            public void handle(ButtonToggleEvent event) {
                if (event.isSelected()) {
                    deviceItem.connectProperty().set(DeviceStateType.ONLINE.name());
                    DeviceConnectionCell.this.clickConnected(deviceItem);
                } else {
                    deviceItem.connectProperty().set(DeviceStateType.OFFLINE.name());
                    DeviceConnectionCell.this.clickDisConnected(deviceItem);
                }
            }
        });
        this.setGraphic((Node)this.deviceConnectButton);
    }

    protected void clickConnected(DeviceItem deviceItem) {
        RemoteDeviceConnectController.tryToConnectDevice(deviceItem);
    }

    protected void clickDisConnected(DeviceItem deviceItem) {
        RemoteDeviceConnectController.tryToDisConnectDevice(deviceItem);
    }

    static Callback<TableColumn<DeviceItem, String>, TableCell<DeviceItem, String>> extractor() {
        return new Callback<TableColumn<DeviceItem, String>, TableCell<DeviceItem, String>>(){

            public TableCell<DeviceItem, String> call(TableColumn<DeviceItem, String> param) {
                DeviceConnectionCell cell = new DeviceConnectionCell();
                cell.getStyleClass().add((Object)"device-connection-cell");
                return cell;
            }
        };
    }
}

