/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.control;

import java.util.ArrayList;

public enum SignDUIDVersionController {
    V0("", 0),
    V1("1.0", 1),
    V2("2.0", 2),
    VD("-", 3);

    private final String prefix;
    public final int code;

    private SignDUIDVersionController(String prefix, int code) {
        this.prefix = prefix;
        this.code = code;
    }

    public String getPrefix() {
        return this.prefix.equals("") ? "" : this.prefix + "#";
    }

    public static SignDUIDVersionController getVersion(String duid) {
        String prefix = !duid.contains("#") ? "" : duid.split("#")[0];
        for (SignDUIDVersionController deviceVersion : SignDUIDVersionController.values()) {
            if (!deviceVersion.prefix.equals(prefix)) continue;
            return deviceVersion;
        }
        throw new IllegalArgumentException("Non-compatible Duid");
    }

    public static String getNoPrefixDuid(String duid) {
        return !duid.contains("#") ? duid : duid.split("#")[1];
    }

    public static ArrayList<String> getNoPrefixDuids(ArrayList<String> duids) {
        ArrayList<String> list = new ArrayList<String>();
        for (String duid : duids) {
            list.add(SignDUIDVersionController.getNoPrefixDuid(duid));
        }
        return list;
    }
}

