/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.ui.diaglog;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import org.tizen.device.manager.resources.FontKind;
import org.tizen.device.manager.resources.Fonts;
import org.tizen.device.manager.ui.diaglog.ButtonType;
import org.tizen.device.manager.ui.diaglog.Dialog;

public class FilePushProgressDialog {
    private Label msgLabel;
    private Label toLabel;
    private Label fromLabel;
    private Label sizeLabel;
    private ProgressBar progressBar;
    private Double totalWork = 0.0;
    private Double sumWorkValue = 0.0;
    private Button cancelButton;
    private Dialog<String> dialog;
    private String titleName;
    private String msgName;

    public FilePushProgressDialog(String titleName, String msgName) {
        this.titleName = titleName;
        this.msgName = msgName;
        this.createContents();
    }

    public void createContents() {
        this.dialog = new Dialog();
        this.dialog.setTitle(this.titleName);
        this.dialog.setResizable(false);
        this.dialog.getDialogPane().addButonType(ButtonType.CANCEL);
        this.dialog.getDialogPane().getPane().setPrefWidth(350.0);
        BorderPane mainPane = new BorderPane();
        VBox mainVBox = new VBox();
        mainVBox.setAlignment(Pos.BASELINE_LEFT);
        mainVBox.setSpacing(5.0);
        mainVBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.msgLabel = new Label(this.msgName);
        this.msgLabel.setFont(Fonts.get(FontKind.FONT_14));
        this.toLabel = new Label();
        this.fromLabel = new Label();
        this.sizeLabel = new Label();
        this.progressBar = new ProgressBar(-1.0);
        this.progressBar.setPadding(new Insets(5.0, 5.0, 0.0, 0.0));
        this.progressBar.setPrefWidth(this.dialog.getDialogPane().getPane().getPrefWidth());
        mainVBox.getChildren().addAll((Object[])new Node[]{this.msgLabel, this.progressBar, this.fromLabel, this.toLabel, this.sizeLabel});
        mainPane.setCenter((Node)mainVBox);
        this.cancelButton = this.dialog.getDialogPane().getButton(ButtonType.CANCEL);
        this.cancelButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FilePushProgressDialog.this.cancelButton.setDisable(true);
                FilePushProgressDialog.this.progressBar.progressProperty().unbind();
                FilePushProgressDialog.this.progressBar.setProgress(0.0);
            }
        });
        this.dialog.getDialogPane().setContent((Node)mainPane);
        this.dialog.show();
    }

    public void setProgressBar(Double workLoad) {
        if (this.totalWork <= 0.0) {
            return;
        }
        this.sumWorkValue = this.sumWorkValue + workLoad;
        double workValue = 0.0;
        if (this.totalWork != 0.0) {
            workValue = this.sumWorkValue / this.totalWork;
        }
        this.progressBar.setProgress(workValue);
    }

    public void setDone() {
        if (!this.sumWorkValue.equals(this.totalWork)) {
            return;
        }
        this.dialog.close();
    }

    public boolean isCanceled() {
        return this.cancelButton.isDisable();
    }

    public Double getTotalWork() {
        return this.totalWork;
    }

    public void setTotalWork(Double totalWork) {
        this.totalWork = totalWork;
    }

    public Label getMsgLabel() {
        return this.msgLabel;
    }

    public void setMsgLabel(Label msgLabel) {
        this.msgLabel = msgLabel;
    }

    public Label getToLabel() {
        return this.toLabel;
    }

    public void setToLabel(Label toLabel) {
        this.toLabel = toLabel;
    }

    public Label getFromLabel() {
        return this.fromLabel;
    }

    public void setFromLabel(Label fromLabel) {
        this.fromLabel = fromLabel;
    }

    public Label getSizeLabel() {
        return this.sizeLabel;
    }

    public void setSizeLabel(Label sizeLabel) {
        this.sizeLabel = sizeLabel;
    }

    public Dialog<String> getDialog() {
        return this.dialog;
    }
}

