/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.resources;

import java.util.concurrent.Executors;

public final class ThreadFactory
implements java.util.concurrent.ThreadFactory {
    static final ThreadFactory threadFactory = new ThreadFactory(false, "DefaultThread");
    static final ThreadFactory daemonThreadFactory = new ThreadFactory(true, "DefaultDaemonThread");
    final boolean isDaemon;
    final String name;

    private ThreadFactory(boolean isDaemon, String name) {
        this.isDaemon = isDaemon;
        this.name = name;
    }

    public static ThreadFactory getThreadFactory() {
        return threadFactory;
    }

    public static ThreadFactory getDaemonThreadFactory() {
        return daemonThreadFactory;
    }

    public static Thread getNewThread(Runnable r, String name) {
        Thread t = threadFactory.newThread(r);
        t.setName(name);
        return t;
    }

    public static Thread getNewDaemonThread(Runnable r, String name) {
        Thread t = daemonThreadFactory.newThread(r);
        t.setName(name);
        return t;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = Executors.defaultThreadFactory().newThread(r);
        t.setDaemon(this.isDaemon);
        return t;
    }
}

