/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib;

import java.io.IOException;
import org.tizen.sdblib.Device;
import org.tizen.sdblib.SdbHelper;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;

public class PlatformInfo {
    private String modelName;
    private String platformName;
    private String platformVersion;
    private String profileName;

    public PlatformInfo(Device device) throws TimeoutException, SdbCommandRejectedException, IOException {
        byte[] reqBytes = SdbHelper.sendServiceRequest(SmartDevelopmentBridge.getBridge(), device, "sysinfo:", 512);
        byte[] tmpByte = new byte[64];
        System.arraycopy(reqBytes, 64, tmpByte, 0, 64);
        this.modelName = SdbHelper.replyToString(tmpByte).trim();
        System.arraycopy(reqBytes, 128, tmpByte, 0, 64);
        this.platformName = SdbHelper.replyToString(tmpByte).trim();
        System.arraycopy(reqBytes, 192, tmpByte, 0, 64);
        this.platformVersion = SdbHelper.replyToString(tmpByte).trim();
        System.arraycopy(reqBytes, 256, tmpByte, 0, 64);
        this.profileName = SdbHelper.replyToString(tmpByte).trim();
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String toString() {
        String format = "model: %s, platform: %s, version: %s, profile: %s";
        return String.format(format, this.modelName, this.platformName, this.platformVersion, this.profileName);
    }
}

