/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.control;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import javafx.scene.control.TreeView;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.control.SDBAppLaunchCommand;
import org.tizen.device.manager.control.SignDUIDVersionController;
import org.tizen.device.manager.file.explorer.FileEntryTreeData;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.model.DeviceEventHandler;
import org.tizen.device.manager.model.DeviceItem;
import org.tizen.device.manager.ui.diaglog.ButtonBar;
import org.tizen.device.manager.ui.diaglog.ButtonType;
import org.tizen.device.manager.ui.diaglog.FileDialogUtils;
import org.tizen.sdblib.IDevice;
import security.ProfileParser;

public class SigningProfileUtilController {
    private static final String DEVICE_PROFILE_NAME = "device-profile.xml";
    private static final String PROFILE_ROOT = "profile";
    private static final String PROFILE_FILE_NAME = "profiles.xml";
    private static final String ROOT_ATTR_ACTIVE = "active";
    private static final String PROFILE_ELEMENT = "profile";
    private static final String PROFILE_ATTR_NAME = "name";
    public static final String PROFILEITEM_ELEMENT = "profileitem";
    public static final String PROFILEITEM_ATTR_KEY = "key";
    private static final int UNKNOWN_ACTIVE_PROFILE = 1;
    private static final int NO_DUID_ON_DEVICE = 2;
    private static final int NO_DUID_ON_CERT = 3;
    private static final int NO_DUID_MATCH = 4;
    private static final int PUSH_CERT_FAIL = 5;
    private static final int UNKNOWN_DEVICE = 6;
    private static FileEntryTreeData retrySelectTreeData;
    private static TreeView<FileEntryTreeData> retrySelectTreeView;
    private static DeviceItem deviceItem;

    public static void setRetryTreeviewData(FileEntryTreeData treeData, TreeView<FileEntryTreeData> treeView, DeviceItem selectDeviceItem) {
        retrySelectTreeData = treeData;
        retrySelectTreeView = treeView;
        deviceItem = selectDeviceItem;
    }

    /*
     * Exception decompiling
     */
    public static File activeSignDeviceProfilePath() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getCertTargetPath(IDevice targetDevice) {
        String certPath = "/home/developer";
        try {
            if (SDBAppLaunchCommand.isSameOrBiggerThanVersion3(targetDevice.getPlatformInfo().getPlatformVersion())) {
                certPath = targetDevice.getPlatformCapability().getSdkToolPath();
            }
        }
        catch (IllegalArgumentException e) {
            try {
                String unknownPlatformVersion = targetDevice.getPlatformCapability().getPlatformVersion();
                if (unknownPlatformVersion.equals("unknown")) {
                    DeviceLogger.getLogger().log(Level.SEVERE, "unknown platform", e);
                    SigningProfileUtilController.showErrorMessage(6);
                    return null;
                }
            }
            catch (Exception e1) {
                DeviceLogger.getLogger().log(Level.SEVERE, "unknown platform", e1);
                SigningProfileUtilController.showErrorMessage(5);
                return null;
            }
        }
        catch (Exception e) {
            DeviceLogger.getLogger().log(Level.SEVERE, "failed to get platform version", e);
            SigningProfileUtilController.showErrorMessage(5);
            return null;
        }
        return certPath;
    }

    public static boolean checkDUIDTOTagetDevice(IDevice targetDevice, String registrationPath) {
        try {
            String DUID = targetDevice.getDUID();
            if (null == DUID) {
                SigningProfileUtilController.showErrorMessage(2);
                return false;
            }
            String targetDUID = SignDUIDVersionController.getNoPrefixDuid(DUID);
            ArrayList<String> profileDUIDs = ProfileParser.getDUID(registrationPath);
            ArrayList<String> certDUIDs = SignDUIDVersionController.getNoPrefixDuids(profileDUIDs);
            if (null == certDUIDs || certDUIDs.size() == 0) {
                SigningProfileUtilController.showErrorMessage(3);
                return false;
            }
            for (String certDUID : certDUIDs) {
                if (!targetDUID.equals(certDUID)) continue;
                return true;
            }
            SigningProfileUtilController.showErrorMessage(4);
            return false;
        }
        catch (Exception e) {
            DeviceLogger.getLogger().log(Level.SEVERE, "failed to get the DUID", e);
            SigningProfileUtilController.showErrorMessage(5);
            return false;
        }
    }

    private static void showErrorMessage(int returnCode) {
        ButtonType result = null;
        switch (returnCode) {
            case 1: {
                result = FileDialogUtils.permitToInstallErrorMessageToPopup(Messages.FileDialog_Permit_To_Install_Active_Profile_Error_Message);
                break;
            }
            case 2: {
                result = FileDialogUtils.permitToInstallInfoMessage(Messages.FileDialog_Permit_To_Install_NO_DUID_ON_DEVICE_Error_Message);
                break;
            }
            case 3: {
                result = FileDialogUtils.permitToInstallInfoMessage(Messages.FileDialog_Permit_To_Install_NO_DUID_ON_CERT_Error_Message);
                break;
            }
            case 4: {
                result = FileDialogUtils.permitToInstallInfoMessageToPopup(Messages.FileDialog_Permit_To_Install_NO_DUID_MATCH_Error_Message);
                break;
            }
            case 5: {
                result = FileDialogUtils.permitToInstallErrorMessage(Messages.FileDialog_Permit_To_Install_PUSH_CERT_FAIL_Error_Message);
                break;
            }
            case 6: {
                result = FileDialogUtils.permitToInstallErrorMessage(Messages.FileDialog_Permit_To_Install_UNKNOWN_DEVICE_Error_Message);
                break;
            }
        }
        if (result != null && result.getButtonData() == ButtonBar.ButtonData.RETRY_GO && deviceItem != null) {
            DeviceEventHandler.permitToInstall(deviceItem);
        }
    }

    private static InputStream openFileStream(File file) {
        try {
            if (file.exists()) {
                return new FileInputStream(file);
            }
        }
        catch (IllegalStateException e) {
            DeviceLogger.getLogger().log(Level.SEVERE, "Can't access state location", e);
        }
        catch (FileNotFoundException e) {
            DeviceLogger.getLogger().log(Level.SEVERE, "Can't open profile", e);
        }
        return null;
    }
}

