/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib;

import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.tizen.sdb.Channel;
import org.tizen.sdb.command.Devices;
import org.tizen.sdb.item.DeviceItem;
import org.tizen.sdblib.Device;
import org.tizen.sdblib.DeviceState;
import org.tizen.sdblib.PlatformType;
import org.tizen.sdblib.SdbHelper;
import org.tizen.sdblib.SdbResponse;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.daemon.AbstractServer;
import org.tizen.sdblib.daemon.ServerState;
import org.tizen.sdblib.exception.ServerException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.util.DeviceUtil;
import org.tizen.sdblib.util.Log;
import org.tizen.sdblib.util.ThreadUtil;

class DeviceMonitor
extends AbstractServer {
    protected final SmartDevelopmentBridge bridge;
    protected List<Device> devices = null;
    private boolean mConnection = false;
    private boolean mMonitoring = false;
    private int mRestartAttemptCount = 0;
    private boolean mDeviceListInitialized = false;
    private SocketChannel mMainSdbConnection = null;

    DeviceMonitor(SmartDevelopmentBridge bridge) {
        super("Devices Monitor");
        this.bridge = bridge;
    }

    boolean isMonitoring() {
        return this.mMonitoring;
    }

    int getRestartAttemptCount() {
        return this.mRestartAttemptCount;
    }

    boolean isDeviceListInitialized() {
        return this.mDeviceListInitialized;
    }

    public synchronized Device[] getDevices() {
        while (this.devices == null) {
            if (this.devices != null) continue;
            return new Device[0];
        }
        return this.devices.toArray(new Device[this.devices.size()]);
    }

    protected synchronized void removeDevice(Device device) {
        this.devices.remove(device);
    }

    SmartDevelopmentBridge getServer() {
        return this.bridge;
    }

    private void handleExceptioninMonitorLoop(Exception e) {
        if (this.isState(ServerState.Running)) {
            if (e instanceof TimeoutException) {
                Log.d("DeviceMonitor", "sdb connection Error: timeout");
            } else {
                Log.e("DeviceMonitor", "sdb connection Error:" + e.getMessage());
            }
            this.mMonitoring = false;
            this.mConnection = false;
            if (SmartDevelopmentBridge.getBridge() != null && SmartDevelopmentBridge.getBridge().isTims()) {
                return;
            }
            if (this.mMainSdbConnection != null) {
                try {
                    this.mMainSdbConnection.close();
                }
                catch (IOException ioe) {
                    Log.e("sdb", "close main sdb connection failed:" + ioe);
                }
                this.mMainSdbConnection = null;
            }
        }
    }

    private SocketChannel openSdbConnection() {
        Log.d("DeviceMonitor", "connecting to sdb for Device List Monitoring...");
        try {
            SocketChannel channel = SmartDevelopmentBridge.getBridge().openChannel();
            this.bridge.setStarted(true);
            return channel;
        }
        catch (IOException e) {
            Log.e("DeviceMonitor", "Failed to open socket channel");
            Log.e("DeviceMonitor", e);
            return null;
        }
    }

    private boolean sendDeviceListMonitoringRequest() throws TimeoutException, IOException {
        if (this.mMainSdbConnection == null) {
            return false;
        }
        byte[] request = SdbHelper.formSdbRequest("host:track-devices");
        Log.d("DeviceMonitor", "send monitoring request");
        try {
            SdbHelper.write(this.mMainSdbConnection, request);
            SdbResponse resp = SdbHelper.readSdbResponse(this.mMainSdbConnection);
            if (!resp.okay) {
                Log.e("DeviceMonitor", "sdb refused request: " + resp.message);
            }
            return resp.okay;
        }
        catch (IOException e) {
            Log.e("DeviceMonitor", "sending tracking request failed!");
            this.mMainSdbConnection.close();
            throw e;
        }
    }

    private void processIncomingDeviceData(int length) throws IOException {
        ArrayList<Device> list = new ArrayList<Device>();
        if (length > 0) {
            String[] devices;
            byte[] buffer = new byte[length];
            String result = SdbHelper.readAsString(this.mMainSdbConnection, buffer);
            String[] stringArray = devices = result.split("\n");
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                String d = stringArray[n2];
                Log.d("DeviceMonitor", "deviceData: " + d);
                String[] param = d.split("\t");
                if (param.length == 3) {
                    String serialNumber = param[0].trim();
                    DeviceState state = DeviceState.getState(param[1].trim());
                    String deviceName = param[2].trim();
                    Device device = new Device(this, serialNumber, state, deviceName);
                    list.add(device);
                    Log.d("DeviceMonitor", "deviceData: " + device.getSerialNumber() + " added to list");
                }
                ++n2;
            }
        }
        this.updateDevices(list);
    }

    private int readLength(SocketChannel socket) throws IOException {
        String msg = SdbHelper.readAsString(socket, new byte[4]);
        try {
            return Integer.parseInt(msg, 16);
        }
        catch (NumberFormatException nfe) {
            Log.e("sdb", "parse integer failed:" + nfe);
            throw new IOException("Unable to read length");
        }
    }

    private void processDeviceData(DeviceItem[] devices) throws IOException {
        ArrayList<Device> list = new ArrayList<Device>();
        DeviceItem[] deviceItemArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceItem device = deviceItemArray[n2];
            list.add(new Device(this, device.getSerial(), DeviceState.getState(device.getState()), device.getName()));
            Log.d("DeviceMonitor", "deviceData: " + device.getSerial() + " added to list");
            ++n2;
        }
        this.updateDevices(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDevices(ArrayList<Device> newList) throws AsynchronousCloseException, IOException {
        Object object = SmartDevelopmentBridge.getLock();
        synchronized (object) {
            ArrayList<Device> devicesToQuery = new ArrayList<Device>();
            if (this.devices == null) {
                this.devices = new ArrayList<Device>();
            }
            DeviceMonitor deviceMonitor = this;
            synchronized (deviceMonitor) {
                int d = 0;
                while (d < this.devices.size()) {
                    Device device = this.devices.get(d);
                    int count = newList.size();
                    boolean foundMatch = false;
                    int dd = 0;
                    while (dd < count) {
                        Device newDevice = newList.get(dd);
                        if (newDevice.getSerialNumber().equals(device.getSerialNumber())) {
                            foundMatch = true;
                            if (!device.getDeviceName().equals(newDevice.getDeviceName())) {
                                device.update(3, newDevice.getDeviceName());
                            }
                            if (device.getState() != newDevice.getState()) {
                                DeviceState oldDeviceState = device.getState();
                                device.setState(newDevice.getState());
                                if (device.getState() != null) {
                                    switch (device.getState()) {
                                        case ONLINE: {
                                            if (!device.isInitialized()) {
                                                device.initialize();
                                            }
                                            if (oldDeviceState == DeviceState.OFFLINE) {
                                                device.update(1, newDevice.getDeviceName());
                                            } else {
                                                device.update(7, newDevice.getDeviceName());
                                            }
                                            Log.d("DeviceMonitor", "updateDevices: " + device.getSerialNumber() + " onlined");
                                            break;
                                        }
                                        case SUSPENDED: {
                                            device.update(5, newDevice.getDeviceName());
                                            Log.d("DeviceMonitor", "updateDevices: " + device.getSerialNumber() + " suspended");
                                            break;
                                        }
                                        case LOCKED: {
                                            device.update(6, newDevice.getDeviceName());
                                            Log.d("DeviceMonitor", "updateDevices: " + device.getSerialNumber() + " locked");
                                            break;
                                        }
                                        default: {
                                            Log.d("DeviceMonitor", "updateDevices: default error case");
                                        }
                                    }
                                }
                            }
                            newList.remove(dd);
                            break;
                        }
                        ++dd;
                    }
                    if (!foundMatch) {
                        this.bridge.deviceDisconnected(device);
                        this.removeDevice(device);
                        Log.d("DeviceMonitor", "updateDevices: " + device.getSerialNumber() + " off-lined");
                        continue;
                    }
                    ++d;
                }
                for (Device newDevice : newList) {
                    newDevice.preInitialize();
                    if (newDevice.getPlatformType() == PlatformType.ANDROID && !this.bridge.isAllowDetectAndroidDevices() || DeviceUtil.isUnknownDevice(newDevice)) continue;
                    if (DeviceUtil.isOnline(newDevice) && !newDevice.isInitialized()) {
                        newDevice.initialize();
                    }
                    this.devices.add(newDevice);
                    if (DeviceUtil.isOnline(newDevice)) {
                        devicesToQuery.add(newDevice);
                        this.bridge.deviceConnected(newDevice);
                        Log.d("DeviceMonitor", "updateDevices: " + newDevice.getSerialNumber() + " newly connected.");
                        continue;
                    }
                    Log.e("DeviceMonitor", "device status: " + (Object)((Object)newDevice.getState()) + "updateDevices: " + newDevice.getSerialNumber() + " newly connected.");
                }
                this.notifyAll();
            }
        }
        newList.clear();
    }

    @Override
    protected void initialize() throws ServerException {
        Log.d("DeviceMonitor", "start monitoring");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void process() throws Exception {
        block43: {
            block40: {
                block41: {
                    block42: {
                        block39: {
                            if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
                                this.processForPrev();
                                return;
                            }
                            deviceList = null;
                            channel = new Channel();
                            if (this.mConnection) ** GOTO lbl34
                            try {
                                channel.connect();
                            }
                            catch (IOException v0) {
                                Log.d("DeviceMonitor", "sdb is not connected.");
                            }
                            this.bridge.setStarted(true);
                            if (channel.isConnected()) break block39;
                            Log.d("DeviceMonitor", "start sdb");
                            if (!this.bridge.startSdb()) {
                                ++this.mRestartAttemptCount;
                                Log.e("DeviceMonitor", "sdb restart attempts: " + this.mRestartAttemptCount);
                            }
                            channel.close();
                            ThreadUtil.trySleep(300L);
                            channel.close();
                            var5_3 = this.bridge;
                            synchronized (var5_3) {
                                this.bridge.notifyAll();
                            }
                            return;
                        }
                        this.mConnection = true;
                        Log.d("DeviceMonitor", "connected to sdb for device monitoring");
lbl34:
                        // 2 sources

                        if (!this.mMonitoring) {
                            devices = new Devices();
                            deviceList = devices.getDevices();
                            this.mMonitoring = true;
                        }
                        if (!this.mMonitoring || !this.mConnection) break block40;
                        if (channel.isConnected()) break block41;
                        if (!this.isState(new ServerState[]{ServerState.Running})) break block42;
                        this.mMonitoring = false;
                        this.mConnection = false;
                    }
                    channel.close();
                    var5_4 = this.bridge;
                    synchronized (var5_4) {
                        this.bridge.notifyAll();
                    }
                    return;
                }
                try {
                    ThreadUtil.trySleep(300L);
                    this.processDeviceData(deviceList);
                    devices = this.bridge;
                    synchronized (devices) {
                        this.mDeviceListInitialized = true;
                        this.bridge.notifyAll();
                    }
                }
                catch (AsynchronousCloseException v4) {
                    Log.e("DeviceMonitor", "sdb closed by the other");
                    channel.close();
                    var5_5 = this.bridge;
                    synchronized (var5_5) {
                        this.bridge.notifyAll();
                        break block43;
                    }
                }
                catch (TimeoutException ioe) {
                    this.handleExceptioninMonitorLoop(ioe);
                    channel.close();
                    var5_6 = this.bridge;
                    synchronized (var5_6) {
                        this.bridge.notifyAll();
                        break block43;
                    }
                }
                catch (IOException ioe) {
                    this.handleExceptioninMonitorLoop(ioe);
                    {
                        catch (Throwable var4_13) {
                            channel.close();
                            var5_8 = this.bridge;
                            synchronized (var5_8) {
                                this.bridge.notifyAll();
                            }
                            throw var4_13;
                        }
                    }
                    channel.close();
                    var5_7 = this.bridge;
                    synchronized (var5_7) {
                        this.bridge.notifyAll();
                        break block43;
                    }
                }
            }
            channel.close();
            var5_9 = this.bridge;
            synchronized (var5_9) {
                this.bridge.notifyAll();
            }
        }
        ThreadUtil.trySleep(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processForPrev() throws Exception {
        block32: {
            block31: {
                try {
                    int length;
                    if (this.mMainSdbConnection == null) {
                        Log.d("DeviceMonitor", "opening sdb connection");
                        this.mMainSdbConnection = this.openSdbConnection();
                        if (this.mMainSdbConnection == null) {
                            Log.d("DeviceMonitor", "start sdb");
                            if (!this.bridge.startSdb()) {
                                ++this.mRestartAttemptCount;
                                Log.e("DeviceMonitor", "sdb restart attempts: " + this.mRestartAttemptCount);
                            }
                            ThreadUtil.trySleep(1000L);
                        } else {
                            Log.d("DeviceMonitor", "connected to sdb for device monitoring");
                        }
                    }
                    if (!this.mMonitoring) {
                        this.mMonitoring = this.sendDeviceListMonitoringRequest();
                    }
                    if (!this.mMonitoring || this.mMainSdbConnection == null || (length = this.readLength(this.mMainSdbConnection)) < 0) break block31;
                    this.processIncomingDeviceData(length);
                    SmartDevelopmentBridge smartDevelopmentBridge = this.bridge;
                    synchronized (smartDevelopmentBridge) {
                        this.mDeviceListInitialized = true;
                        this.bridge.notifyAll();
                    }
                }
                catch (AsynchronousCloseException asynchronousCloseException) {
                    Log.e("DeviceMonitor", "sdb closed by the other");
                    SmartDevelopmentBridge smartDevelopmentBridge = this.bridge;
                    synchronized (smartDevelopmentBridge) {
                        this.bridge.notifyAll();
                        break block32;
                    }
                }
                catch (TimeoutException ioe) {
                    this.handleExceptioninMonitorLoop(ioe);
                    SmartDevelopmentBridge smartDevelopmentBridge = this.bridge;
                    synchronized (smartDevelopmentBridge) {
                        this.bridge.notifyAll();
                        break block32;
                    }
                }
                catch (IOException ioe) {
                    this.handleExceptioninMonitorLoop(ioe);
                    SmartDevelopmentBridge smartDevelopmentBridge = this.bridge;
                    {
                        catch (Throwable throwable) {
                            SmartDevelopmentBridge smartDevelopmentBridge2 = this.bridge;
                            synchronized (smartDevelopmentBridge2) {
                                this.bridge.notifyAll();
                            }
                            throw throwable;
                        }
                    }
                    synchronized (smartDevelopmentBridge) {
                        this.bridge.notifyAll();
                        break block32;
                    }
                }
            }
            SmartDevelopmentBridge smartDevelopmentBridge = this.bridge;
            synchronized (smartDevelopmentBridge) {
                this.bridge.notifyAll();
            }
        }
        ThreadUtil.trySleep(100L);
    }

    @Override
    protected void terminate() {
        Log.d("DeviceMonitor", "stop monitoring");
        if (SmartDevelopmentBridge.getBridge() != null && SmartDevelopmentBridge.getBridge().isTims()) {
            return;
        }
        try {
            if (this.mMainSdbConnection != null) {
                this.mMainSdbConnection.close();
            }
        }
        catch (IOException e) {
            Log.e("sdb", "close main sdb connection failed:" + e);
        }
    }
}

