/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib;

import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.tizen.sdb.command.Boot;
import org.tizen.sdb.command.Root;
import org.tizen.sdb.command.TizenPlatform;
import org.tizen.sdblib.Arch;
import org.tizen.sdblib.DeviceMonitor;
import org.tizen.sdblib.DeviceState;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.PlatformInfo;
import org.tizen.sdblib.PlatformType;
import org.tizen.sdblib.SdbHelper;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.command.Argument;
import org.tizen.sdblib.command.CommandFactory;
import org.tizen.sdblib.command.Matcher;
import org.tizen.sdblib.command.MatcherFactory;
import org.tizen.sdblib.command.PatternExtractor;
import org.tizen.sdblib.daemon.ServerState;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.ServerException;
import org.tizen.sdblib.exception.ServiceException;
import org.tizen.sdblib.exception.ShellCommandUnresponsiveException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.receiver.DuidReceiver;
import org.tizen.sdblib.service.ApplicationCmdService;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.FileEntryType;
import org.tizen.sdblib.service.SyncService;
import org.tizen.sdblib.util.Assert;
import org.tizen.sdblib.util.FilenameUtil;
import org.tizen.sdblib.util.IOUtil;
import org.tizen.sdblib.util.Log;
import org.tizen.sdblib.util.ObjectUtil;
import org.tizen.sdblib.util.SdbShellProcess;
import org.tizen.sdblib.util.StreamGobbler;
import org.tizen.sdblib.util.StringUtil;

public class Device
implements IDevice {
    protected final DeviceMonitor monitor;
    protected final String serialNumber;
    protected DeviceState state;
    protected String deviceName;
    protected Arch arch = Arch.UNKNOWN;
    protected String arch_str = Arch.UNKNOWN.getArch();
    protected boolean bEmulator = false;
    protected String installPath;
    protected FileEntry root;
    protected String duid;
    protected boolean remote = false;
    protected PlatformCapability capability = null;
    protected String ip;
    protected int basePort = 0;
    protected static final String REMOTE_DEVICE_SERIAL_PATTERN_STRING = "(^\\S+):(6553[0-5]|655[0-2]\\d|65[0-4]\\d\\d|6[0-4]\\d{3}|[1-5]\\d{4}|[1-9]\\d{0,3}|0)$";
    protected static final Pattern REMOTE_DEVICE_SERIAL_PATTERN = Pattern.compile("(^\\S+):(6553[0-5]|655[0-2]\\d|65[0-4]\\d\\d|6[0-4]\\d{3}|[1-5]\\d{4}|[1-9]\\d{0,3}|0)$");
    protected static final String EMULATOR_SERIAL_PREFIX = "emulator-";
    protected boolean isInitailized = false;
    protected PlatformType platformType = PlatformType.TIZEN;
    protected ApplicationCmdService appCmdService = null;

    Device(DeviceMonitor monitor, String serialNumber, DeviceState state) {
        this(monitor, serialNumber, state, null);
    }

    Device(DeviceMonitor monitor, String serialNumber, DeviceState state, String deviceName) {
        Assert.notNull(monitor);
        Assert.notNull(serialNumber);
        this.monitor = monitor;
        this.serialNumber = serialNumber;
        this.state = state;
        this.deviceName = deviceName;
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public DeviceState getState() {
        return this.state;
    }

    void setState(DeviceState state) {
        this.state = state;
    }

    @Override
    public Arch getArch() {
        return this.arch;
    }

    @Override
    public String getArchString() {
        return this.arch_str;
    }

    @Override
    public boolean isEmulator() {
        return this.bEmulator;
    }

    @Override
    public boolean isRoot() {
        if (this.isSecureProtocol()) {
            return false;
        }
        Boolean isRoot = CommandFactory.execute("whoami").in((IDevice)this, MatcherFactory.equals("root"));
        if (isRoot != null) {
            return isRoot;
        }
        return false;
    }

    @Override
    public SyncService getSyncService() throws IOException {
        return new SyncService(SmartDevelopmentBridge.getBridge(), this);
    }

    @Override
    public ApplicationCmdService getApplicationCmdService() {
        if (this.appCmdService == null) {
            if (SmartDevelopmentBridge.getBridge() != null && SmartDevelopmentBridge.getBridge().isTims()) {
                this.appCmdService = new ApplicationCmdService(this);
            } else {
                try {
                    PlatformCapability pcap = this.getPlatformCapability();
                    if (pcap.getAppCmdSupport().equals("enabled")) {
                        this.appCmdService = new ApplicationCmdService(this);
                    }
                }
                catch (IOException iOException) {
                    Log.e("Device", "failed to get appcmd capability: " + this.getSerialNumber() + "(" + (Object)((Object)this.getPlatformType()) + ")");
                }
            }
        }
        return this.appCmdService;
    }

    @Override
    public FileEntry getRoot() {
        if (this.root != null) {
            if (this.isEmulator() && this.root.getType() == FileEntryType.RootDevice) {
                this.root.setType(FileEntryType.RootEmulator);
            }
            return this.root;
        }
        this.root = new FileEntry(this, null, this.getDeviceName(), this.isEmulator() ? FileEntryType.RootEmulator : FileEntryType.RootDevice, null, null, null, null, null, null, null, null);
        return this.root;
    }

    @Override
    public FileEntry getFileEntry(String path) {
        return this.getCommonFileEntry(FilenameUtil.getCanonicalFragments(path));
    }

    public FileEntry getSimpleFileEntry(String path) {
        return this.getCommonFileEntry(FilenameUtil.getSimpleCanonicalFragments(path));
    }

    private FileEntry getCommonFileEntry(String[] fragments) {
        FileEntry iter = this.getRoot();
        String[] stringArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            String fragment = stringArray[n2];
            FileEntry[] children = iter.getChildren();
            boolean bFound = false;
            FileEntry[] fileEntryArray = children;
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                FileEntry child = fileEntryArray[n4];
                if (fragment.equals(child.getName())) {
                    iter = child;
                    bFound = true;
                    break;
                }
                ++n4;
            }
            if (!bFound) {
                iter = new FileEntry(null, iter, fragment, FileEntryType.Unknown, null, null, null, null, null, null, null, null);
            }
            ++n2;
        }
        return iter;
    }

    @Override
    public void executeLaunchCommand(String command, IShellOutputReceiver receiver) throws IOException {
        this.executeHostCommand("launch" + (command == null ? "" : " " + command), receiver);
    }

    @Override
    @Deprecated
    public void executeHostCommand(String command, IShellOutputReceiver receiver) throws IOException {
        String[] commandArray = command.split(" ");
        this.executeHostCommand(commandArray, receiver);
    }

    @Override
    public void executeHostCommand(String[] commandArray, IShellOutputReceiver receiver) throws IOException {
        SmartDevelopmentBridge sdb = SmartDevelopmentBridge.getBridge();
        if (sdb == null) {
            return;
        }
        String sdbPath = sdb.getSdbOsLocation();
        if (sdbPath == null) {
            return;
        }
        if (commandArray == null || commandArray.length == 0) {
            return;
        }
        String[] sdbCommand = new String[commandArray.length + 3];
        sdbCommand[0] = sdbPath;
        sdbCommand[1] = "-s";
        sdbCommand[2] = this.serialNumber;
        int i = 0;
        while (i < commandArray.length) {
            sdbCommand[3 + i] = commandArray[i];
            ++i;
        }
        Process pSdb = Runtime.getRuntime().exec(sdbCommand);
        SdbShellProcess process = new SdbShellProcess(pSdb, "launch");
        try {
            StreamGobbler inputGobbler = new StreamGobbler(process.getInputStream());
            inputGobbler.boot();
            StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream());
            errorGobbler.boot();
            inputGobbler.waitState(ServerState.Terminated);
            errorGobbler.waitState(ServerState.Terminated);
            receiver.append(inputGobbler.getResult());
            receiver.append(errorGobbler.getResult());
            receiver.close();
        }
        catch (ServerException e) {
            throw new IOException(e);
        }
    }

    @Override
    public SdbShellProcess executeShellCommand(String command) throws IOException {
        return (SdbShellProcess)this.executeShellCommand(command, true);
    }

    @Override
    public Process executeShellCommand(String command, boolean prompt) throws IOException {
        SmartDevelopmentBridge sdb = SmartDevelopmentBridge.getBridge();
        if (sdb == null) {
            return null;
        }
        String sdbPath = sdb.getSdbOsLocation();
        if (sdbPath == null) {
            return null;
        }
        ArrayList<String> sdbShellCmds = new ArrayList<String>();
        sdbShellCmds.add(sdbPath);
        sdbShellCmds.add("-s");
        sdbShellCmds.add(this.serialNumber);
        sdbShellCmds.add("shell");
        if (!prompt) {
            sdbShellCmds.add(command);
        }
        String[] commandArray = new String[sdbShellCmds.size()];
        commandArray = sdbShellCmds.toArray(commandArray);
        Process pSdb = Runtime.getRuntime().exec(commandArray);
        if (!prompt) {
            return pSdb;
        }
        return new SdbShellProcess(pSdb, command);
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        CommandFactory.execute(command).in((IDevice)this, receiver);
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver, int maxTimeToOutputResponse) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        CommandFactory.execute(command).with(Argument.MaxTimeToRespond, maxTimeToOutputResponse).in((IDevice)this, receiver);
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver, int maxTimeToOutputResponse, String characterSet) throws IOException {
        CommandFactory.execute(command).with(Argument.MaxTimeToRespond, maxTimeToOutputResponse).in(this, receiver, characterSet);
    }

    @Override
    public void createForward(int localPort, int remotePort) throws TimeoutException, SdbCommandRejectedException, IOException {
        SdbHelper.createForward(SmartDevelopmentBridge.getBridge(), this, localPort, remotePort);
    }

    @Override
    public void removeForward(int localPort, int remotePort) throws TimeoutException, SdbCommandRejectedException, IOException {
        SdbHelper.removeForward(SmartDevelopmentBridge.getBridge(), this, localPort, remotePort);
    }

    void update(int changeMask) {
        this.monitor.getServer().deviceChanged(this, changeMask);
    }

    void update(int changeMask, String name) {
        this.deviceName = name;
        this.getRoot().setName(name);
        this.update(changeMask);
    }

    public void preInitialize() throws AsynchronousCloseException {
        if (SmartDevelopmentBridge.getBridge() != null && SmartDevelopmentBridge.getBridge().isTims()) {
            return;
        }
        try {
            String platformType = SdbHelper.getPlatformType(SmartDevelopmentBridge.getBridge(), this);
            if (PlatformType.ANDROID.getPlatformTypeName().equals(platformType)) {
                this.setPlatformType(PlatformType.ANDROID);
            } else if (PlatformType.UNKNOWN.getPlatformTypeName().equals(platformType)) {
                this.setPlatformType(PlatformType.UNKNOWN);
            }
        }
        catch (IOException iOException) {
            Log.e("Device", "failed to set platform type: " + this.getSerialNumber() + "(" + (Object)((Object)this.getPlatformType()) + ")");
        }
    }

    private Arch getArchInternalFromCapability() throws IOException {
        Arch retArch = Arch.UNKNOWN;
        try {
            String archStr;
            this.arch_str = archStr = this.getPlatformCapability().getCpuArch();
            if (archStr.contains(Arch.ARM.getArch())) {
                retArch = Arch.ARM;
            } else if (archStr.contains(Arch.AARCH.getArch())) {
                retArch = Arch.AARCH;
            } else if (archStr.contains(Arch.X86.getArch())) {
                retArch = archStr.contains(Arch.X86_64.getArch()) ? Arch.X86_64 : Arch.X86;
            }
        }
        catch (IOException iOException) {}
        return retArch;
    }

    private Arch getArchInternalFromShellCmd() {
        Arch retArch = Arch.UNKNOWN;
        Matcher<Boolean> arm = MatcherFactory.containsIgnoreCase(Arch.ARM.getArch());
        Matcher<Boolean> arm_64 = MatcherFactory.containsIgnoreCase(Arch.AARCH.getArch());
        Matcher<Boolean> x86 = MatcherFactory.containsIgnoreCase(Arch.X86.getArch());
        Matcher<Boolean> x86_64 = MatcherFactory.containsIgnoreCase(Arch.X86_64.getArch());
        String cmd = "";
        cmd = this.isSecureProtocol() ? "0 uname" : "uname -m";
        Matcher<?> arch = CommandFactory.execute(cmd).with(Argument.MaxTimeToRespond, 2000).in((IDevice)this, MatcherFactory.matchers(arm, arm_64, x86_64, x86));
        if (arm.equals(arch)) {
            this.arch_str = Arch.ARM.getArch();
            retArch = Arch.ARM;
        } else if (arm_64.equals(arch)) {
            this.arch_str = Arch.AARCH.getArch();
            retArch = Arch.AARCH;
        } else if (x86.equals(arch)) {
            this.arch_str = Arch.X86.getArch();
            retArch = Arch.X86;
        } else if (x86_64.equals(arch)) {
            this.arch_str = Arch.X86_64.getArch();
            retArch = Arch.X86_64;
        } else {
            this.arch_str = Arch.UNKNOWN.getArch();
            retArch = Arch.UNKNOWN;
        }
        return retArch;
    }

    public void initialize() throws AsynchronousCloseException, IOException {
        try {
            this.capability = new PlatformCapability(this);
        }
        catch (Exception exception) {}
        this.arch = this.getArchInternalFromCapability();
        if (this.arch.equals((Object)Arch.UNKNOWN)) {
            this.arch = this.getArchInternalFromShellCmd();
        }
        String cmd = "";
        cmd = this.isSecureProtocol() ? "0 getvmname" : "cat /proc/cmdline | grep 'vm_name' | wc -l";
        Boolean isEmulator = CommandFactory.execute(cmd).in((IDevice)this, MatcherFactory.equals("1"));
        if (isEmulator != null) {
            this.bEmulator = isEmulator;
        }
        if (this.serialNumber != null) {
            this.setAddressBySerial(this.serialNumber);
        }
        Log.d("Device", "initialized device: " + this.getSerialNumber() + "(" + (Object)((Object)this.getArch()) + ")");
        this.isInitailized = true;
    }

    @Override
    public boolean isSupportShell() {
        PlatformCapability capa;
        block4: {
            capa = this.getPlatformCapability();
            if (capa != null) break block4;
            return true;
        }
        try {
            String supportShell = capa.getShellSupport();
            if (supportShell != null && supportShell.equals("disabled")) {
                return false;
            }
        }
        catch (IOException iOException) {
            Log.d("Device", "isSupportShell: " + this.getSerialNumber() + "(" + (Object)((Object)this.getArch()) + ")");
        }
        return true;
    }

    @Override
    public boolean isSecureProtocol() {
        try {
            return this.getPlatformCapability().getSecureProtocol().equals("enabled");
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean isSupportCapability() {
        return this.capability != null;
    }

    @Override
    public String getAppCmdProtocolVersion() {
        String appProtocolVer = "unknown";
        try {
            PlatformCapability pcap = this.getPlatformCapability();
            if (pcap.getSdbdRootPerm().equals("disabled")) {
                appProtocolVer = "0.1";
                return appProtocolVer;
            }
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (SdbCommandRejectedException sdbCommandRejectedException) {
            Log.d("Device", "This platform does not support the capability function.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (appProtocolVer == "unknown") {
            String cmd = "/usr/bin/profile_command getversion";
            PatternExtractor patten = new PatternExtractor("([0-9]+(\\.[0-9]+)+)");
            String profileVersion = CommandFactory.execute(cmd).with(Argument.MaxTimeToRespond, 2000).in((IDevice)this, patten);
            if (profileVersion != null) {
                try {
                    Double version = Double.parseDouble(profileVersion);
                    if (version >= 4.0) {
                        appProtocolVer = "0.1";
                        return appProtocolVer;
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        return "unknown";
    }

    @Override
    public String getAppInstallPath() {
        if (StringUtil.isEmpty(this.installPath)) {
            if (this.isSupportCapability()) {
                try {
                    PlatformCapability pcap = this.getPlatformCapability();
                    if (pcap != null && !pcap.getSdkToolPath().equals("unknown")) {
                        this.installPath = pcap.getSdkToolPath();
                    }
                }
                catch (Exception exception) {}
            }
            if (StringUtil.isEmpty(this.installPath)) {
                String cmd = "";
                cmd = this.isSecureProtocol() ? "0 getappinstallpath" : "/usr/bin/pkgcmd -a";
                this.installPath = CommandFactory.execute(cmd).in((IDevice)this, new PatternExtractor("^Tizen Application Installation Path: (.*)"));
            }
        }
        return this.installPath;
    }

    public String toString() {
        return this.serialNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IDevice)) {
            return false;
        }
        IDevice device = (IDevice)obj;
        return ObjectUtil.equals(this.getSerialNumber(), device.getSerialNumber());
    }

    @Override
    public PlatformInfo getPlatformInfo() throws TimeoutException, SdbCommandRejectedException, IOException {
        return new PlatformInfo(this);
    }

    @Override
    public PlatformCapability getPlatformCapability() throws TimeoutException, SdbCommandRejectedException, IOException {
        if (this.capability == null) {
            this.capability = new PlatformCapability(this);
        }
        return this.capability;
    }

    @Override
    public boolean becomeSuperUser(boolean isOn) throws TimeoutException, SdbCommandRejectedException, IOException {
        Root root = new Root();
        return root.setRootOnOff(isOn, this.getSerialNumber());
    }

    @Override
    public String getDUID() throws TimeoutException, SdbCommandRejectedException, IOException {
        if (this.duid != null) {
            return this.duid;
        }
        try {
            PlatformCapability pcap = this.getPlatformCapability();
            if (!pcap.getDUID().equals("unknown")) {
                this.duid = pcap.getDUID();
                return this.duid;
            }
        }
        catch (IOException iOException) {}
        DuidReceiver duidReceiver = new DuidReceiver();
        try {
            String cmd = "";
            cmd = this.isSecureProtocol() ? (this.getPlatformCapability().getProductVersion().equals("1.0") ? "0 getduid" : "0 getduidgadget") : "/opt/etc/duid-gadget 2 2> /dev/null";
            this.executeShellCommand(cmd, duidReceiver);
            this.duid = duidReceiver.getDuid();
        }
        finally {
            IOUtil.tryClose(duidReceiver);
        }
        return this.duid;
    }

    @Override
    public boolean isRemote() {
        return this.remote;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getBasePort() {
        return this.basePort;
    }

    private void setAddressBySerial(String serialNumber) {
        java.util.regex.Matcher matcher = REMOTE_DEVICE_SERIAL_PATTERN.matcher(serialNumber);
        if (matcher.matches()) {
            this.remote = true;
            String[] splittedWord = StringUtil.split(serialNumber, ":");
            if (splittedWord != null && splittedWord.length == 2) {
                this.ip = splittedWord[0];
                try {
                    this.basePort = Integer.parseInt(splittedWord[1]) - 1;
                }
                catch (NumberFormatException nfe) {
                    Log.e("Device", "failed to parse integer from remote emulator port number : " + nfe.getMessage());
                }
            }
        } else if (serialNumber.contains(EMULATOR_SERIAL_PREFIX)) {
            String portString = serialNumber.substring(EMULATOR_SERIAL_PREFIX.length());
            try {
                this.basePort = Integer.parseInt(portString) - 1;
            }
            catch (NumberFormatException nfe) {
                Log.e("Device", "failed to parse integer from emulator port number : " + nfe.getMessage());
            }
        }
    }

    @Override
    public boolean isBootingDone() throws TimeoutException, SdbCommandRejectedException, IOException {
        Boot boot = new Boot();
        return boot.isBootDone(this.getSerialNumber());
    }

    @Override
    public boolean isInitialized() {
        return this.isInitailized;
    }

    @Override
    public String getEnvironmentValue(String environmentVariable) throws TimeoutException, SdbCommandRejectedException, IOException, ServiceException {
        TizenPlatform tzplatform = new TizenPlatform();
        String environmentValue = null;
        try {
            environmentValue = tzplatform.getEnvironment(environmentVariable, this.getSerialNumber());
        }
        catch (IOException iOException) {
            throw new ServiceException("Environment variable is not valid");
        }
        return environmentValue;
    }

    @Override
    public PlatformType getPlatformType() {
        return this.platformType;
    }

    @Override
    public void setPlatformType(PlatformType platformType) {
        this.platformType = platformType;
    }
}

