/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.ui.diaglog;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import org.tizen.device.manager.InstallDeviceInfo;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.control.ImageButton;
import org.tizen.device.manager.controller.RemoteDeviceScanWorkerController;
import org.tizen.device.manager.controller.RemoteScanButton;
import org.tizen.device.manager.data.DeviceStateType;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.model.DeviceItem;
import org.tizen.device.manager.model.RemoteDeviceItem;
import org.tizen.device.manager.resources.ImageKind;
import org.tizen.device.manager.ui.diaglog.ButtonType;
import org.tizen.device.manager.ui.diaglog.Dialog;
import org.tizen.device.manager.ui.diaglog.FileDialogUtils;
import org.tizen.device.manager.ui.diaglog.RemoteDeviceManagerSubDialog;
import org.tizen.device.manager.ui.diaglog.RemoteDeviceTableView;
import org.tizen.device.manager.util.IOUtil;

public class RemoteDeviceManagerDialog
extends Dialog<String> {
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final String PORT_PATTERN = "^(6553[0-5]|655[0-2]\\d|65[0-4]\\d\\d|6[0-4]\\d{3}|[1-5]\\d{4}|[1-9]\\d{0,3}|0)$";
    private BorderPane borderPane;
    private HBox hTopButtons;
    private RemoteScanButton scanButton;
    private ImageButton addButton;
    private ImageButton editButton;
    private ImageButton deleteButton;
    private RemoteDeviceTableView tableView;
    private final ObservableList<RemoteDeviceItem> remoteDeviceItems = FXCollections.observableArrayList();
    private RemoteDeviceItem selectedItem;
    public static String LABEL_DIALOG_NAME = Messages.Remote_Device_Manager_Title;
    public static String LABEL_NAME = Messages.Remote_Device_Manager_Label_Name;
    public static String LABEL_IP = Messages.Remote_Device_Manager_Label_Ip;
    public static String LABEL_PORT = Messages.Remote_Device_Manager_Label_Port;
    public static String LABEL_CONNECTION = Messages.Remote_Device_Manager_Label_Connection;
    public static String TOOLTIP_SCAN_DEVICES = Messages.Remote_Device_Manager_Scan_Device_Button_Tooltip;
    public static String TOOLTIP_ADD_DEVICE = Messages.Remote_Device_Manager_ADD_Device_Button_Tooltip;
    public static String TOOLTIP_EDIT_DEVICE = Messages.Remote_Device_Manager_Edit_Device_Button_Tooltip;
    public static String TOOLTIP_REMOVE_DEVICE = Messages.Remote_Device_Manager_Remove_Device_Button_Tooltip;
    private static RemoteDeviceScanWorkerController scanWorker = null;
    private List<DeviceItem> deviceItemList;
    private static SimpleBooleanProperty isVisible = new SimpleBooleanProperty(false);
    private Dialog<String> dialog;

    public static SimpleBooleanProperty getIsVisible() {
        return isVisible;
    }

    public RemoteDeviceManagerDialog(List<DeviceItem> deviceItemList) {
        this.deviceItemList = deviceItemList;
        this.createContents();
        this.addButtonClickEventListeners();
        scanWorker = new RemoteDeviceScanWorkerController(this);
    }

    private void createContents() {
        this.dialog = new Dialog();
        this.dialog.setTitle(LABEL_DIALOG_NAME);
        this.setResizable(false);
        AnchorPane anchor = new AnchorPane();
        this.borderPane = new BorderPane();
        this.hTopButtons = new HBox();
        this.borderPane.setStyle("-fx-background-color: #F4F4F4;");
        this.tableView = new RemoteDeviceTableView();
        this.tableView.getStylesheets().add((Object)this.getClass().getResource("/view/table_view.css").toExternalForm());
        this.scanButton = new RemoteScanButton();
        this.scanButton.setTooltipText(TOOLTIP_SCAN_DEVICES);
        this.addButton = new ImageButton(ImageKind.ICON_REMOTE_ADD_NOR, ImageKind.ICON_REMOTE_ADD_OVER, ImageKind.ICON_REMOTE_ADD_DIM);
        this.addButton.setTooltipText(TOOLTIP_ADD_DEVICE);
        this.editButton = new ImageButton(ImageKind.ICON_REMOTE_EDIT_NOR, ImageKind.ICON_REMOTE_EDIT_OVER, ImageKind.ICON_REMOTE_EDIT_DIM);
        this.editButton.setTooltipText(TOOLTIP_EDIT_DEVICE);
        this.deleteButton = new ImageButton(ImageKind.ICON_REMOTE_DELETE_NOR, ImageKind.ICON_REMOTE_DELETE_OVER, ImageKind.ICON_REMOTE_DELETE_DIM);
        this.deleteButton.setTooltipText(TOOLTIP_REMOVE_DEVICE);
        this.setDisableButtons(true);
        this.hTopButtons.setAlignment(Pos.CENTER_RIGHT);
        this.hTopButtons.setSpacing(10.0);
        this.hTopButtons.getChildren().addAll((Object[])new Node[]{this.scanButton.getPane(), this.addButton.getPane(), this.editButton.getPane(), this.deleteButton.getPane()});
        this.borderPane.setTop((Node)this.hTopButtons);
        this.borderPane.setCenter((Node)this.tableView);
        this.borderPane.setPrefSize(400.0, 200.0);
        BorderPane.setMargin((Node)this.tableView, (Insets)new Insets(5.0, 0.0, 0.0, 5.0));
        BorderPane.setMargin((Node)this.hTopButtons, (Insets)new Insets(5.0, 5.0, 0.0, 5.0));
        this.tableView.setPlaceholder((Node)new Label(Messages.Remote_Device_Manager_Empty_Message));
        this.tableView.prefHeightProperty().bind((ObservableValue)this.heightProperty().multiply(0.5));
        StackPane pane = new StackPane();
        final ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
        progressIndicator.setPrefSize(5.0, 5.0);
        pane.setPrefSize(50.0, 50.0);
        pane.getChildren().add((Object)progressIndicator);
        AnchorPane.setRightAnchor((Node)pane, (Double)170.0);
        AnchorPane.setBottomAnchor((Node)pane, (Double)50.0);
        progressIndicator.getParent().setVisible(false);
        anchor.getChildren().addAll((Object[])new Node[]{this.borderPane, pane});
        this.dialog.getDialogPane().setContent((Node)anchor);
        this.dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.CLOSE);
        this.dialog.setResultConverter(new Callback<ButtonType, String>(){

            public String call(ButtonType param) {
                RemoteDeviceManagerDialog.this.writeRemoteDeviceListFile();
                return "close";
            }
        });
        RemoteDeviceManagerDialog.getIsVisible().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> value, Boolean oldValue, Boolean newValue) {
                if (newValue == null) {
                    return;
                }
                if (newValue.booleanValue()) {
                    progressIndicator.getParent().setVisible(true);
                    progressIndicator.setVisible(true);
                    DeviceLogger.getLogger().fine("Show progress indicator");
                } else {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            progressIndicator.getParent().setVisible(false);
                            progressIndicator.setVisible(false);
                            DeviceLogger.getLogger().fine("Hide progress indicator");
                        }
                    });
                }
            }
        });
        this.readRemoteDeviceList();
        this.updateRemoteDeviceStateFromDeviceListView();
        this.dialog.show();
    }

    private void setDisableButtons(boolean isEnable) {
        this.editButton.setDisable(isEnable);
        this.deleteButton.setDisable(isEnable);
    }

    private void addButtonClickEventListeners() {
        this.scanButton.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                RemoteDeviceManagerDialog.this.scanDevice();
            }
        });
        this.addButton.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                RemoteDeviceManagerDialog.this.addRemoteDeviceAddDialog();
            }
        });
        this.editButton.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                RemoteDeviceManagerDialog.this.addRemoteDeviceEditDialog();
            }
        });
        this.deleteButton.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                if (RemoteDeviceManagerDialog.this.selectedItem != null) {
                    RemoteDeviceManagerDialog.this.removeRemoteDeviceItem(RemoteDeviceManagerDialog.this.selectedItem);
                    RemoteDeviceManagerDialog.this.writeRemoteDeviceListFile();
                }
            }
        });
        this.tableView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<RemoteDeviceItem>(){

            public void changed(ObservableValue<? extends RemoteDeviceItem> observable, RemoteDeviceItem oldValue, RemoteDeviceItem newValue) {
                if (newValue != null) {
                    RemoteDeviceManagerDialog.this.selectedItem = newValue;
                    RemoteDeviceManagerDialog.this.setDisableButtons(false);
                }
            }
        });
    }

    public void addRemoteDeviceAddDialog() {
        new RemoteDeviceManagerSubDialog(this, true);
    }

    public void addRemoteDeviceEditDialog() {
        new RemoteDeviceManagerSubDialog(this, false);
    }

    public void addRemoteDeviceItem(RemoteDeviceItem item) {
        this.remoteDeviceItems.add((Object)item);
        this.tableView.setItems(this.remoteDeviceItems);
    }

    public void removeRemoteDeviceItem(RemoteDeviceItem item) {
        this.remoteDeviceItems.remove((Object)item);
        this.tableView.setItems(this.remoteDeviceItems);
    }

    public RemoteDeviceItem getSelectedRemoteDeviceItem() {
        return this.selectedItem;
    }

    public ObservableList<RemoteDeviceItem> getRemoteDeviceItemList() {
        return this.remoteDeviceItems;
    }

    private void scanDevice() {
        if (!scanWorker.isRunning()) {
            RemoteDeviceManagerDialog.setProgress(true);
            Thread t = new Thread((Runnable)scanWorker, "Remote Scan Worker");
            t.start();
        } else {
            scanWorker.finish();
            this.enableScanButton(true);
            RemoteDeviceManagerDialog.setProgress(false);
            Thread t = this.getThreadByName("Remote Scan Worker");
            if (t == null) {
                return;
            }
            t.interrupt();
        }
    }

    private Thread getThreadByName(String threadName) {
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            if (!t.getName().equals(threadName)) continue;
            return t;
        }
        return null;
    }

    public void enableScanButton(final boolean enabled) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (RemoteDeviceManagerDialog.this.scanButton.getIconLabel().isDisable()) {
                    return;
                }
                RemoteDeviceManagerDialog.this.scanButton.changeIcon(enabled);
                RemoteDeviceManagerDialog.this.addButton.setDisable(!enabled);
                RemoteDeviceManagerDialog.setProgress(!enabled);
            }
        });
    }

    public Dialog<String> getDialog() {
        return this.dialog;
    }

    private static void setProgress(boolean visible) {
        isVisible.set(visible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRemoteDeviceListFile() {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(InstallDeviceInfo.getDeviceRemoteDeviceFilePath()));
            ObservableList remoteDeviceItems = this.tableView.getItems();
            for (RemoteDeviceItem item : remoteDeviceItems) {
                String remoteDeviceInfo = RemoteDeviceManagerDialog.makeRemoteDeviceInfo(item.nameProperty().getValue(), item.ipProperty().getValue(), item.portProperty().getValue());
                out.write(remoteDeviceInfo);
                out.newLine();
            }
        }
        catch (IOException e) {
            try {
                DeviceLogger.getLogger().log(Level.SEVERE, "Failed to make the file of the remote device list: ", e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(out);
                throw throwable;
            }
            IOUtil.tryClose(out);
        }
        IOUtil.tryClose(out);
    }

    public static String makeRemoteDeviceInfo(String name, String ip, String port) {
        return name + "/" + ip + "/" + port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readRemoteDeviceList() {
        block9: {
            File file;
            BufferedReader br;
            FileReader fr;
            block8: {
                fr = null;
                br = null;
                file = new File(InstallDeviceInfo.getDeviceRemoteDeviceFilePath());
                if (file.isFile()) break block8;
                IOUtil.tryClose(fr);
                IOUtil.tryClose(br);
                return;
            }
            try {
                fr = new FileReader(file);
                br = new BufferedReader(fr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    String[] deviceInfo = this.getRemoteDeviceInfoFromLine(line);
                    if (deviceInfo == null || deviceInfo.length != 3) continue;
                    this.addRemoteDeviceItem(new RemoteDeviceItem(deviceInfo[0], deviceInfo[1], deviceInfo[2], false));
                }
            }
            catch (FileNotFoundException e) {
                DeviceLogger.getLogger().log(Level.SEVERE, "Remote device file is not found", e.getMessage());
                IOUtil.tryClose(fr);
                IOUtil.tryClose(br);
                break block9;
            }
            catch (IOException e2) {
                DeviceLogger.getLogger().log(Level.SEVERE, "Failed to read the file of the remote device list:", e2.getMessage());
                {
                    catch (Throwable throwable) {
                        IOUtil.tryClose(fr);
                        IOUtil.tryClose(br);
                        throw throwable;
                    }
                }
                IOUtil.tryClose(fr);
                IOUtil.tryClose(br);
            }
            IOUtil.tryClose(fr);
            IOUtil.tryClose(br);
        }
    }

    private String[] getRemoteDeviceInfoFromLine(String line) {
        String[] deviceInfo = null;
        deviceInfo = line.split("/");
        return deviceInfo;
    }

    private void updateRemoteDeviceStateFromDeviceListView() {
        if (this.deviceItemList.isEmpty()) {
            return;
        }
        for (DeviceItem deviceItem : this.deviceItemList) {
            String[] data;
            if (!deviceItem.getDeviceType().isRemoteDevice() || (data = deviceItem.getPort().split(":")).length <= 1) continue;
            for (RemoteDeviceItem remoteItem : this.remoteDeviceItems) {
                if (!remoteItem.ipProperty().getValue().equals(data[0]) || !remoteItem.portProperty().getValue().equals(data[1]) || !deviceItem.connectProperty().getValue().equalsIgnoreCase(DeviceStateType.ONLINE.name())) continue;
                remoteItem.setConnectionProperty(true);
            }
        }
    }

    public boolean addDeviceInfo(String name, String ip, String port) {
        ObservableList remoteDeviceItems = this.tableView.getItems();
        for (RemoteDeviceItem item : remoteDeviceItems) {
            if (!item.ipProperty().getValue().equals(ip) || !item.portProperty().getValue().equals(port)) continue;
            FileDialogUtils.remoteAddDeviceErrorMessage(ip + ":" + port);
            return false;
        }
        if (this.isValidRemoteDevice(name, ip, port)) {
            this.addRemoteDeviceItem(new RemoteDeviceItem(name, ip, port, false));
            this.writeRemoteDeviceListFile();
            return true;
        }
        return false;
    }

    public boolean modifyDeviceInfo(String name, String ip, String port) {
        ObservableList remoteDeviceItems = this.tableView.getItems();
        RemoteDeviceItem selectItem = this.getSelectedRemoteDeviceItem();
        for (RemoteDeviceItem item : remoteDeviceItems) {
            if (selectItem == item || !item.ipProperty().getValue().equals(ip) || !item.portProperty().getValue().equals(port)) continue;
            FileDialogUtils.remoteAddDeviceErrorMessage(ip + ":" + port);
            return false;
        }
        if (this.isValidRemoteDevice(name, ip, port)) {
            if (null == this.selectedItem) {
                return false;
            }
            selectItem.nameProperty().setValue(name);
            selectItem.ipProperty().setValue(ip);
            selectItem.portProperty().setValue(port);
            this.writeRemoteDeviceListFile();
            return true;
        }
        return false;
    }

    private boolean isValidRemoteDevice(String name, String ip, String port) {
        if (!name.equals("")) {
            Pattern ipPattern = Pattern.compile(IPADDRESS_PATTERN);
            Matcher ipMatcher = ipPattern.matcher(ip);
            if (ipMatcher.find()) {
                Pattern portPattern = Pattern.compile(PORT_PATTERN);
                Matcher portMatcher = portPattern.matcher(port);
                if (portMatcher.find()) {
                    return true;
                }
                FileDialogUtils.remoteAddDeviceInvalidPortErrorMessage(port);
            } else {
                FileDialogUtils.remoteAddDeviceInvalidIpErrorMessage(ip);
            }
        } else {
            FileDialogUtils.remoteAddDeviceEmptyNameErrorMessage();
        }
        return false;
    }
}

