/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Pattern;
import org.tizen.device.manager.util.ArrayUtil;
import org.tizen.device.manager.util.OSUtil;
import org.tizen.device.manager.util.StringUtil;
import org.tizen.sdblib.util.ObjectUtil;

public class FilenameUtil {
    public static final char SEPARATOR_DIRECTORY = '/';
    public static final int IS_VALID_NAME = 0;
    public static final int HAS_INVALID_CHARACTER = 1;
    public static final int HAS_NO_NAME = 2;
    public static final int IS_NULL = 3;

    public static String[] getCanonicalFragments(String path) {
        int CH_ESCAPE = 92;
        int CH_QUOTE = 39;
        boolean ST_NORMAL = false;
        int ST_READY_TO_ESCAPE = 2;
        int ST_QUOTE = 3;
        ArrayList<String> ret = new ArrayList<String>();
        char[] characters = path.toCharArray();
        StringBuilder buffer = new StringBuilder();
        int status = 0;
        block5: for (char ch : characters) {
            switch (status) {
                case 0: {
                    if ('/' == ch || File.separatorChar == ch) {
                        String fragment = buffer.toString();
                        if (!StringUtil.isEmpty(fragment)) {
                            ret.add(fragment);
                        }
                        buffer.delete(0, buffer.length());
                        continue block5;
                    }
                    if ('\'' == ch) {
                        status = 3;
                        continue block5;
                    }
                    buffer.append(ch);
                    continue block5;
                }
                case 2: {
                    if ('\'' != ch) {
                        buffer.append('\\');
                        buffer.append(ch);
                    }
                    status = 3;
                    continue block5;
                }
                case 3: {
                    if ('\'' == ch) {
                        status = 0;
                        continue block5;
                    }
                    if ('\\' == ch) {
                        status = 2;
                        continue block5;
                    }
                    buffer.append(ch);
                    continue block5;
                }
            }
        }
        if (0 < buffer.length()) {
            String fragment = buffer.toString();
            if (!StringUtil.isEmpty(fragment)) {
                ret.add(fragment);
            }
            buffer.delete(0, buffer.length());
        }
        return ret.toArray(new String[0]);
    }

    public static String[] getCanonicalFragmentsWithNoEscape(String path) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] characters = path.toCharArray();
        StringBuilder buffer = new StringBuilder();
        for (char ch : characters) {
            if ('/' == ch || File.separatorChar == ch) {
                String fragment = buffer.toString();
                if (!StringUtil.isEmpty(fragment)) {
                    ret.add(fragment);
                }
                buffer.delete(0, buffer.length());
                continue;
            }
            buffer.append(ch);
        }
        if (0 < buffer.length()) {
            String fragment = buffer.toString();
            if (!StringUtil.isEmpty(fragment)) {
                ret.add(fragment);
            }
            buffer.delete(0, buffer.length());
        }
        return ret.toArray(new String[0]);
    }

    public static String getTailingPath(String path, int start) {
        String[] fragments = FilenameUtil.getCanonicalFragments(path);
        StringBuilder buffer = new StringBuilder();
        int n = ArrayUtil.size(fragments);
        for (int i = Math.max(0, ArrayUtil.size(fragments) - start); i < n; ++i) {
            buffer.append(fragments[i]);
            if (i >= ArrayUtil.size(fragments) - 1) continue;
            buffer.append('/');
        }
        return buffer.toString();
    }

    public static String removeTailingPath(String path, int numberOfPath) {
        String[] fragments = FilenameUtil.getCanonicalFragments(path);
        StringBuilder buffer = new StringBuilder();
        int n = Math.max(0, ArrayUtil.size(fragments) - numberOfPath);
        for (int i = 0; i < n; ++i) {
            buffer.append('/');
            buffer.append(fragments[i]);
        }
        String ret = buffer.toString();
        if (0 < ret.length()) {
            return buffer.toString().substring(path.startsWith("/") || path.startsWith(File.separator) ? 0 : 1);
        }
        return "";
    }

    public static String addTailingPath(String path, String pathToAdd) {
        return StringUtil.trimTrailingCharacter(path, '/') + '/' + StringUtil.trimLeadingCharacter(pathToAdd, '/');
    }

    public static boolean isAncestor(String root, String filePath) {
        String[] rootFragments = FilenameUtil.getCanonicalFragments(root);
        String[] fileFragments = FilenameUtil.getCanonicalFragments(filePath);
        if (fileFragments.length < rootFragments.length) {
            return false;
        }
        int n = rootFragments.length;
        for (int i = 0; i < n; ++i) {
            if (ObjectUtil.equals((Object)rootFragments[i], (Object)fileFragments[i])) continue;
            return false;
        }
        return true;
    }

    public static String getRelativePath(String root, String filePath) {
        int i;
        int nLoop;
        String[] rootFragments = FilenameUtil.getCanonicalFragments(root);
        String[] fileFragments = FilenameUtil.getCanonicalFragments(filePath);
        int nRoot = rootFragments.length;
        int nFile = fileFragments.length;
        StringBuilder buffer = new StringBuilder();
        int nStartDiffer = nLoop = nRoot < nFile ? nRoot : nFile;
        for (i = 0; i < nLoop; ++i) {
            if (ObjectUtil.equals((Object)rootFragments[i], (Object)fileFragments[i])) continue;
            nStartDiffer = i;
            break;
        }
        for (i = 0; i < nRoot - nStartDiffer; ++i) {
            if (buffer.length() > 0) {
                buffer.append('/');
            }
            buffer.append("..");
        }
        for (i = nStartDiffer; i < fileFragments.length; ++i) {
            if (buffer.length() > 0) {
                buffer.append('/');
            }
            buffer.append(fileFragments[i]);
        }
        return buffer.toString();
    }

    public static String getCanonicalPath(File file) throws IOException {
        String osCanonicalPath = file.getCanonicalPath();
        return FilenameUtil.getCanonicalForm(osCanonicalPath);
    }

    public static String getCanonicalForm(String path) {
        String[] fragments = FilenameUtil.getCanonicalFragments(path.replace(File.separatorChar, '/'));
        Stack<String> stack = new Stack<String>();
        int n = ArrayUtil.size(fragments);
        for (int i = 0; i < n; ++i) {
            String fragment = fragments[i];
            if (".".equals(fragment)) continue;
            if ("..".equals(fragment)) {
                if (stack.isEmpty()) continue;
                stack.pop();
                continue;
            }
            stack.push(fragment);
        }
        if (stack.isEmpty()) {
            return "/";
        }
        StringBuilder buffer = new StringBuilder();
        for (String f : stack) {
            buffer.append("/");
            buffer.append(f);
        }
        return buffer.toString();
    }

    public static String getFilename(String path) {
        return FilenameUtil.getTailingPath(path, 1);
    }

    public static String getEscapedName(String fileName) {
        Pattern sEscapePattern = Pattern.compile("([\\\\\"$])");
        return sEscapePattern.matcher(fileName).replaceAll("\\\\$1");
    }

    public static boolean isVaildName(String fileName, String os) {
        int result = 0;
        if (fileName == null) {
            result = 3;
        } else if (fileName.trim().length() == 0) {
            result = 2;
        } else {
            Pattern invalidPattern = "Windows".equalsIgnoreCase(os) ? Pattern.compile("([\\\\/:*?\"<>|])") : ("Linux".equalsIgnoreCase(os) ? Pattern.compile("([/])") : Pattern.compile("([/])"));
            if (invalidPattern.matcher(fileName).find()) {
                result = 1;
            }
        }
        return result == 0;
    }

    public static boolean isVaildName(String fileName) {
        return FilenameUtil.isVaildName(fileName, OSUtil.getCurrentOSName());
    }

    public static String getInvalidCharacters() {
        return FilenameUtil.getInvalidCharacters(OSUtil.getCurrentOSName());
    }

    public static String getInvalidCharacters(String os) {
        if ("Windows".equalsIgnoreCase(os)) {
            return "\\\\/:*?\"<>|";
        }
        if ("Linux".equalsIgnoreCase(os)) {
            return "/";
        }
        return "/";
    }

    public static String addDoubleQuote(String str) {
        return "\"" + str + "\"";
    }

    public static String getName(String nameWithExt) {
        int index = nameWithExt.lastIndexOf(46);
        if (index < 0) {
            return nameWithExt;
        }
        return nameWithExt.substring(0, index);
    }

    public static String getExtension(String nameWithExt) {
        int index = nameWithExt.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return nameWithExt.substring(index + 1);
    }

    public static boolean equals(File file1, File file2) {
        try {
            return ObjectUtil.equals((Object)FilenameUtil.getCanonicalPath(file1), (Object)FilenameUtil.getCanonicalPath(file2));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean equals(String path1, String path2) {
        return ObjectUtil.equals((Object)path1, (Object)path2);
    }

    public static boolean hasExtension(String name, String ext) {
        if (StringUtil.isEmpty(name)) {
            return false;
        }
        return FilenameUtil.getExtension(name).equalsIgnoreCase(ext);
    }
}

