/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.StringResources;
import org.tizen.device.manager.control.DeviceCheckSelectEvent;
import org.tizen.device.manager.control.FilePushPullController;
import org.tizen.device.manager.controller.ColumnFilterEvent;
import org.tizen.device.manager.controller.DeviceConnectionCell;
import org.tizen.device.manager.controller.DeviceFileTreeCell;
import org.tizen.device.manager.controller.DeviceNameCell;
import org.tizen.device.manager.controller.DevicePlatformCell;
import org.tizen.device.manager.controller.DeviceTableRow;
import org.tizen.device.manager.controller.ProfileFilterTableColumn;
import org.tizen.device.manager.controller.StartExcutableHandler;
import org.tizen.device.manager.controller.TableSelectionListener;
import org.tizen.device.manager.data.AboutPageInfo;
import org.tizen.device.manager.data.DeviceDescriptor;
import org.tizen.device.manager.data.DeviceStateType;
import org.tizen.device.manager.file.explorer.FileEntryTreeData;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.model.DeviceEventHandler;
import org.tizen.device.manager.model.DeviceItem;
import org.tizen.device.manager.resources.FontKind;
import org.tizen.device.manager.resources.Fonts;
import org.tizen.device.manager.resources.ImageKind;
import org.tizen.device.manager.resources.Images;
import org.tizen.device.manager.resources.ImagesView;
import org.tizen.device.manager.service.IDeviceChangeListener;
import org.tizen.device.manager.service.impl.ActionProcessor;
import org.tizen.device.manager.service.impl.DeviceChangedListenerManager;
import org.tizen.device.manager.ui.diaglog.ButtonType;
import org.tizen.device.manager.ui.diaglog.Dialog;
import org.tizen.device.manager.ui.diaglog.RemoteDeviceManagerDialog;
import org.tizen.device.manager.ui.diaglog.SettingsDialog;

public class FXMLDeviceTableViewController
implements Initializable {
    private static double TABLE_DEFAULT_WIDTH = 1000.0;
    @FXML
    private AnchorPane rootPane;
    @FXML
    private Label labTitle1;
    @FXML
    private Label labTitle2;
    @FXML
    private ImageView imgTitle;
    @FXML
    private Button btnEmulator;
    @FXML
    private Button btnRemote;
    @FXML
    private Button btnPackage;
    @FXML
    private Button btnSettings;
    @FXML
    private Button btnAbout;
    @FXML
    private Button btnPush;
    @FXML
    private Button btnPull;
    @FXML
    private TableView<DeviceItem> deviceTable;
    @FXML
    private TableColumn<DeviceItem, String> deviceStatus;
    @FXML
    private ProfileFilterTableColumn<DeviceItem, String> deviceName;
    @FXML
    private TableColumn<DeviceItem, String> deviceConnect;
    @FXML
    private TableColumn<DeviceItem, String> devicePlatform;
    @FXML
    private TableColumn<DeviceItem, String> devicePort;
    @FXML
    private final ObservableList<DeviceItem> data = FXCollections.observableArrayList();
    @FXML
    private final ObservableList<DeviceItem> filteredData = FXCollections.observableArrayList();
    @FXML
    private ProgressIndicator progress;
    @FXML
    private TreeView<FileEntryTreeData> locationTreeView;
    @FXML
    private Label deviceNameLabel;
    @FXML
    private Label deviceIconLabel;
    @FXML
    private Label deviceDescLabel;
    private List<String> filterList = new ArrayList<String>();
    private final Set<String> profileSet = new HashSet<String>();
    private TreeItem<FileEntryTreeData> oldTreeItem;
    private TreeItem<FileEntryTreeData> treeRoot;

    public void initialize(URL location, ResourceBundle resources) {
        this.intializeTable();
    }

    private void intializeTable() {
        this.labTitle1.setFont(Fonts.get(FontKind.FONT_18));
        this.labTitle2.setFont(Fonts.get(FontKind.FONT_32_BOLD));
        this.imgTitle.setImage(Images.get(ImageKind.TITLE_BG));
        this.btnEmulator.setGraphic((Node)Images.getView(ImageKind.EMULATOR_MANAGER_NOR));
        this.btnEmulator.tooltipProperty().set((Object)new Tooltip(Messages.Toolbar_Emulator_Manager_Button_Tooltip));
        this.btnRemote.setGraphic((Node)Images.getView(ImageKind.REMOTE_MANAGER_NOR));
        this.btnRemote.tooltipProperty().set((Object)new Tooltip(Messages.Toolbar_Remote_Device_Manager_Button_Tooltip));
        this.btnPackage.setGraphic((Node)Images.getView(ImageKind.PACKAGE_MANAGER_NOR));
        this.btnPackage.tooltipProperty().set((Object)new Tooltip(Messages.Toolbar_Package_Manager_Button_Tooltip));
        this.btnSettings.setGraphic((Node)Images.getView(ImageKind.DEVICE_SETTING_NOR));
        this.btnAbout.setGraphic((Node)Images.getView(ImageKind.DEVICE_INFO_NOR));
        this.btnPush.setGraphic((Node)Images.getView(ImageKind.ICON_PUSH_DIM));
        this.btnPush.tooltipProperty().set((Object)new Tooltip(Messages.Toolbar_Push_Button_Tooltip));
        this.btnPush.setDisable(true);
        this.btnPull.setGraphic((Node)Images.getView(ImageKind.ICON_PULL_DIM));
        this.btnPull.tooltipProperty().set((Object)new Tooltip(Messages.Toolbar_Pull_Button_Tooltip));
        this.btnPull.setDisable(true);
        HBox.setMargin((Node)this.btnSettings, (Insets)new Insets(0.0, 10.0, 15.0, 0.0));
        HBox.setMargin((Node)this.btnAbout, (Insets)new Insets(0.0, 10.0, 15.0, 0.0));
        this.btnEmulator.defaultButtonProperty().bind((ObservableValue)this.btnEmulator.focusedProperty());
        this.btnRemote.defaultButtonProperty().bind((ObservableValue)this.btnRemote.focusedProperty());
        this.btnPackage.defaultButtonProperty().bind((ObservableValue)this.btnPackage.focusedProperty());
        this.btnAbout.setFocusTraversable(false);
        this.deviceDescLabel.setText(Messages.Device_Table_Select_Message);
        DeviceEventHandler.getIsVisible().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> value, Boolean oldValue, Boolean newValue) {
                if (newValue == null) {
                    return;
                }
                if (newValue.booleanValue()) {
                    FXMLDeviceTableViewController.this.progress.getParent().setVisible(true);
                    FXMLDeviceTableViewController.this.progress.setVisible(true);
                    DeviceLogger.getLogger().fine("Show progress indicator");
                } else {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FXMLDeviceTableViewController.this.progress.getParent().setVisible(false);
                            FXMLDeviceTableViewController.this.progress.setVisible(false);
                            DeviceLogger.getLogger().fine("Hide progress indicator");
                        }
                    });
                }
            }
        });
        this.deviceTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.deviceTable.getSelectionModel().getSelectedIndices().addListener((ListChangeListener)new TableSelectionListener(this.deviceTable));
        this.deviceTable.setRowFactory(DeviceTableRow.extractor());
        this.deviceTable.setPlaceholder((Node)new Label(Messages.Device_Table_Empty_Message));
        this.deviceTable.setItems(this.filteredData);
        this.deviceTable.getColumns().addListener(new ListChangeListener<TableColumn<DeviceItem, ?>>(){

            public void onChanged(ListChangeListener.Change<? extends TableColumn<DeviceItem, ?>> change) {
                change.next();
                if (change.wasReplaced()) {
                    FXMLDeviceTableViewController.this.deviceTable.getColumns().clear();
                    FXMLDeviceTableViewController.this.deviceTable.getColumns().addAll((Object[])new TableColumn[]{FXMLDeviceTableViewController.this.deviceName, FXMLDeviceTableViewController.this.devicePlatform, FXMLDeviceTableViewController.this.devicePort, FXMLDeviceTableViewController.this.deviceConnect});
                }
            }
        });
        this.deviceTable.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.createFileExplorerView((DeviceItem)newValue));
        this.deviceName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.deviceName.setCellFactory(DeviceNameCell.extractor());
        this.deviceName.setMinWidth(80.0);
        this.deviceName.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().multiply(135.0 / TABLE_DEFAULT_WIDTH));
        this.devicePlatform.setCellValueFactory((Callback)new PropertyValueFactory("platform"));
        this.devicePlatform.setCellFactory(DevicePlatformCell.extractor());
        this.devicePlatform.setMinWidth(80.0);
        this.devicePlatform.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().multiply(127.0 / TABLE_DEFAULT_WIDTH));
        this.devicePort.setCellValueFactory((Callback)new PropertyValueFactory("port"));
        this.devicePort.setMinWidth(80.0);
        this.devicePort.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().multiply(121.0 / TABLE_DEFAULT_WIDTH));
        this.deviceConnect.setCellValueFactory((Callback)new PropertyValueFactory("connect"));
        this.deviceConnect.setCellFactory(DeviceConnectionCell.extractor());
        this.deviceConnect.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().multiply(70.0 / TABLE_DEFAULT_WIDTH));
        this.addDeviceListener();
        this.deviceTable.addEventHandler(ColumnFilterEvent.FILTER_CHANGED_EVENT, (EventHandler)new EventHandler<ColumnFilterEvent>(){

            public void handle(ColumnFilterEvent e) {
                FXMLDeviceTableViewController.this.filterList = e.getFilters();
                FXMLDeviceTableViewController.this.setFilterPopupValue();
                FXMLDeviceTableViewController.this.applyFilter(true);
                boolean isFilterWorking = false;
                for (String profile : FXMLDeviceTableViewController.this.profileSet) {
                    if (FXMLDeviceTableViewController.this.filterList.contains(profile)) continue;
                    isFilterWorking = true;
                    break;
                }
                e.getFilterButton().changeIcon(isFilterWorking);
            }
        });
        this.deviceTable.addEventHandler(DeviceCheckSelectEvent.DEVICE_CHECK_SELECTED, (EventHandler)new EventHandler<DeviceCheckSelectEvent>(){

            public void handle(DeviceCheckSelectEvent arg0) {
                if (FXMLDeviceTableViewController.this.deviceTable.getItems().size() < 1) {
                    return;
                }
                if (arg0.isChecked()) {
                    FXMLDeviceTableViewController.this.deviceTable.getSelectionModel().selectAll();
                } else {
                    FXMLDeviceTableViewController.this.deviceTable.getSelectionModel().clearSelection();
                }
            }
        });
    }

    private boolean containsDeviceItem(DeviceItem deviceItem, ObservableList<DeviceItem> list) {
        for (DeviceItem item : list) {
            if (!item.getPort().equals(deviceItem.getPort())) continue;
            return true;
        }
        return false;
    }

    private void applyFilter(boolean resetSelection) {
        int selectIndex = resetSelection ? 0 : this.deviceTable.getSelectionModel().getSelectedIndex();
        for (DeviceItem item : this.data) {
            if (!this.filterList.contains(item.getProfile()) || this.containsDeviceItem(item, this.filteredData)) continue;
            this.filteredData.add(0, (Object)item);
        }
        ArrayList<DeviceItem> removeItem = new ArrayList<DeviceItem>();
        for (DeviceItem item : this.filteredData) {
            if (this.filterList.contains(item.getProfile()) && this.containsDeviceItem(item, this.data)) continue;
            removeItem.add(item);
        }
        this.filteredData.removeAll(removeItem);
        this.deviceTable.getSelectionModel().clearSelection();
        if (selectIndex >= this.deviceTable.getItems().size()) {
            selectIndex = this.deviceTable.getItems().size() - 1;
        }
        this.deviceTable.getSelectionModel().clearAndSelect(selectIndex);
    }

    private void checkProfileList(String profile, boolean isAdd) {
        if (isAdd) {
            if (!this.profileSet.contains(profile)) {
                this.profileSet.add(profile);
                this.filterList.add(profile);
            }
        } else {
            this.profileSet.remove(profile);
            for (DeviceItem item : this.data) {
                this.profileSet.add(item.getProfile());
            }
            if (!this.profileSet.contains(profile)) {
                this.filterList.remove(profile);
            }
        }
        this.setFilterPopupValue();
    }

    private void setFilterPopupValue() {
        HashMap<String, Boolean> filterValue = new HashMap<String, Boolean>();
        for (String p : this.profileSet) {
            filterValue.put(p, this.filterList.contains(p));
        }
        this.deviceName.setFilterValue(filterValue);
    }

    @FXML
    public void aboutButtonMouseEvent(MouseEvent event) {
        if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.btnAbout.setGraphic((Node)Images.getView(ImageKind.DEVICE_INFO_OVER));
        } else if (event.getEventType() == MouseEvent.MOUSE_CLICKED) {
            this.btnAbout.setGraphic((Node)Images.getView(ImageKind.DEVICE_INFO_PRESS));
        } else {
            this.btnAbout.setGraphic((Node)Images.getView(ImageKind.DEVICE_INFO_NOR));
        }
    }

    @FXML
    public void settingsButtonMouseEvent(MouseEvent event) {
        if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.btnSettings.setGraphic((Node)Images.getView(ImageKind.DEVICE_SETTING_OVER));
        } else if (event.getEventType() == MouseEvent.MOUSE_CLICKED) {
            this.btnSettings.setGraphic((Node)Images.getView(ImageKind.DEVICE_SETTING_PRESS));
        } else {
            this.btnSettings.setGraphic((Node)Images.getView(ImageKind.DEVICE_SETTING_NOR));
        }
    }

    @FXML
    public void clickSettingsButton(ActionEvent event) {
        SettingsDialog dialog = new SettingsDialog();
        String result = (String)dialog.showAndWait();
    }

    @FXML
    public void clickAboutButton(ActionEvent event) {
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.About_Dialog_Title);
        dialog.addButonType(ButtonType.CLOSE);
        VBox content = null;
        try {
            content = (VBox)FXMLLoader.load((URL)this.getClass().getResource("/view/AboutView.fxml"));
        }
        catch (Exception e) {
            DeviceLogger.getLogger().log(Level.SEVERE, "Failed to load from about page by Exception: " + e);
        }
        if (content == null) {
            AboutPageInfo about = AboutPageInfo.getInstance();
            String contents = "Version: " + about.getAboutVersion() + StringResources.NEW_LINE + "Build time: " + about.getBuildTime() + " (GMT)" + StringResources.NEW_LINE + "Git version: " + about.getGitVersion() + StringResources.NEW_LINE + "Workspace path: " + about.getWorkspacePath() + StringResources.NEW_LINE + "Package version: " + about.getPackageVersion();
            dialog.setContentText(contents);
        } else {
            AnchorPane pane = new AnchorPane();
            pane.getChildren().add((Object)content);
            AnchorPane.setLeftAnchor((Node)content, (Double)-1.0);
            AnchorPane.setRightAnchor((Node)content, (Double)-1.0);
            AnchorPane.setTopAnchor((Node)content, (Double)-1.0);
            dialog.getDialogPane().setContent((Node)pane);
            content.autosize();
        }
        dialog.getDialogPane().getButton(ButtonType.CLOSE).requestFocus();
        dialog.setResizable(false);
        dialog.show();
    }

    private DeviceItem getSelectedItem() {
        List<DeviceItem> items = this.getDeviceItems();
        if (items.isEmpty()) {
            return null;
        }
        return items.get(0);
    }

    private List<DeviceItem> getDeviceItems() {
        ArrayList<DeviceItem> items = new ArrayList<DeviceItem>();
        for (int i = 0; i < this.deviceTable.getItems().size(); ++i) {
            items.add((DeviceItem)this.deviceTable.getItems().get(i));
        }
        if (items.isEmpty()) {
            DeviceLogger.getLogger().warning("Selected item list is empty...");
        }
        return items;
    }

    @FXML
    public void clickStartEmulatorButton(ActionEvent event) {
        DeviceLogger.getLogger().fine("Click Start Emulator Manager button");
        StartExcutableHandler.StartEmulatorManager();
    }

    @FXML
    public void clickRemoteDeviceManagerButton(ActionEvent event) {
        DeviceLogger.getLogger().fine("Click Remote Device Manager button");
        new RemoteDeviceManagerDialog(this.getDeviceItems());
    }

    @FXML
    public void clickPackageManagerButton(ActionEvent event) {
        DeviceLogger.getLogger().fine("Click Package Manager button");
        ActionProcessor.startPackageManager();
    }

    @FXML
    public void startEmulatorManagerMouseEvent(MouseEvent event) {
        if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.btnEmulator.setGraphic((Node)Images.getView(ImageKind.EMULATOR_MANAGER_OVER));
        } else if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.btnEmulator.setGraphic((Node)Images.getView(ImageKind.EMULATOR_MANAGER_PRESS));
        } else {
            this.btnEmulator.setGraphic((Node)Images.getView(ImageKind.EMULATOR_MANAGER_NOR));
        }
    }

    @FXML
    public void startRemoteDeviceManagerMouseEvent(MouseEvent event) {
        DeviceLogger.getLogger().fine("Click Remote Device Manager button");
        if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.btnRemote.setGraphic((Node)Images.getView(ImageKind.REMOTE_MANAGER_OVER));
        } else if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.btnRemote.setGraphic((Node)Images.getView(ImageKind.REMOTE_MANAGER_PRESS));
        } else {
            this.btnRemote.setGraphic((Node)Images.getView(ImageKind.REMOTE_MANAGER_NOR));
        }
    }

    @FXML
    public void startPackageManagerMouseEvent(MouseEvent event) {
        DeviceLogger.getLogger().fine("Click Package Manager button");
        if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.btnPackage.setGraphic((Node)Images.getView(ImageKind.PACKAGE_MANAGER_OVER));
        } else if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.btnPackage.setGraphic((Node)Images.getView(ImageKind.PACKAGE_MANAGER_PRESS));
        } else {
            this.btnPackage.setGraphic((Node)Images.getView(ImageKind.PACKAGE_MANAGER_NOR));
        }
    }

    @FXML
    public void pushButtonMouseEvent(MouseEvent event) {
        DeviceLogger.getLogger().fine("Click push the file button");
        if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.btnPush.setGraphic((Node)Images.getView(ImageKind.ICON_PUSH_OVER));
        } else if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.btnPush.setGraphic((Node)Images.getView(ImageKind.ICON_PUSH_PRESS));
        } else {
            this.btnPush.setGraphic((Node)Images.getView(ImageKind.ICON_PUSH_NOR));
        }
    }

    @FXML
    public void pullButtonMouseEvent(MouseEvent event) {
        DeviceLogger.getLogger().fine("Click pull the file button");
        if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.btnPull.setGraphic((Node)Images.getView(ImageKind.ICON_PULL_OVER));
        } else if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.btnPull.setGraphic((Node)Images.getView(ImageKind.ICON_PULL_PRESS));
        } else {
            this.btnPull.setGraphic((Node)Images.getView(ImageKind.ICON_PULL_NOR));
        }
    }

    private void addDeviceListener() {
        DeviceChangedListenerManager.addListener(new IDeviceChangeListener(){

            @Override
            public void targetsChanged(final DeviceDescriptor device, final DeviceStateType changeMask) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        switch (changeMask) {
                            case ONLINE: {
                                DeviceLogger.getLogger().fine("Create Device Info: " + device.getDeviceName());
                                String onlineDeviceSerialId = device.getSerialId();
                                boolean isExistDevice = false;
                                for (int i = 0; i < FXMLDeviceTableViewController.this.data.size(); ++i) {
                                    DeviceItem item = (DeviceItem)FXMLDeviceTableViewController.this.data.get(i);
                                    if (!item.getPort().equals(onlineDeviceSerialId)) continue;
                                    isExistDevice = true;
                                    if (!device.getDeviceType().isRemoteDevice()) break;
                                    item.setValue(device);
                                    break;
                                }
                                if (!isExistDevice) {
                                    FXMLDeviceTableViewController.this.data.add(0, (Object)new DeviceItem(device));
                                }
                                FXMLDeviceTableViewController.this.checkProfileList(device.getProfileName(), true);
                                FXMLDeviceTableViewController.this.applyFilter(true);
                                break;
                            }
                            case OFFLINE: {
                                String offlineDeviceSerialId = device.getSerialId();
                                DeviceLogger.getLogger().fine("Delete Device Info: " + device.getDeviceName());
                                for (int i = 0; i < FXMLDeviceTableViewController.this.data.size(); ++i) {
                                    DeviceItem item = (DeviceItem)FXMLDeviceTableViewController.this.data.get(i);
                                    if (!item.getPort().equals(offlineDeviceSerialId)) continue;
                                    if (device.getDeviceType().isRemoteDevice()) {
                                        item.setValue(device);
                                        break;
                                    }
                                    FXMLDeviceTableViewController.this.data.remove(i);
                                    break;
                                }
                                FXMLDeviceTableViewController.this.checkProfileList(device.getProfileName(), false);
                                FXMLDeviceTableViewController.this.applyFilter(false);
                                break;
                            }
                        }
                    }
                });
            }
        });
    }

    private void createFileExplorerView(DeviceItem item) {
        if (item == null || item.connectProperty().getValue().equalsIgnoreCase(DeviceStateType.OFFLINE.name())) {
            this.deviceIconLabel.setGraphic(null);
            this.deviceNameLabel.setText("");
            this.locationTreeView.setRoot(null);
            return;
        }
        this.btnPush.setGraphic((Node)Images.getView(ImageKind.ICON_PUSH_DIM));
        this.btnPull.setGraphic((Node)Images.getView(ImageKind.ICON_PULL_DIM));
        this.btnPush.setDisable(true);
        this.btnPull.setDisable(true);
        this.treeRoot = new TreeItem((Object)new FileEntryTreeData(item.getDeviceDescriptor()));
        this.treeRoot.setExpanded(true);
        this.locationTreeView.setRoot(this.treeRoot);
        this.locationTreeView.setCellFactory(DeviceFileTreeCell.extractor());
        this.locationTreeView.setShowRoot(false);
        this.locationTreeView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.locationTreeView.getStylesheets().add((Object)this.getClass().getResource("/view/tree_view.css").toExternalForm());
        this.locationTreeView.getStyleClass().add((Object)"tree-cell:selected");
        this.locationTreeView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<FileEntryTreeData>>(){

            public void changed(ObservableValue<? extends TreeItem<FileEntryTreeData>> observable, TreeItem<FileEntryTreeData> oldValue, TreeItem<FileEntryTreeData> newValue) {
                if (newValue == null) {
                    return;
                }
                if (((FileEntryTreeData)newValue.getValue()).getFileEntry().isDirectory()) {
                    FXMLDeviceTableViewController.this.btnPush.setGraphic((Node)Images.getView(ImageKind.ICON_PUSH_NOR));
                    FXMLDeviceTableViewController.this.btnPull.setGraphic((Node)Images.getView(ImageKind.ICON_PULL_NOR));
                    FXMLDeviceTableViewController.this.btnPush.setDisable(false);
                    FXMLDeviceTableViewController.this.btnPull.setDisable(false);
                } else {
                    FXMLDeviceTableViewController.this.btnPush.setGraphic((Node)Images.getView(ImageKind.ICON_PUSH_DIM));
                    FXMLDeviceTableViewController.this.btnPull.setGraphic((Node)Images.getView(ImageKind.ICON_PULL_NOR));
                    FXMLDeviceTableViewController.this.btnPush.setDisable(true);
                    FXMLDeviceTableViewController.this.btnPull.setDisable(false);
                }
                if (newValue == FXMLDeviceTableViewController.this.treeRoot) {
                    if (FXMLDeviceTableViewController.this.oldTreeItem != null) {
                        FXMLDeviceTableViewController.this.locationTreeView.getSelectionModel().select((Object)FXMLDeviceTableViewController.this.oldTreeItem);
                    }
                    return;
                }
                if (newValue.getValue() == null) {
                    return;
                }
                FXMLDeviceTableViewController.this.oldTreeItem = newValue;
            }
        });
        if (item.getDeviceType().isEmulator()) {
            this.deviceIconLabel.setGraphic((Node)ImagesView.getImageView(ImageKind.IMAGE_ROOT_EMULATOR.getFullName()));
        } else {
            this.deviceIconLabel.setGraphic((Node)ImagesView.getImageView(ImageKind.IMAGE_ROOT_DEVICE.getFullName()));
        }
        this.deviceNameLabel.setText(item.getDisplayDeviceName());
        this.deviceNameLabel.prefWidthProperty().bind((ObservableValue)this.locationTreeView.widthProperty().multiply(0.6));
        DeviceEventHandler.createFileExplorer(item, this.treeRoot);
    }

    @FXML
    public void clickPushButton(ActionEvent event) throws IOException {
        if (this.locationTreeView.getSelectionModel().getSelectedItem() == null) {
            return;
        }
        FilePushPullController.pushToDevice((FileEntryTreeData)((TreeItem)this.locationTreeView.getSelectionModel().getSelectedItem()).getValue(), this.locationTreeView);
    }

    @FXML
    public void clickPullButton(ActionEvent event) throws IOException {
        if (this.locationTreeView.getSelectionModel().getSelectedItem() == null) {
            return;
        }
        FilePushPullController.pullFromDevice(this.getSelectedItem().getDeviceDescriptor().getIDevice(), this.locationTreeView);
    }
}

