/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdb.command;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.json.simple.parser.ParseException;
import org.tizen.sdb.Channel;
import org.tizen.sdb.CommandRequest;
import org.tizen.sdb.CommandResponse;

public class CrashReport {
    private Channel channel = null;
    private CommandRequest request = new CommandRequest();
    private CommandResponse response = null;

    public CrashReport(String deviceSerial) {
        this.request.setCommand("crash-report");
        this.request.setTarget(deviceSerial);
    }

    public SocketChannel openChannel() throws IOException {
        this.channel = new Channel();
        this.channel.connect();
        if (!this.channel.writeCommand(this.request.makeJson())) {
            throw new IOException("failed to send command to server");
        }
        String commandData = this.channel.readCommand();
        try {
            this.response = new CommandResponse(commandData);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new IOException("failed to read command from server by " + e.getMessage());
        }
        if (this.response.getStatusCode() != 0) {
            this.channel.close();
            return null;
        }
        return this.channel.getSocketChannel();
    }

    public boolean read() throws IOException {
        String commandData = this.channel.readCommand();
        try {
            this.response = new CommandResponse(commandData);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new IOException("failed to read command from server by " + e.getMessage());
        }
        if (this.response.getStatusCode() != 0) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            return false;
        }
        return true;
    }

    public String getPath() {
        return this.response != null ? this.response.getResult() : "";
    }
}

