/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CommandRequest {
    private static final String TARGET = "target";
    private static final String COMMAND = "command";
    private static final String NAME = "name";
    private static final String PARAMETER = "parameter";
    private static final String EXTRAOPTS = "extraOpts";
    private static final String TYPE = "type";
    private static final String STANDARD = "standard";
    private static final String CURRENT_DIRECTORY = "currentDirectory";
    private String currentDirectory = "";
    private String jsonCommand = "";
    private String target = "";
    private String commandType = "standard";
    private String command = "";
    private List<String> parameters = new ArrayList<String>();
    private List<String> extraOptions = new ArrayList<String>();

    public String makeJson() {
        JSONObject rootObject = new JSONObject();
        rootObject.put((Object)TARGET, (Object)this.target);
        JSONObject commandObject = new JSONObject();
        commandObject.put((Object)CURRENT_DIRECTORY, (Object)this.currentDirectory);
        commandObject.put((Object)NAME, (Object)this.command);
        JSONArray listParameters = new JSONArray();
        int i = 0;
        while (i < this.parameters.size()) {
            listParameters.add((Object)this.parameters.get(i));
            ++i;
        }
        commandObject.put((Object)PARAMETER, (Object)listParameters);
        JSONArray listExtraOptions = new JSONArray();
        int i2 = 0;
        while (i2 < this.extraOptions.size()) {
            listExtraOptions.add((Object)this.extraOptions.get(i2));
            ++i2;
        }
        commandObject.put((Object)EXTRAOPTS, (Object)listExtraOptions);
        commandObject.put((Object)TYPE, (Object)this.commandType);
        rootObject.put((Object)COMMAND, (Object)commandObject);
        return rootObject.toJSONString();
    }

    public void parseJson(JSONObject jsonRoot) {
        this.target = (String)jsonRoot.get((Object)TARGET);
        JSONObject commandObject = (JSONObject)jsonRoot.get((Object)COMMAND);
        this.command = (String)commandObject.get((Object)NAME);
        this.currentDirectory = (String)commandObject.get((Object)CURRENT_DIRECTORY);
        this.parameters.clear();
        JSONArray list = (JSONArray)commandObject.get((Object)PARAMETER);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.parameters.add((String)iterator.next());
        }
        this.extraOptions.clear();
        list = (JSONArray)commandObject.get((Object)EXTRAOPTS);
        iterator = list.iterator();
        while (iterator.hasNext()) {
            this.extraOptions.add((String)iterator.next());
        }
        this.commandType = (String)commandObject.get((Object)TYPE);
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public String getJsonCommand() {
        return this.jsonCommand;
    }

    public String getTarget() {
        return this.target;
    }

    public String getCommand() {
        return this.command;
    }

    public String getCommandType() {
        return this.commandType;
    }

    public List<String> getExtraOptions() {
        return this.extraOptions;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setCurrentDirectory(String currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public void setJsonCommand(String jsonCommand) {
        this.jsonCommand = jsonCommand;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setCommandType(String commandType) {
        this.commandType = commandType;
    }

    public void addParameter(String parameter) {
        this.parameters.add(parameter);
    }

    public void replaceParameter(int index, String newParameter) {
        this.parameters.set(index, newParameter);
    }

    public void addExtraOption(String extraOption) {
        this.extraOptions.add(extraOption);
    }
}

