/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.controller;

import java.io.IOException;
import java.util.concurrent.Callable;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import org.tizen.device.manager.StringResources;
import org.tizen.device.manager.controller.TaskCompletionListener;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.resources.SimpleExecutor;
import org.tizen.device.manager.service.impl.ActionProcessor;
import org.tizen.device.manager.ui.diaglog.MessageBox;

public class StartExcutableHandler {
    private static SimpleBooleanProperty isVisible = new SimpleBooleanProperty(false);
    private static TaskCompletionListener<String> completionListener = new TaskCompletionListener<String>(){

        @Override
        public void completed(final String result) {
            DeviceLogger.getLogger().fine("Stop progress indicator");
            if (!result.isEmpty()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MessageBox.error("Error", result);
                    }
                });
            }
            StartExcutableHandler.setProgress(false);
        }
    };

    public static SimpleBooleanProperty getIsVisible() {
        return isVisible;
    }

    public static void StartEmulatorManager() {
        SimpleExecutor.asynExecute(new Callable<String>(){
            private String returnMsg;

            @Override
            public String call() throws Exception {
                this.returnMsg = "";
                try {
                    ActionProcessor.startEmulatorManager();
                }
                catch (IOException e) {
                    this.returnMsg = "Failed to launch emulator manager : " + StringResources.NEW_LINE + StringResources.NEW_LINE + e.getMessage();
                }
                return this.returnMsg;
            }
        }, completionListener);
    }

    private static void setProgress(boolean visible) {
        isVisible.set(visible);
    }
}

