/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.ui.diaglog;

import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.util.Callback;
import org.tizen.device.manager.Main;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.controller.SettingsPageChangeListener;
import org.tizen.device.manager.data.SettingsPageInfo;
import org.tizen.device.manager.ui.diaglog.ButtonType;
import org.tizen.device.manager.ui.diaglog.Dialog;
import org.tizen.device.manager.ui.diaglog.ISettingsPropertyPage;
import org.tizen.device.manager.ui.diaglog.SettingsDevicePropertyPage;
import org.tizen.device.manager.ui.diaglog.SettingsGeneralPropertyPage;
import org.tizen.device.manager.ui.diaglog.SettingsLogviewPropertyPage;

public class SettingsDialog
extends Dialog<String> {
    private TabPane tabPane;
    private Button okButton;
    private SettingsGeneralPropertyPage generalPage;
    private SettingsDevicePropertyPage devicePage;
    private SettingsLogviewPropertyPage logviewPage;
    private SettingsPageChangeListener pageUpdateListener = new SettingsPageChangeListener(){

        @Override
        public void pageValueChanged() {
            if (SettingsDialog.this.generalPage.isPageValueValidate() && SettingsDialog.this.devicePage.isPageValueValidate() && SettingsDialog.this.logviewPage.isPageValueValidate()) {
                SettingsDialog.this.okButton.setDisable(false);
            } else {
                SettingsDialog.this.okButton.setDisable(true);
            }
        }
    };

    public SettingsDialog() {
        this.createContent();
        this.setResultConverter(new Callback<ButtonType, String>(){

            public String call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    SettingsPageInfo.getInstance().setDeviceConnectionTimeout(Integer.parseInt(SettingsDialog.this.devicePage.getTimeout()));
                    SettingsPageInfo.getInstance().setLogBufferSize(Integer.parseInt(SettingsDialog.this.logviewPage.getBufferSize()));
                    return "success";
                }
                return null;
            }
        });
    }

    private Tab createNewTab(ISettingsPropertyPage page) {
        Tab tab = new Tab();
        Label label = new Label(page.getTitle());
        label.setMinWidth(80.0);
        label.getStyleClass().add((Object)"left-tab-label");
        tab.setGraphic((Node)label);
        tab.setClosable(false);
        tab.setContent(page.getNode());
        return tab;
    }

    private void createContent() {
        this.setTitle(Messages.Settings_Dialog_Title);
        this.getDialogPane().getButtonTypes().add((Object)ButtonType.OK);
        this.getDialogPane().getButtonTypes().add((Object)ButtonType.CLOSE);
        this.okButton = this.getDialogPane().getButton(ButtonType.OK);
        this.okButton.setDisable(true);
        this.tabPane = new TabPane();
        this.tabPane.setSide(Side.LEFT);
        this.tabPane.setRotateGraphic(true);
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.tabPane.getStylesheets().add((Object)Main.class.getResource("/view/tab_view.css").toExternalForm());
        this.tabPane.getStylesheets().addAll(Main.getBaseCssUrl());
        this.tabPane.setMinSize(700.0, 350.0);
        this.getDialogPane().setContent((Node)this.tabPane);
        this.generalPage = new SettingsGeneralPropertyPage();
        this.generalPage.addSettingsPageChangeListener(this.pageUpdateListener);
        this.tabPane.getTabs().add((Object)this.createNewTab(this.generalPage));
        this.devicePage = new SettingsDevicePropertyPage();
        this.devicePage.addSettingsPageChangeListener(this.pageUpdateListener);
        this.tabPane.getTabs().add((Object)this.createNewTab(this.devicePage));
        this.logviewPage = new SettingsLogviewPropertyPage();
        this.logviewPage.addSettingsPageChangeListener(this.pageUpdateListener);
        this.tabPane.getTabs().add((Object)this.createNewTab(this.logviewPage));
    }
}

