/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.ui.diaglog;

import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.controller.SettingsPageChangeListener;
import org.tizen.device.manager.data.SettingsPageInfo;
import org.tizen.device.manager.ui.diaglog.ISettingsPropertyPage;

public class SettingsLogviewPropertyPage
implements ISettingsPropertyPage {
    private GridPane gridPane;
    private TextField textFieldBufferSize;
    private Text textBufferSize;
    private ArrayList<SettingsPageChangeListener> pageChangeListeners = new ArrayList();

    public SettingsLogviewPropertyPage() {
        this.createContent();
        this.addChangeListener();
    }

    private void createContent() {
        this.gridPane = new GridPane();
        this.gridPane.setPadding(new Insets(20.0, 10.0, 10.0, 10.0));
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        Label labelBufferSize = new Label(Messages.Settings_Dialog_Label_Buffer_Size);
        labelBufferSize.setMinWidth(90.0);
        this.textFieldBufferSize = new TextField();
        this.textFieldBufferSize.setMinWidth(450.0);
        this.textFieldBufferSize.setText(Integer.toString(SettingsPageInfo.getInstance().getLogBufferSize()));
        this.textFieldBufferSize.setEditable(true);
        this.textBufferSize = new Text();
        this.textBufferSize.setText("");
        this.textBufferSize.setFill((Paint)Color.RED);
        this.gridPane.add((Node)labelBufferSize, 0, 1);
        this.gridPane.add((Node)this.textFieldBufferSize, 1, 1);
        this.gridPane.add((Node)this.textBufferSize, 1, 2);
    }

    private void addChangeListener() {
        this.textFieldBufferSize.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    for (SettingsPageChangeListener listener : SettingsLogviewPropertyPage.this.pageChangeListeners) {
                        listener.pageValueChanged();
                    }
                    if (SettingsLogviewPropertyPage.this.isValidBufferSize()) {
                        SettingsLogviewPropertyPage.this.textBufferSize.setText("");
                    } else {
                        SettingsLogviewPropertyPage.this.textBufferSize.setText(Messages.Settings_Dialog_Invalid_Buffer_Size_Message);
                    }
                }
            }
        });
    }

    private boolean isValidBufferSize() {
        try {
            int bufferSize = Integer.parseInt(this.textFieldBufferSize.getText());
            return SettingsPageInfo.getInstance().isValidBufferSize(bufferSize);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getBufferSize() {
        return this.textFieldBufferSize.getText();
    }

    @Override
    public Node getNode() {
        return this.gridPane;
    }

    @Override
    public String getTitle() {
        return TAB_NAME_LOGVIEW;
    }

    @Override
    public String getDescription() {
        return TAB_NAME_LOGVIEW;
    }

    @Override
    public boolean isPageValueValidate() {
        return this.isValidBufferSize();
    }

    @Override
    public void addSettingsPageChangeListener(SettingsPageChangeListener listener) {
        this.pageChangeListeners.add(listener);
    }
}

