/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tizen.device.manager.data.DeviceDescriptor;
import org.tizen.device.manager.data.DeviceStateType;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.service.IDeviceChangeListener;
import org.tizen.device.manager.service.impl.DeviceChangedListener;
import org.tizen.device.manager.util.StringUtil;

public final class DeviceChangedListenerManager
implements IDeviceChangeListener {
    private static DeviceChangedListenerManager instance = null;
    private static DeviceChangedListener deviceChangeListener = null;
    private static final List<IDeviceChangeListener> listeners = new LinkedList<IDeviceChangeListener>();
    private static final Map<String, DeviceDescriptor> deviceDescriptors = new LinkedHashMap<String, DeviceDescriptor>();
    private DeviceDescriptor defaultDeviceDescriptor = null;

    public void initializeListener() {
        if (deviceChangeListener == null) {
            deviceChangeListener = new DeviceChangedListener();
        }
    }

    public DeviceChangedListenerManager() {
        instance = this;
        this.initializeListener();
    }

    public static DeviceChangedListenerManager getInstance() {
        return instance;
    }

    public static void addListener(IDeviceChangeListener listener) {
        if (listener == null) {
            return;
        }
        listeners.add(listener);
    }

    public static void removeListener(IDeviceChangeListener listener) {
        if (listener == null) {
            return;
        }
        listeners.remove(listener);
    }

    void fireLaunchTargetsChanged(DeviceDescriptor device, DeviceStateType changeMask) {
        for (IDeviceChangeListener listener : listeners) {
            listener.targetsChanged(device, changeMask);
        }
    }

    public Map<String, DeviceDescriptor> getDeviceDescriptors() {
        return deviceDescriptors;
    }

    public String createTooltipName(String modelName, String profileName, String platformVersion, String resolution) {
        profileName = profileName.substring(0, 1).toUpperCase() + profileName.substring(1);
        if (StringUtil.isEmpty(resolution)) {
            return String.format("%s (%s %s)", modelName, profileName, platformVersion);
        }
        return String.format("%s (%s %s) - %s", modelName, profileName, platformVersion, resolution);
    }

    public String createTooltipName(String modelName, String profileName, String platformVersion) {
        return this.createTooltipName(modelName, profileName, platformVersion, null);
    }

    public synchronized void addDeviceDescriptor(DeviceDescriptor descriptor) {
        if (deviceDescriptors == null) {
            return;
        }
        deviceDescriptors.put(descriptor.getSerialId(), descriptor);
        DeviceLogger.log(String.format("Device descriptor(%s) has been added", descriptor.getSerialId()));
    }

    public synchronized void removeDeviceDescriptor(String deviceSerialId) {
        if (deviceDescriptors == null) {
            return;
        }
        deviceDescriptors.remove(deviceSerialId);
        DeviceLogger.log(String.format("Device descriptor(%s) has been removed", deviceSerialId));
        if (deviceDescriptors.isEmpty()) {
            this.defaultDeviceDescriptor = null;
            return;
        }
    }

    public DeviceDescriptor getDeviceDescriptor(String deviceName) {
        Map<String, DeviceDescriptor> deviceDescriptors = this.getDeviceDescriptors();
        for (DeviceDescriptor device : deviceDescriptors.values()) {
            if (!device.getDescriptorName().startsWith(deviceName)) continue;
            return device;
        }
        return null;
    }

    public static List<DeviceDescriptor> getSortedDeviceItem() {
        Collection<DeviceDescriptor> deviceItems = deviceDescriptors.values();
        ArrayList<DeviceDescriptor> list = new ArrayList<DeviceDescriptor>(deviceItems);
        Collections.sort(list);
        return list;
    }

    @Override
    public void targetsChanged(DeviceDescriptor device, DeviceStateType changeMask) {
    }
}

