/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.file.explorer;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeItem;
import org.tizen.device.manager.file.explorer.FileEntryTreeData;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.sdblib.service.FileEntry;

public class FileEntryTreeItemWorker {
    public void create(TreeItem<FileEntryTreeData> treeRoot) {
        FileEntry fileRoot = ((FileEntryTreeData)treeRoot.getValue()).getFileEntry();
        new ItemAddWorker(fileRoot, treeRoot).start();
    }

    public void create2(FileEntryTreeData test, TreeItem<FileEntryTreeData> parent) {
        new ItemAddWorker(test.getFileEntry(), parent).start();
    }

    class ItemAddWorker
    extends Thread {
        TreeItem<FileEntryTreeData> parent;
        FileEntry fileEntry;
        List<FileEntry> entries = new ArrayList<FileEntry>();
        Thread fileListingWorker = new Thread(new Runnable(){

            @Override
            public void run() {
                FileEntry[] entryArr;
                for (FileEntry en : entryArr = ItemAddWorker.this.fileEntry.getChildren(0)) {
                    ItemAddWorker.this.entries.add(en);
                }
            }
        });
        Runnable treeAddWorker = new Runnable(){

            @Override
            public void run() {
                ItemAddWorker.this.parent.getChildren().clear();
                for (FileEntry en : ItemAddWorker.this.entries) {
                    TreeItem newItem = new TreeItem((Object)new FileEntryTreeData(en));
                    ItemAddWorker.this.parent.getChildren().add((Object)newItem);
                    if (((FileEntryTreeData)newItem.getValue()).isDirectory()) {
                        newItem.getChildren().add((Object)new TreeItem());
                    }
                    ItemAddWorker.this.addExpandListener((TreeItem<FileEntryTreeData>)newItem);
                    ItemAddWorker.this.addRefreshListener((TreeItem<FileEntryTreeData>)newItem);
                }
                ((FileEntryTreeData)ItemAddWorker.this.parent.getValue()).setTreeItemState(FileEntryTreeData.TreeItemState.CHILD_CHECKED);
            }
        };

        public ItemAddWorker(FileEntry fileEntry, TreeItem<FileEntryTreeData> parent) {
            this.fileEntry = fileEntry;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.fileListingWorker.start();
            try {
                this.fileListingWorker.join();
            }
            catch (InterruptedException e) {
                DeviceLogger.getLogger().log(Level.SEVERE, "File Entry Worker Failed " + e);
            }
            Platform.runLater((Runnable)this.treeAddWorker);
        }

        private void addRefreshListener(final TreeItem<FileEntryTreeData> treeItem) {
            treeItem.valueProperty().addListener((ChangeListener)new ChangeListener<FileEntryTreeData>(){

                public void changed(ObservableValue<? extends FileEntryTreeData> observable, FileEntryTreeData oldValue, FileEntryTreeData newValue) {
                    if (newValue == null) {
                        return;
                    }
                    new ItemAddWorker(((FileEntryTreeData)treeItem.getValue()).getFileEntry(), (TreeItem<FileEntryTreeData>)treeItem).start();
                }
            });
        }

        private void addExpandListener(final TreeItem<FileEntryTreeData> treeItem) {
            treeItem.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                    if (arg2.booleanValue()) {
                        ((FileEntryTreeData)treeItem.getValue()).setTreeItemState(FileEntryTreeData.TreeItemState.CHILD_CHECKING);
                        new ItemAddWorker(((FileEntryTreeData)treeItem.getValue()).getFileEntry(), (TreeItem<FileEntryTreeData>)treeItem).start();
                    }
                }
            });
        }
    }
}

