/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.controller.TableSelectionListener;
import org.tizen.device.manager.extension.DeviceProfileType;
import org.tizen.device.manager.extension.IDeviceContextMenu;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.model.DeviceEventHandler;
import org.tizen.device.manager.model.DeviceItem;
import org.tizen.device.manager.resources.ROW_STATE;

public class DeviceTableRow
extends TableRow<DeviceItem> {
    private Object extMenuItemIdentifier = new Object();
    private final TableView<DeviceItem> table;
    private ServiceLoader<IDeviceContextMenu> loader;
    private Map<DeviceProfileType, List<MenuItem>> profileToMenuItems;
    private final ContextMenu contextMenu = new ContextMenu();
    private final MenuItem mAppInstall = new MenuItem(Messages.Device_Table_Context_Menu_Label_Install_App);
    private final MenuItem mAddLogTab = new MenuItem(Messages.Device_Table_Context_Menu_Label_Add_Log_Tab);
    private final MenuItem mDeleteLogTabs = new MenuItem(Messages.Device_Table_Context_Menu_Label_Delete_Log_Tab);
    private final MenuItem mConnect = new MenuItem(Messages.Device_Table_Context_Menu_Label_Connect);
    private final MenuItem mDisconnect = new MenuItem(Messages.Device_Table_Context_Menu_Label_Disconnet);
    private final MenuItem mDUIDItem = new MenuItem(Messages.Device_Table_Context_Menu_Labe_DUID);
    private final MenuItem mOpenShellItem = new MenuItem(Messages.Device_File_Context_menu_Label_Open_Shell);
    private final MenuItem mPermitToInstallItem = new MenuItem(Messages.Device_File_Context_menu_Label_Permit_To_Install);
    private final EventHandler<MouseEvent> mouseEvent = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            DeviceTableRow.this.mouseEventHandler(event);
        }
    };

    DeviceTableRow(final TableView<DeviceItem> table) {
        this.table = table;
        this.loader = ServiceLoader.load(IDeviceContextMenu.class);
        this.profileToMenuItems = new HashMap<DeviceProfileType, List<MenuItem>>();
        this.setOnMouseClicked(this.mouseEvent);
        this.setOnMouseEntered(this.mouseEvent);
        this.setOnMouseExited(this.mouseEvent);
        this.contextMenu.addEventHandler(WindowEvent.WINDOW_HIDDEN, (EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                ObservableList menuItems = DeviceTableRow.this.contextMenu.getItems();
                Iterator iterator = menuItems.iterator();
                while (iterator.hasNext()) {
                    MenuItem menuItem = (MenuItem)iterator.next();
                    if (menuItem.getUserData() != DeviceTableRow.this.extMenuItemIdentifier) continue;
                    iterator.remove();
                }
            }
        });
        ObservableList items = this.contextMenu.getItems();
        items.add((Object)this.mAppInstall);
        items.add((Object)new SeparatorMenuItem());
        items.add((Object)this.mAddLogTab);
        items.add((Object)this.mDeleteLogTabs);
        items.add((Object)new SeparatorMenuItem());
        items.add((Object)this.mConnect);
        items.add((Object)this.mDisconnect);
        items.add((Object)new SeparatorMenuItem());
        items.add((Object)this.mDUIDItem);
        items.add((Object)this.mOpenShellItem);
        items.add((Object)new SeparatorMenuItem());
        items.add((Object)this.mPermitToInstallItem);
        this.mAppInstall.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click install app to device");
                DeviceEventHandler.appInstallToDevice((DeviceItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.mAddLogTab.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click adds log tab menu");
                DeviceEventHandler.addLogTab((DeviceItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.mDeleteLogTabs.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click delete log tabs menu");
                DeviceEventHandler.deleteLogTabs((DeviceItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.mConnect.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click connect remote device menu");
                DeviceEventHandler.connectRemoteDevice((DeviceItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.mDisconnect.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click disconnect remote device menu");
                DeviceEventHandler.disConnectRemoteDevice((DeviceItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.mDUIDItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click DUID menu");
                DeviceEventHandler.showDUID((DeviceItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.mOpenShellItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click open shell menu");
                DeviceEventHandler.openShell((DeviceItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.mPermitToInstallItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click permit to install.");
                DeviceEventHandler.permitToInstall((DeviceItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.loadServiceMenus();
    }

    public void loadServiceMenus() {
        try {
            for (final IDeviceContextMenu menu : this.loader) {
                MenuItem menuItem = new MenuItem(menu.getLabel());
                menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        DeviceLogger.getLogger().fine("Click " + menu.getLabel() + " menu");
                        DeviceEventHandler.createExtensionUI(menu, (DeviceItem)DeviceTableRow.this.table.getSelectionModel().getSelectedItems().get(0));
                    }
                });
                List<MenuItem> menuItems = this.profileToMenuItems.get((Object)menu.getDeviceProfileType());
                if (menuItems == null) {
                    menuItems = new ArrayList<MenuItem>();
                    this.profileToMenuItems.put(menu.getDeviceProfileType(), menuItems);
                }
                menuItems.add(menuItem);
            }
        }
        catch (ServiceConfigurationError serviceError) {
            DeviceLogger.getLogger().log(Level.WARNING, serviceError.getMessage());
        }
    }

    void mouseEventHandler(MouseEvent event) {
        DeviceItem deviceItem = (DeviceItem)this.getItem();
        if (deviceItem == null) {
            return;
        }
        EventType type = event.getEventType();
        if (type == MouseEvent.MOUSE_CLICKED) {
            ObservableList selectedItem = this.table.getSelectionModel().getSelectedItems();
            if (selectedItem == null) {
                return;
            }
            if (event.getButton() == MouseButton.SECONDARY) {
                if (selectedItem.size() == 0) {
                    return;
                }
                this.addExtMenuItems((ObservableList<DeviceItem>)selectedItem);
                boolean disableLogTab = TableSelectionListener.getDisableLogTab().get();
                boolean disableConnect = TableSelectionListener.getDisableConnect().get();
                boolean disableDisconnect = TableSelectionListener.getDisableDisConnect().get();
                this.mAddLogTab.setDisable(disableLogTab);
                this.mDeleteLogTabs.setDisable(disableLogTab);
                this.mConnect.setDisable(disableConnect);
                this.mDisconnect.setDisable(disableDisconnect);
                this.mAppInstall.setDisable(disableLogTab);
                this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
            }
            return;
        }
        if (this.selectedProperty().get()) {
            return;
        }
        if (type == MouseEvent.MOUSE_ENTERED) {
            deviceItem.setRowState(ROW_STATE.OVER);
        } else {
            deviceItem.setRowState(ROW_STATE.NORMAL);
        }
    }

    private void addExtMenuItems(ObservableList<DeviceItem> selectedItem) {
        DeviceItem selected = (DeviceItem)selectedItem.get(0);
        String profileName = selected.getDeviceDescriptor().getProfileName();
        List<MenuItem> extMenus = this.profileToMenuItems.get((Object)DeviceProfileType.valueOf(profileName.toUpperCase()));
        if (extMenus != null) {
            ObservableList items = this.contextMenu.getItems();
            for (MenuItem menu : extMenus) {
                menu.setUserData(this.extMenuItemIdentifier);
                items.add(menu);
            }
        }
    }

    public static Callback<TableView<DeviceItem>, TableRow<DeviceItem>> extractor() {
        return new Callback<TableView<DeviceItem>, TableRow<DeviceItem>>(){

            public TableRow<DeviceItem> call(TableView<DeviceItem> table) {
                DeviceTableRow row = new DeviceTableRow(table);
                return row;
            }
        };
    }
}

