/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.control;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import org.tizen.device.manager.InstallDeviceInfo;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.control.SDBSyncProgressMonitor;
import org.tizen.device.manager.data.SettingsPageInfo;
import org.tizen.device.manager.file.explorer.FileEntryTreeData;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.ui.diaglog.ButtonType;
import org.tizen.device.manager.ui.diaglog.CheckReturn;
import org.tizen.device.manager.ui.diaglog.FileDialogUtils;
import org.tizen.device.manager.ui.diaglog.FileEntryPropertyDialog;
import org.tizen.device.manager.ui.diaglog.FilePushProgressDialog;
import org.tizen.device.manager.util.FilenameUtil;
import org.tizen.device.manager.util.IOUtil;
import org.tizen.device.manager.util.OSUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformInfo;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;

public final class SDBFileSyncController {
    private static final String ERROR_CODE_PATTERN = "^([1-9]|[1-9]\\d|1[0-1]\\d|12[0-7])";
    private static final String PATH_SEPARATOR = "/";
    private static boolean isProcessError = false;

    public static void pullFiles(final IDevice selectDevice, FileEntry[] fileEntry, final String localDirectory) {
        ArrayList<FileEntry> fileEntryList = new ArrayList<FileEntry>();
        for (FileEntry entry : fileEntry) {
            if (!FilenameUtil.isVaildName(entry.getName())) {
                String message = entry.getName() + "\n" + Messages.FileDialog_Pull_Invalid_Character + FilenameUtil.getInvalidCharacters();
                SDBFileSyncController.createPullMessageBox(message, null);
                continue;
            }
            fileEntryList.add(entry);
        }
        final FileEntry[] entryArray = fileEntryList.toArray(new FileEntry[fileEntryList.size()]);
        final FilePushProgressDialog monitor = new FilePushProgressDialog(Messages.FileDialog_Pull_Title, Messages.FileDialog_Pull_Init_Message);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SyncService sync = selectDevice.getSyncService();
                    if (sync != null) {
                        SyncResult result = sync.pull(entryArray, localDirectory, new SDBSyncProgressMonitor(monitor, Messages.FileDialog_Pull_Invalid_Character), SettingsPageInfo.getInstance().getConnectionTimeout());
                        if (!result.isOk()) {
                            SDBFileSyncController.createPullMessageBox(result.getMessage(), monitor);
                        } else {
                            SDBFileSyncController.createPullMessageBox(null, monitor);
                        }
                        sync.close();
                    }
                }
                catch (Exception e) {
                    SDBFileSyncController.createPullMessageBox(e.getMessage(), monitor);
                }
            }
        }).start();
    }

    public static String pushFiles(String[] fromFiles, final FileEntryTreeData toFileEntryData, final TreeView<FileEntryTreeData> treeView) {
        String resultMsg = null;
        if (toFileEntryData == null || toFileEntryData.getFileEntry() == null) {
            return resultMsg;
        }
        final FileEntry toFileEntry = toFileEntryData.getFileEntry();
        final IDevice toDevice = toFileEntry.getDevice();
        String[] paths = SDBFileSyncController.getFilesToOverwrite(fromFiles, toFileEntry);
        if (paths == null || paths.length == 0) {
            return resultMsg;
        }
        final File[] files = new File[paths.length];
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            files[i] = new File(paths[i]);
        }
        final FilePushProgressDialog monitor = new FilePushProgressDialog(Messages.FileDialog_Push_Title, Messages.FileDialog_Push_Init_Message);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SyncService sync = toDevice.getSyncService();
                    if (sync != null) {
                        SyncResult result = sync.push(files, toFileEntry, new SDBSyncProgressMonitor(monitor, Messages.FileDialog_Push_Init_Message), SettingsPageInfo.getInstance().getConnectionTimeout());
                        if (!result.isOk()) {
                            SDBFileSyncController.createPushMessageBox(result.getMessage(), monitor);
                        } else {
                            SDBFileSyncController.createPushMessageBox(null, monitor);
                        }
                        sync.close();
                    }
                    toFileEntryData.getFileEntry().getChildren();
                    ((TreeItem)treeView.getSelectionModel().getSelectedItem()).setValue(null);
                    ((TreeItem)treeView.getSelectionModel().getSelectedItem()).setValue((Object)toFileEntryData);
                }
                catch (Exception e) {
                    SDBFileSyncController.createPushMessageBox(e.getMessage(), monitor);
                }
            }
        }).start();
        return resultMsg;
    }

    private static void createPushMessageBox(final String message, final FilePushProgressDialog monitor) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (message != null) {
                    FileDialogUtils.pushFileErrorMessage(message);
                } else {
                    FileDialogUtils.successPopupMessage(Messages.FileDialog_Push_Success_Items);
                }
                if (monitor != null) {
                    monitor.getDialog().close();
                }
            }
        });
    }

    private static void createPullMessageBox(final String message, final FilePushProgressDialog monitor) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (message != null) {
                    FileDialogUtils.pullFileErrorMessage(message);
                } else {
                    FileDialogUtils.successPopupMessage(Messages.FileDialog_Pull_Success_Items);
                }
                if (monitor != null) {
                    monitor.getDialog().close();
                }
            }
        });
    }

    private static void createPermitMessageBox(final String message, final FilePushProgressDialog monitor) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (message != null) {
                    FileDialogUtils.permitErrorMessage(message);
                }
                if (monitor != null) {
                    monitor.getDialog().close();
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String[] getFilesToOverwrite(String[] src, FileEntry des) {
        FileEntry[] children = des.getChildren();
        ArrayList<String> listToOverwrite = new ArrayList<String>();
        boolean yesAll = false;
        String[] stringArray = src;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                String source;
                block9: {
                    ButtonType ret;
                    File f;
                    block10: {
                        source = stringArray[n2];
                        f = new File(source);
                        boolean bFind = false;
                        for (FileEntry entry : children) {
                            if (!entry.getName().equals(f.getName())) continue;
                            bFind = true;
                            break;
                        }
                        if (!bFind || yesAll) break block9;
                        if (src.length != 1) break block10;
                        ret = FileDialogUtils.allowFileOverwrite(f.getName());
                        if (ret == ButtonType.CANCEL) {
                            return listToOverwrite.toArray(new String[0]);
                        }
                        break block9;
                    }
                    ret = FileDialogUtils.checkOverwrite(f.getName());
                    switch (ret.getButtonData()) {
                        case CANCEL_CLOSE: {
                            return null;
                        }
                        case NO: {
                            break block11;
                        }
                        case YESTOALL: {
                            yesAll = true;
                            break;
                        }
                        case YES: 
                    }
                }
                listToOverwrite.add(source);
            }
            ++n2;
        }
        return listToOverwrite.toArray(new String[0]);
    }

    public static void addNewFile(FileEntryTreeData fileEntryTreeData, TreeView<FileEntryTreeData> treeView) {
        if (fileEntryTreeData == null) {
            return;
        }
        FileEntry fileEntry = fileEntryTreeData.getFileEntry();
        String name = SDBFileSyncController.getNameFromInputDialog(Messages.FileDialog_Add_New_File_Title, Messages.FileDialog_Add_New_File_Sub_Title, fileEntry, "");
        if (name == null) {
            return;
        }
        String fullPath = FilenameUtil.addDoubleQuote(fileEntry.getFullEscapedPath() + PATH_SEPARATOR + name);
        String command = String.format("touch %s; echo $?", fullPath);
        MultiLineReceiver receiver = new MultiLineReceiver(){

            @Override
            public void processNewLines(String[] lines) {
                SDBFileSyncController.sayError(lines, Messages.FileDialog_Add_New_File_Error_Message);
            }
        };
        IDevice currentDevice = fileEntry.getDevice();
        try {
            currentDevice.executeShellCommand(command, receiver);
        }
        catch (IOException e) {
            try {
                DeviceLogger.getLogger().log(Level.SEVERE, Messages.FileDialog_Add_New_File_Error_Message, e.getMessage());
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(receiver);
                throw throwable;
            }
        }
        IOUtil.tryClose(receiver);
        fileEntry.getChildren();
        ((TreeItem)treeView.getSelectionModel().getSelectedItem()).setValue(null);
        ((TreeItem)treeView.getSelectionModel().getSelectedItem()).setValue((Object)fileEntryTreeData);
    }

    private static void sayError(String[] lines, String message) {
        String lastLine = lines[lines.length - 1];
        if (!lastLine.equals("0")) {
            if (lines.length == 1 && lastLine.matches(ERROR_CODE_PATTERN)) {
                return;
            }
            FileDialogUtils.fileExplorerErrorMessage(message, lines[0]);
            isProcessError = true;
        } else {
            isProcessError = false;
        }
    }

    private static String getNameFromInputDialog(String title, String message, FileEntry entry, String initValue) {
        boolean again;
        CheckReturn resultReturn = null;
        do {
            again = false;
            resultReturn = FileDialogUtils.inputMessageBox(title, message, initValue);
            if (resultReturn == null || resultReturn.getButtonType() != ButtonType.OK) {
                return null;
            }
            String input = resultReturn.getMessage();
            if (!SDBFileSyncController.findDuplicateFileEntry(input, entry)) continue;
            again = true;
        } while (again);
        return FilenameUtil.getEscapedName(resultReturn.getMessage());
    }

    private static boolean findDuplicateFileEntry(String src, FileEntry des) {
        FileEntry[] children;
        for (FileEntry entry : children = des.getChildren()) {
            File f = new File(src);
            if (!entry.getName().equals(f.getName())) continue;
            FileDialogUtils.notifyDuplication(f.getName());
            return true;
        }
        return false;
    }

    public static void addNewFolder(FileEntryTreeData fileEntryTreeData, TreeView<FileEntryTreeData> treeView) {
        if (fileEntryTreeData == null) {
            return;
        }
        FileEntry fileEntry = fileEntryTreeData.getFileEntry();
        String name = SDBFileSyncController.getNameFromInputDialog(Messages.FileDialog_Add_New_Folder_Title, Messages.FileDialog_Add_New_Folder_Sub_Title, fileEntry, "");
        if (name == null) {
            return;
        }
        String fullPath = FilenameUtil.addDoubleQuote(fileEntry.getFullEscapedPath() + PATH_SEPARATOR + name);
        String command = String.format("mkdir %s; echo $?", fullPath);
        MultiLineReceiver receiver = new MultiLineReceiver(){

            @Override
            public void processNewLines(String[] lines) {
                SDBFileSyncController.sayError(lines, Messages.FileDialog_Add_New_Folder_Error_Message);
            }
        };
        IDevice currentDevice = fileEntry.getDevice();
        try {
            currentDevice.executeShellCommand(command, receiver);
        }
        catch (IOException e) {
            try {
                DeviceLogger.getLogger().log(Level.SEVERE, Messages.FileDialog_Add_New_Folder_Error_Message, e.getMessage());
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(receiver);
                throw throwable;
            }
        }
        IOUtil.tryClose(receiver);
        fileEntry.getChildren();
        ((TreeItem)treeView.getSelectionModel().getSelectedItem()).setValue(null);
        ((TreeItem)treeView.getSelectionModel().getSelectedItem()).setValue((Object)fileEntryTreeData);
    }

    public static void renameToFileAndFolder(FileEntryTreeData fileEntryTreeData, TreeView<FileEntryTreeData> treeView) {
        if (fileEntryTreeData == null) {
            return;
        }
        FileEntry fileEntry = fileEntryTreeData.getFileEntry();
        String name = SDBFileSyncController.getNameFromInputDialog(Messages.FileDialog_Rename_Title, Messages.FileDialog_Rename_Sub_Title, fileEntry, fileEntry.getName());
        if (name == null) {
            return;
        }
        String fullPath = fileEntry.getFullEscapedPath();
        int lastIndex = fullPath.lastIndexOf(PATH_SEPARATOR);
        String newPath = fullPath.substring(0, lastIndex) + PATH_SEPARATOR + name;
        String command = String.format("mv %s %s; echo $?", FilenameUtil.addDoubleQuote(fullPath), FilenameUtil.addDoubleQuote(newPath));
        MultiLineReceiver receiver = new MultiLineReceiver(){

            @Override
            public void processNewLines(String[] lines) {
                SDBFileSyncController.sayError(lines, Messages.FileDialog_Rename_Error_Message);
            }
        };
        IDevice currentDevice = fileEntry.getDevice();
        try {
            currentDevice.executeShellCommand(command, receiver);
        }
        catch (IOException e) {
            try {
                DeviceLogger.getLogger().log(Level.SEVERE, Messages.FileDialog_Rename_Error_Message, e.getMessage());
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(receiver);
                throw throwable;
            }
        }
        IOUtil.tryClose(receiver);
        FileEntryTreeData parentFileEntryTreeData = (FileEntryTreeData)((TreeItem)treeView.getSelectionModel().getSelectedItem()).getParent().getValue();
        FileEntry parentFileEntry = parentFileEntryTreeData.getFileEntry();
        parentFileEntry.getChildren();
        ((TreeItem)treeView.getSelectionModel().getSelectedItem()).getParent().setValue(null);
        ((TreeItem)treeView.getSelectionModel().getSelectedItem()).getParent().setValue((Object)parentFileEntryTreeData);
    }

    public static void deleteToFileAndFolder(List<TreeItem<FileEntryTreeData>> deleteSelectTreeItems, TreeView<FileEntryTreeData> treeView) {
        if (deleteSelectTreeItems == null || deleteSelectTreeItems.size() < 0) {
            return;
        }
        String deleteParentDataName = null;
        for (TreeItem<FileEntryTreeData> selectTreeData : deleteSelectTreeItems) {
            ButtonType ret;
            FileEntry deleteFileEntry = ((FileEntryTreeData)selectTreeData.getValue()).getFileEntry();
            if (deleteParentDataName != null && ((FileEntryTreeData)selectTreeData.getParent().getValue()).getFileName().equalsIgnoreCase(deleteParentDataName) || (ret = FileDialogUtils.allowDeleteToFileAndFolder(deleteFileEntry.getName())) == ButtonType.CANCEL) continue;
            String command = null;
            command = deleteFileEntry.isDirectory() ? String.format("rm -rf %s; echo $?", FilenameUtil.addDoubleQuote(deleteFileEntry.getFullEscapedPath())) : String.format("rm -f %s; echo $?", FilenameUtil.addDoubleQuote(deleteFileEntry.getFullEscapedPath()));
            MultiLineReceiver receiver = new MultiLineReceiver(){

                @Override
                public void processNewLines(String[] lines) {
                    SDBFileSyncController.sayError(lines, Messages.FileDialog_Delete_Error_Message);
                }
            };
            IDevice currentDevice = deleteFileEntry.getDevice();
            try {
                currentDevice.executeShellCommand(command, receiver);
            }
            catch (IOException e) {
                try {
                    DeviceLogger.getLogger().log(Level.SEVERE, Messages.FileDialog_Delete_Error_Message, e.getMessage());
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose(receiver);
                    throw throwable;
                }
            }
            IOUtil.tryClose(receiver);
            if (!isProcessError) {
                selectTreeData.getParent().getChildren().remove(selectTreeData);
                continue;
            }
            deleteParentDataName = ((FileEntryTreeData)selectTreeData.getValue()).getFileName();
            FileEntryTreeData parentFileEntryTreeData = (FileEntryTreeData)selectTreeData.getValue();
            FileEntry parentFileEntry = parentFileEntryTreeData.getFileEntry();
            parentFileEntry.getChildren();
            ((TreeItem)treeView.getSelectionModel().getSelectedItem()).setValue(null);
            ((TreeItem)treeView.getSelectionModel().getSelectedItem()).setValue((Object)parentFileEntryTreeData);
        }
    }

    public static void refreshToFileAndFolder(FileEntryTreeData fileEntryTreeData, TreeView<FileEntryTreeData> treeView) {
        if (fileEntryTreeData == null) {
            return;
        }
        FileEntry fileEntry = fileEntryTreeData.getFileEntry();
        fileEntry.getChildren();
        ((TreeItem)treeView.getSelectionModel().getSelectedItem()).setValue(null);
        ((TreeItem)treeView.getSelectionModel().getSelectedItem()).setValue((Object)fileEntryTreeData);
    }

    public static void openShellToDevice(IDevice selectDevice) {
        DeviceLogger.getLogger().log(Level.INFO, "open the shell");
        String termPath = InstallDeviceInfo.getTerminalDefaultPath();
        String sdbPath = InstallDeviceInfo.getSdbPath();
        String serial = selectDevice.getSerialNumber();
        try {
            ProcessBuilder procSdb = new ProcessBuilder(new String[0]);
            ArrayList<String> cmdList = new ArrayList<String>();
            File sdbFile = new File(sdbPath);
            if (OSUtil.isMac()) {
                PlatformInfo platformInfo = selectDevice.getPlatformInfo();
                String platformPath = InstallDeviceInfo.getOpenShellScriptForMacPath(platformInfo.getProfileName(), platformInfo.getPlatformVersion());
                if (platformPath == null) {
                    throw new Exception(Messages.FileDialog_Open_Shell_MAC_SdbScript_Not_Install_Error_Message);
                }
                termPath = platformPath;
                cmdList.add(termPath);
                cmdList.add(sdbPath);
                cmdList.add(serial);
            } else {
                cmdList.addAll(Arrays.asList(termPath.split("\\s+")));
                if (OSUtil.isLinux()) {
                    cmdList.add(sdbFile.getAbsolutePath());
                } else {
                    procSdb.directory(sdbFile.getParentFile());
                    cmdList.add(sdbFile.getName());
                }
                cmdList.add("-s");
                cmdList.add(serial);
                cmdList.add("shell");
            }
            DeviceLogger.getLogger().log(Level.INFO, ((Object)cmdList).toString());
            procSdb.command(cmdList);
            procSdb.start();
        }
        catch (Exception e) {
            DeviceLogger.getLogger().log(Level.SEVERE, e.getMessage(), e);
            FileDialogUtils.openShellErrorMessage(e.getMessage());
        }
    }

    public static void showPropertyToFileEntry(FileEntryTreeData fileEntryTreeData, TreeView<FileEntryTreeData> treeView) {
        if (fileEntryTreeData == null) {
            return;
        }
        FileEntryPropertyDialog dialog = new FileEntryPropertyDialog(fileEntryTreeData.getFileEntry());
        dialog.showAndWait();
    }

    public static String permitToInstall(String[] fromFiles, FileEntryTreeData toFileEntryData, TreeView<FileEntryTreeData> treeView) {
        String resultMsg = null;
        if (toFileEntryData == null || toFileEntryData.getFileEntry() == null) {
            return resultMsg;
        }
        final FileEntry toFileEntry = toFileEntryData.getFileEntry();
        final IDevice toDevice = toFileEntry.getDevice();
        if (fromFiles == null || fromFiles.length == 0) {
            return resultMsg;
        }
        final File[] files = new File[fromFiles.length];
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            files[i] = new File(fromFiles[i]);
        }
        final FilePushProgressDialog monitor = new FilePushProgressDialog(Messages.FileDialog_Push_Title, Messages.FileDialog_Push_Init_Message);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SyncService sync = toDevice.getSyncService();
                    if (sync != null) {
                        SyncResult result = sync.push(files, toFileEntry, new SDBSyncProgressMonitor(monitor, Messages.FileDialog_Push_Init_Message), SettingsPageInfo.getInstance().getConnectionTimeout());
                        if (!result.isOk()) {
                            SDBFileSyncController.createPermitMessageBox(result.getMessage(), monitor);
                        } else {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    FileDialogUtils.permitToInstallSuccessMessage(Messages.FileDialog_Permit_To_Install_Success_Message);
                                }
                            });
                        }
                        sync.close();
                    }
                }
                catch (Exception e) {
                    SDBFileSyncController.createPermitMessageBox(e.getMessage(), monitor);
                }
            }
        }).start();
        return resultMsg;
    }
}

