/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final String NULL_STRING = "<<null>>";
    public static final String EMPTY_BYTES_STRING = "<<EMPTY BYTES>>";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String TAB = "\t";
    protected static char CONTROL_CHARS_SHOWER = (char)46;
    protected static final char[] HEXA_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static final int N_INT_BY_BYTE = 4;
    protected static final int WIDTH_PER_LINE = 16;
    protected static char TWO_BYTES_CHARS_SHOWER = (char)63;
    public static String ISO_8859_1 = "ISO-8859-1";

    public static InputStream toInputStream(String src) {
        if (null == src) {
            return null;
        }
        return new ByteArrayInputStream(src.getBytes());
    }

    public static String[] split(String str, String delimiters) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, delimiters);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[0]);
    }

    public static String asString(Reader reader) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = reader.read()) != -1) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String asString(InputStream is) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = is.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String removeStart(String str, String remove) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static void appendHexa(StringBuilder buffer, int ch) {
        if (ch < 16) {
            buffer.append('0');
            buffer.append(HEXA_CHARS[0xF & ch]);
        } else {
            buffer.append(HEXA_CHARS[0xF & ch >> 4]);
            buffer.append(HEXA_CHARS[0xF & ch]);
        }
    }

    protected static void lineEnd(StringBuilder hexPart, StringBuilder textPart, StringBuilder ret) {
        hexPart.append("     |");
        textPart.append("|\n");
        ret.append((CharSequence)hexPart);
        ret.append((CharSequence)textPart);
        hexPart.delete(0, hexPart.capacity());
        textPart.delete(0, textPart.capacity());
    }

    public static String text2hexa(byte[] data) {
        if (null == data) {
            return NULL_STRING;
        }
        return StringUtil.text2hexa(data, 0, data.length);
    }

    public static String text2hexa(byte[] data, int offset, int length) {
        int i;
        if (null == data) {
            return NULL_STRING;
        }
        if (data.length <= 0) {
            return EMPTY_BYTES_STRING;
        }
        ByteArrayInputStream reader = new ByteArrayInputStream(data, offset, length);
        StringBuilder ret = new StringBuilder();
        StringBuilder hexPart = new StringBuilder();
        StringBuilder textPart = new StringBuilder();
        int address = 0;
        int ch = -1;
        int printByte = 0;
        int cnt = 0;
        hexPart.append("          ");
        int n = 4;
        for (i = 0; i < n; ++i) {
            hexPart.append("+-------");
            textPart.append("+---");
        }
        StringUtil.lineEnd(hexPart, textPart, ret);
        while (0 <= (ch = reader.read())) {
            if (0 == cnt) {
                for (i = 3; i >= 0; --i) {
                    printByte = 0xFF & address >> 8 * i;
                    StringUtil.appendHexa(hexPart, printByte);
                }
                hexPart.append("  ");
                address += 16;
            }
            StringUtil.appendHexa(hexPart, ch);
            if ((ch & 0x80) != 0 || ch < 32) {
                textPart.append(CONTROL_CHARS_SHOWER);
            } else {
                textPart.append((char)ch);
            }
            if (16 != ++cnt) continue;
            StringUtil.lineEnd(hexPart, textPart, ret);
            cnt = 0;
        }
        if (0 != cnt) {
            while (cnt < 16) {
                hexPart.append("  ");
                textPart.append(' ');
                ++cnt;
            }
            StringUtil.lineEnd(hexPart, textPart, ret);
        }
        return ret.toString();
    }

    public static boolean isEmpty(CharSequence str) {
        if (null == str) {
            return true;
        }
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int size(CharSequence str) {
        if (null == str) {
            return 0;
        }
        return str.length();
    }

    public static boolean hasLength(CharSequence str) {
        return 0 < StringUtil.size(str);
    }

    public static boolean hasText(CharSequence str) {
        return !StringUtil.isEmpty(str);
    }

    public static String trimLeading(String str) {
        if (!StringUtil.hasLength(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        int n = chs.length;
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(chs[i])) continue;
            return new String(chs, i, str.length() - i);
        }
        return EMPTY_STRING;
    }

    public static String trimTrailing(String str) {
        if (!StringUtil.hasLength(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        int i = chs.length - 1;
        for (int j = chs.length; 0 < j; --j) {
            if (!Character.isWhitespace(chs[i])) {
                return new String(chs, 0, j);
            }
            --i;
        }
        return EMPTY_STRING;
    }

    public static String trim(String str) {
        return StringUtil.trimTrailing(StringUtil.trimLeading(str));
    }

    public static String getMeaningful(String str) {
        if (null == str) {
            return EMPTY_STRING;
        }
        return StringUtil.trim(str).toLowerCase();
    }

    public static String mask(String str, String maskingStr) {
        if (null == str) {
            return "null";
        }
        StringBuilder buffer = new StringBuilder();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            buffer.append(maskingStr);
        }
        return buffer.toString();
    }

    public static String getParamater(String str, char delimeter, int escaper, int targetIndex) throws IOException {
        try {
            if (null == str) {
                return null;
            }
            StringReader reader = new StringReader(str);
            StringWriter writer = null;
            int ch = 0;
            boolean ST_NORMAL = false;
            boolean ST_ESCAPE = true;
            boolean status = false;
            int index = 0;
            if (0 == targetIndex) {
                writer = new StringWriter();
            }
            while (0 <= (ch = reader.read())) {
                if (status) {
                    status = false;
                } else {
                    if (escaper == ch) {
                        status = true;
                        continue;
                    }
                    if (delimeter == ch) {
                        if (index == targetIndex && writer != null) {
                            return writer.toString();
                        }
                        if (++index != targetIndex) continue;
                        writer = new StringWriter();
                        continue;
                    }
                }
                if (null == writer) continue;
                writer.write(ch);
            }
            if (index == targetIndex && writer != null) {
                return writer.toString();
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String lastSubstring(String str, int indexFromLast) {
        if (null == str) {
            return null;
        }
        int length = str.length();
        if (length < indexFromLast) {
            return str;
        }
        return str.substring(length - indexFromLast);
    }

    public static String getLastSegment(String str, String separator) {
        if (null == str) {
            return EMPTY_STRING;
        }
        int index = str.lastIndexOf(separator);
        if (index < 0) {
            return str;
        }
        return str.substring(index + separator.length());
    }

    public static String removeLastSegment(String str, String separator) {
        if (null == str) {
            return EMPTY_STRING;
        }
        int index = str.lastIndexOf(separator);
        if (index < 0) {
            return EMPTY_STRING;
        }
        return str.substring(0, index);
    }

    public static String multiply(String symbol, int n) {
        if (null == symbol) {
            return EMPTY_STRING;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            buffer.append(symbol);
        }
        return buffer.toString();
    }

    public static boolean containsWhitespace(CharSequence str) {
        int nChar = StringUtil.size(str);
        for (int i = 0; i < nChar; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (!StringUtil.hasLength(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        int n = chs.length;
        for (int i = 0; i < n; ++i) {
            if (leadingCharacter == chs[i]) continue;
            return new String(chs, i, str.length() - i);
        }
        return EMPTY_STRING;
    }

    public static String trimTrailingCharacter(String str, char trailingCharacter) {
        if (!StringUtil.hasLength(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        int i = chs.length - 1;
        for (int j = chs.length; 0 < j; --j) {
            if (trailingCharacter != chs[i]) {
                return new String(chs, 0, j);
            }
            --i;
        }
        return EMPTY_STRING;
    }

    public static String trimCharacter(String str, char character) {
        return StringUtil.trimTrailingCharacter(StringUtil.trimLeadingCharacter(str, character), character);
    }

    public static String getWord(String doc, int index) {
        char ch;
        char ch2;
        int i;
        StringBuilder buffer = new StringBuilder();
        int position = index;
        if (doc.length() < index) {
            return EMPTY_STRING;
        }
        for (i = position - 1; 0 <= i && !Character.isWhitespace((int)(ch2 = doc.charAt(i))); --i) {
            buffer.append(ch2);
        }
        buffer.reverse();
        int n = doc.length();
        for (i = position; i < n && !Character.isWhitespace((int)(ch = doc.charAt(i))); ++i) {
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String getPreviousWord(String doc, int index) {
        StringBuilder buffer = new StringBuilder();
        if (index < 0 || doc.length() < index) {
            return EMPTY_STRING;
        }
        char ch = '\u0000';
        boolean bNeedWord = false;
        if (index < doc.length()) {
            ch = doc.charAt(index);
            bNeedWord = Character.isWhitespace((int)ch);
        }
        for (int i = index - 1; 0 <= i; --i) {
            ch = doc.charAt(i);
            if (Character.isWhitespace((int)ch)) {
                if (!bNeedWord) break;
                continue;
            }
            bNeedWord = false;
            buffer.append(ch);
        }
        return buffer.reverse().toString();
    }

    public static <T extends Enum<T>> String[] enumNameToStringArray(T[] values) {
        int i = 0;
        String[] result = new String[values.length];
        for (T value : values) {
            result[i++] = ((Enum)value).name();
        }
        return result;
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String convertFirstLetterUpperCase(String str) {
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        char[] str_array = str.toCharArray();
        str_array[0] = Character.toUpperCase(str_array[0]);
        str = new String(str_array);
        return str;
    }

    public static String getLastStringAfter(String input, String lastIndexStr) {
        if (input == null) {
            return null;
        }
        int k = input.lastIndexOf(lastIndexStr);
        return k != -1 ? input.substring(k + 1, input.length()) : null;
    }

    public static String[] splitByCamelCase(String str) {
        if (StringUtil.isEmpty(str)) {
            return new String[0];
        }
        char[] c = str.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        int tokenStart = 0;
        int currentType = Character.getType(c[tokenStart]);
        for (int pos = tokenStart + 1; pos < c.length; ++pos) {
            int type = Character.getType(c[pos]);
            if (type == currentType) continue;
            if (type == 2 && currentType == 1) {
                int newTokenStart = pos - 1;
                if (newTokenStart != tokenStart) {
                    list.add(new String(c, tokenStart, newTokenStart - tokenStart));
                    tokenStart = newTokenStart;
                }
            } else {
                list.add(new String(c, tokenStart, pos - tokenStart));
                tokenStart = pos;
            }
            currentType = type;
        }
        list.add(new String(c, tokenStart, c.length - tokenStart));
        return list.toArray(new String[0]);
    }

    private static int minimum(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static int getLevenshteinDistance(CharSequence str1, CharSequence str2) {
        int i;
        int[][] distance = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            distance[i][0] = i;
        }
        for (int j = 1; j <= str2.length(); ++j) {
            distance[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                distance[i][j] = StringUtil.minimum(distance[i - 1][j] + 1, distance[i][j - 1] + 1, distance[i - 1][j - 1] + (str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1));
            }
        }
        return distance[str1.length()][str2.length()];
    }

    public static String[] split(String str, Pattern pattern) {
        ArrayList<String> result = null;
        Matcher matcher = pattern.matcher(str);
        if (matcher.matches()) {
            result = new ArrayList<String>();
            for (int i = 0; i < matcher.groupCount(); ++i) {
                result.add(matcher.group(i + 1));
            }
        }
        return result == null ? null : result.toArray(new String[0]);
    }

    public static String convertToDefaultCharset(String text, String charset) throws UnsupportedEncodingException {
        byte[] bytes = text.getBytes(charset);
        String defaultCharset = Charset.defaultCharset().name();
        return new String(bytes, defaultCharset);
    }
}

