/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.model;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.TreeItem;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.control.FilePushPullController;
import org.tizen.device.manager.control.SDBAppLaunchCommand;
import org.tizen.device.manager.control.SDBFileSyncController;
import org.tizen.device.manager.controller.RemoteDeviceConnectController;
import org.tizen.device.manager.controller.TaskCompletionListener;
import org.tizen.device.manager.data.DeviceDescriptor;
import org.tizen.device.manager.data.DeviceStateType;
import org.tizen.device.manager.extension.IDeviceContextMenu;
import org.tizen.device.manager.file.explorer.FileEntryTreeData;
import org.tizen.device.manager.file.explorer.FileEntryTreeItemWorker;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.logview.controller.FXMLLogViewController;
import org.tizen.device.manager.logview.view.CustomLogTabDialog;
import org.tizen.device.manager.model.DeviceItem;
import org.tizen.device.manager.resources.SimpleExecutor;
import org.tizen.device.manager.ui.diaglog.ButtonType;
import org.tizen.device.manager.ui.diaglog.FileDialogUtils;
import org.tizen.device.manager.ui.diaglog.MessageBox;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;

public class DeviceEventHandler {
    private static SimpleBooleanProperty isVisible = new SimpleBooleanProperty(false);
    private static TaskCompletionListener<String> completionListener = new TaskCompletionListener<String>(){

        @Override
        public void completed(final String result) {
            DeviceLogger.getLogger().fine("Stop progress indicator");
            if (!result.isEmpty()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MessageBox.error("Error", result);
                    }
                });
            }
            DeviceEventHandler.setProgress(false);
        }
    };

    public static SimpleBooleanProperty getIsVisible() {
        return isVisible;
    }

    private static void setProgress(boolean visible) {
        isVisible.set(visible);
    }

    public static void createFileExplorer(DeviceItem item, final TreeItem<FileEntryTreeData> treeRoot) {
        assert (item != null);
        DeviceLogger.getLogger().fine("Start progress indicator for file explorer view: " + item.getName());
        DeviceEventHandler.setProgress(true);
        SimpleExecutor.asynExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                new FileEntryTreeItemWorker().create((TreeItem<FileEntryTreeData>)treeRoot);
                return "";
            }
        }, completionListener);
    }

    public static void appInstallToDevice(final DeviceItem deviceItem) {
        if (deviceItem == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for install app to device: ");
        final File selectFile = FilePushPullController.getInstallAppPath();
        if (selectFile == null) {
            return;
        }
        DeviceEventHandler.setProgress(true);
        SimpleExecutor.asynExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return SDBAppLaunchCommand.installApp(deviceItem.getDeviceDescriptor().getIDevice(), selectFile);
            }
        }, completionListener);
    }

    public static void addLogTab(final DeviceItem deviceItem) {
        if (deviceItem == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for add log tab: " + deviceItem.getName());
        DeviceEventHandler.setProgress(true);
        SimpleExecutor.asynExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FXMLLogViewController logViewController = FXMLLogViewController.getInstance();
                        if (logViewController != null) {
                            DeviceDescriptor selectedDevice = deviceItem.getDeviceDescriptor();
                            CustomLogTabDialog customDialog = new CustomLogTabDialog(selectedDevice);
                            try {
                                String tabname = (String)customDialog.showAndWait();
                                if (tabname != null) {
                                    logViewController.createNewLogTab(selectedDevice, tabname);
                                }
                            }
                            catch (Exception e) {
                                DeviceLogger.getLogger().log(Level.WARNING, e.getMessage());
                            }
                        }
                    }
                });
                return "";
            }
        }, completionListener);
    }

    public static void deleteLogTabs(final DeviceItem deviceItem) {
        if (deviceItem == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for delete log tabs: " + deviceItem.getName());
        DeviceEventHandler.setProgress(true);
        SimpleExecutor.asynExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FXMLLogViewController logViewController = FXMLLogViewController.getInstance();
                        if (logViewController != null) {
                            DeviceDescriptor selectedDevice = deviceItem.getDeviceDescriptor();
                            if (logViewController.hasLogTabs(selectedDevice)) {
                                ButtonType ret = FileDialogUtils.allowDeleteAllLogTabs(deviceItem.getDisplayDeviceName());
                                if (ret == null || ret == ButtonType.CANCEL) {
                                    return;
                                }
                                logViewController.removeLogTabs(selectedDevice);
                            } else {
                                FileDialogUtils.impossibleDeleteAllLogTabs(deviceItem.getDisplayDeviceName());
                            }
                        }
                    }
                });
                return "";
            }
        }, completionListener);
    }

    public static void connectRemoteDevice(final DeviceItem deviceItem) {
        if (deviceItem == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for connect the remote device: " + deviceItem.getName());
        DeviceEventHandler.setProgress(true);
        SimpleExecutor.asynExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                deviceItem.connectProperty().setValue(DeviceStateType.ONLINE.name());
                RemoteDeviceConnectController.tryToConnectDevice(deviceItem);
                return "";
            }
        }, completionListener);
    }

    public static void disConnectRemoteDevice(final DeviceItem deviceItem) {
        if (deviceItem == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for disconnect the remote device: " + deviceItem.getName());
        DeviceEventHandler.setProgress(true);
        SimpleExecutor.asynExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                deviceItem.connectProperty().setValue(DeviceStateType.ONLINE.name());
                RemoteDeviceConnectController.tryToDisConnectDevice(deviceItem);
                return "";
            }
        }, completionListener);
    }

    public static void showDUID(DeviceItem deviceItem) {
        if (deviceItem == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for show property: " + deviceItem.getName());
        try {
            String duid = deviceItem.getDeviceDescriptor().getIDevice().getDUID();
            MessageBox.copyToClipboardAlert(Messages.DEVICE_TABLE_CONTEXT_MENU_LABEL_DUID, deviceItem.getName(), duid);
        }
        catch (TimeoutException e) {
            DeviceLogger.getLogger().log(Level.WARNING, e.getMessage());
        }
        catch (SdbCommandRejectedException e) {
            DeviceLogger.getLogger().log(Level.WARNING, e.getMessage());
        }
        catch (IOException e) {
            DeviceLogger.getLogger().log(Level.WARNING, e.getMessage());
        }
    }

    public static void openShell(DeviceItem deviceItem) {
        if (deviceItem == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for open shell: " + deviceItem.getName());
        SDBFileSyncController.openShellToDevice(deviceItem.getDeviceDescriptor().getIDevice());
    }

    public static void permitToInstall(DeviceItem deviceItem) {
        if (deviceItem == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for permit to install: " + deviceItem.getName());
        FilePushPullController.pushToDeviceProfile(new FileEntryTreeData(deviceItem.getDeviceDescriptor()), null, deviceItem);
    }

    public static void createExtensionUI(final IDeviceContextMenu menu, final DeviceItem deviceItem) {
        if (deviceItem == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress createExtensionUI");
        DeviceEventHandler.setProgress(true);
        SimpleExecutor.asynExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        menu.run(deviceItem.getDeviceDescriptor().getIDevice());
                    }
                });
                return "";
            }
        }, completionListener);
    }
}

