/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.logging;

import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.tizen.device.manager.StringResources;

class LoggerFormatter
extends Formatter {
    LoggerFormatter() {
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(record.getMillis());
        sb.append('[');
        sb.append(cal.get(1));
        sb.append('.');
        sb.append(cal.get(2) + 1);
        sb.append('.');
        sb.append(cal.get(5));
        sb.append(' ');
        sb.append(cal.get(11));
        sb.append(':');
        sb.append(cal.get(12));
        sb.append(':');
        sb.append(cal.get(13));
        sb.append('.');
        sb.append(cal.get(14));
        sb.append(']');
        sb.append('[');
        sb.append(record.getLevel());
        sb.append(']');
        sb.append('[');
        sb.append(record.getSourceClassName().substring(record.getSourceClassName().lastIndexOf(".") + 1));
        sb.append('.');
        sb.append(record.getSourceMethodName());
        sb.append("] ");
        sb.append(record.getMessage());
        Throwable t = record.getThrown();
        if (t != null) {
            StackTraceElement[] stacks = t.getStackTrace();
            sb.append(StringResources.NEW_LINE);
            sb.append(t.toString());
            for (int i = 0; i < stacks.length; ++i) {
                sb.append(StringResources.NEW_LINE);
                sb.append(stacks[i].toString());
            }
        }
        sb.append(StringResources.NEW_LINE);
        return sb.toString();
    }
}

