/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager;

import java.util.logging.Level;
import org.tizen.device.manager.InstallDeviceInfo;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.util.HostUtil;
import org.tizen.sdblib.SmartDevelopmentBridge;

public final class SDBConnectionService {
    public static void initializeSmartDeviceBridge() {
        String sdbPath = InstallDeviceInfo.getSdbPath();
        if (!HostUtil.exists(sdbPath)) {
            DeviceLogger.log(String.format("There is no %s.", sdbPath));
        } else {
            SmartDevelopmentBridge.createBridge((String)sdbPath);
        }
    }

    public static void startSDBProcess() {
        new Thread("Start SmartDevelopmentBridge"){

            @Override
            public void run() {
                SDBConnectionService.startSmartDevelopmentBridge();
            }
        }.start();
    }

    private static void startSmartDevelopmentBridge() {
        SmartDevelopmentBridge bridge = SmartDevelopmentBridge.getBridge();
        if (bridge != null) {
            bridge.startBridge();
            try {
                bridge.waitforStart(5000L);
                if (!bridge.getStarted()) {
                    DeviceLogger.getLogger().log(Level.SEVERE, "Failed to start sdb");
                    bridge.stopBridge();
                }
                String sdbLogPath = InstallDeviceInfo.getDeviceLogPath();
                bridge.setSdbLogLocation(sdbLogPath);
            }
            catch (Throwable t) {
                DeviceLogger.getLogger().log(Level.SEVERE, "Failed to start sdb");
            }
        }
    }
}

