/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.logview.data;

import java.util.ArrayList;
import org.tizen.device.manager.logview.data.Log;

public class LogMatcher {
    private ArrayList<String> logLevels;
    private ArrayList<String> pids;
    private ArrayList<String> tids;
    private ArrayList<String> tags;
    private ArrayList<String> messages;

    public LogMatcher() {
        this.logLevels = new ArrayList();
        this.pids = new ArrayList();
        this.tids = new ArrayList();
        this.tags = new ArrayList();
        this.messages = new ArrayList();
    }

    public LogMatcher(ArrayList<String> logLevels, ArrayList<String> pids, ArrayList<String> tids, ArrayList<String> tags, ArrayList<String> messages) {
        this.logLevels = logLevels;
        this.pids = pids;
        this.tids = tids;
        this.tags = tags;
        this.messages = messages;
    }

    public ArrayList<String> getLogLevel() {
        return this.logLevels;
    }

    public ArrayList<String> getPids() {
        return this.pids;
    }

    public ArrayList<String> getTids() {
        return this.tids;
    }

    public ArrayList<String> getTags() {
        return this.tags;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    public void setLogLevels(ArrayList<String> logLevels) {
        this.logLevels = logLevels;
    }

    public void setPids(ArrayList<String> pids) {
        this.pids = pids;
    }

    public void setTids(ArrayList<String> tids) {
        this.tids = tids;
    }

    public void setTags(ArrayList<String> tags) {
        this.tags = tags;
    }

    public void setMessages(ArrayList<String> messages) {
        this.messages = messages;
    }

    public boolean isEmptyMatcher() {
        return this.logLevels.isEmpty() && this.pids.isEmpty() && this.tids.isEmpty() && this.tags.isEmpty() && this.messages.isEmpty();
    }

    public boolean isMatched(Log log) {
        if (!this.logLevels.isEmpty() && !this.logLevels.contains(log.getLevelName())) {
            return false;
        }
        if (!this.pids.isEmpty() && !this.pids.contains(log.getPid())) {
            return false;
        }
        if (!this.tids.isEmpty() && !this.tids.contains(log.getTid())) {
            return false;
        }
        if (!this.tags.isEmpty() && !this.tags.contains(log.getTag())) {
            return false;
        }
        return this.messages.isEmpty() || log.getMessage().contains(this.messages.get(0));
    }
}

