/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Level;
import org.tizen.device.manager.InternalFindSDKPath;
import org.tizen.device.manager.exception.InitializationException;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.util.OSUtil;
import org.tizen.library.sdkutils.api.ISDKPackage;
import org.tizen.library.sdkutils.api.impl.SDKUtils;

public final class InstallDeviceInfo {
    private static String sdkPath;
    private static String sdkDataPath;
    private static String sdbPath;
    private static String toolDevicePath;
    private static String toolDeviceDataPath;
    private static String toolDeviceBinPath;
    private static String toolEmulatorPath;
    private static String toolEmulatorBinPath;
    private static String toolCertificatePath;
    private static final String TOOLS_SUFFIX;
    private static final String BIN_SUFFIX;
    private static final String DEVICE_SUFFIX;
    private static final String EMULATOR_SUFFIX;
    private static final String CERTIFICATE_SUFFIX;
    private static final String SDB_SUFFIX;
    private static final String EMULATOR_MANAGER_SUFFIX;
    private static final String CERTFICATE_MANAGER_SUFFIX;
    private static final String DIR_LOG = "logs";
    private static final String DIR_CONFIG = "config";
    private static final String DEVICE_MANAGER_LOG = "device-manager.log";
    private static final String DEVICE_MANAGER_SETTINGS = ".settings";
    private static final String DEVICE_REMOTE_DEVICE_FILE = "remote_device_scan.list";
    private static boolean isInitialized;
    private static final String OPEN_SHELL_SCRIPT_PATH_MAC = "/emulator/bin/sdbscript";
    private static final String DIR_PLATFORM_COMMON = "common";

    private static void checkInitialize() throws InitializationException {
        if (!isInitialized) {
            throw new InitializationException();
        }
    }

    public static void initialize() throws IllegalStateException, IOException {
        if (isInitialized) {
            throw new IllegalStateException("Failed to initalize file path resources.Cause already initilized.");
        }
        Path infoFile = null;
        if (System.getProperty("develop") != null) {
            infoFile = System.getProperty("path") != null ? Paths.get(System.getProperty("path") + File.separator + "sdk.info", new String[0]) : Paths.get(System.getProperty("user.home") + File.separator + "tizen-studio" + File.separator + "sdk.info", new String[0]);
        }
        InstallDeviceInfo.initialize(infoFile != null ? infoFile.getParent().toString() : null);
    }

    public static void initialize(String dir) throws IllegalStateException, IOException {
        if (isInitialized) {
            throw new IllegalStateException("Failed to initalize file path resources.Cause already initilized.");
        }
        InternalFindSDKPath finder = new InternalFindSDKPath();
        finder.findSDKPath(dir);
        sdkDataPath = finder.getSDKDataPath();
        sdkPath = finder.getSDKPath();
        InstallDeviceInfo.intenalInitialize();
    }

    private static void intenalInitialize() {
        try {
            toolDevicePath = new File(sdkPath + TOOLS_SUFFIX + DEVICE_SUFFIX).getCanonicalPath();
            toolEmulatorPath = new File(sdkPath + TOOLS_SUFFIX + EMULATOR_SUFFIX).getCanonicalPath();
            toolCertificatePath = new File(sdkPath + TOOLS_SUFFIX + CERTIFICATE_SUFFIX).getCanonicalPath();
        }
        catch (IOException e) {
            toolDevicePath = sdkPath + TOOLS_SUFFIX + DEVICE_SUFFIX;
            toolEmulatorPath = sdkPath + TOOLS_SUFFIX + EMULATOR_SUFFIX;
            toolCertificatePath = sdkPath + TOOLS_SUFFIX + CERTIFICATE_SUFFIX;
        }
        sdbPath = sdkPath + TOOLS_SUFFIX + SDB_SUFFIX;
        toolDeviceBinPath = toolDevicePath + BIN_SUFFIX;
        toolDeviceDataPath = sdkDataPath + DEVICE_SUFFIX;
        toolEmulatorBinPath = toolEmulatorPath + BIN_SUFFIX;
        InstallDeviceInfo.printSDKPathToLogFile();
        isInitialized = true;
    }

    private static void printSDKPathToLogFile() {
        DeviceLogger.log("Tizen SDK path: " + sdkPath);
        DeviceLogger.log("Tizen SDK data path: " + sdkDataPath);
    }

    public static String getTizenSDKPath() {
        InstallDeviceInfo.checkInitialize();
        return sdkPath;
    }

    public static String getTizenSDKDataPath() {
        InstallDeviceInfo.checkInitialize();
        return sdkDataPath;
    }

    public static String getDeviceDataPath() {
        InstallDeviceInfo.checkInitialize();
        return toolDeviceDataPath;
    }

    public static String getSdbPath() {
        InstallDeviceInfo.checkInitialize();
        return sdbPath;
    }

    public static String getDeviceLogFilePath() {
        InstallDeviceInfo.checkInitialize();
        return InstallDeviceInfo.getDeviceLogPath() + File.separator + DEVICE_MANAGER_LOG;
    }

    public static String getDeviceLogPath() {
        InstallDeviceInfo.checkInitialize();
        return InstallDeviceInfo.getDeviceDataPath() + File.separator + DIR_LOG;
    }

    public static String getToolDeviceBinPath() {
        InstallDeviceInfo.checkInitialize();
        return toolDeviceBinPath;
    }

    public static String getToolEmulatorExeFile() {
        InstallDeviceInfo.checkInitialize();
        return toolEmulatorBinPath + EMULATOR_MANAGER_SUFFIX;
    }

    public static String getToolCertificateManagerExeFile() {
        InstallDeviceInfo.checkInitialize();
        return toolCertificatePath + CERTFICATE_MANAGER_SUFFIX;
    }

    public static String getToolEmulatorBinPath() {
        InstallDeviceInfo.checkInitialize();
        return toolEmulatorBinPath;
    }

    public static String getToolCertificateManagerRootPath() {
        InstallDeviceInfo.checkInitialize();
        return toolCertificatePath;
    }

    public static String getDeviceConfigPath() {
        InstallDeviceInfo.checkInitialize();
        return InstallDeviceInfo.getDeviceDataPath() + File.separator + DIR_CONFIG;
    }

    public static String getDeviceRemoteDeviceFilePath() {
        InstallDeviceInfo.checkInitialize();
        File configFolder = new File(InstallDeviceInfo.getDeviceConfigPath());
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        return InstallDeviceInfo.getDeviceConfigPath() + File.separator + DEVICE_REMOTE_DEVICE_FILE;
    }

    public static String getDeviceSettingsFilePath() {
        InstallDeviceInfo.checkInitialize();
        File configFolder = new File(InstallDeviceInfo.getDeviceConfigPath());
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        return InstallDeviceInfo.getDeviceConfigPath() + File.separator + DEVICE_MANAGER_SETTINGS;
    }

    public static String getOpenShellScriptForMacPath(String profileName, String version) {
        InstallDeviceInfo.checkInitialize();
        if (version.length() > 4 && version.endsWith("0")) {
            version = version.substring(0, version.length() - 2);
        }
        String platformScriptCommonPath = null;
        Map sdkMetaPkg = null;
        try {
            SDKUtils sdkUtils = SDKUtils.getInstance();
            sdkMetaPkg = sdkUtils.getPackages(null, null, null, ISDKPackage.SearchPackageType.META_PKG, false, true);
        }
        catch (Throwable e) {
            DeviceLogger.getLogger().log(Level.SEVERE, "Failed to load the supported profile list from the Package Manager", e);
            return platformScriptCommonPath;
        }
        if (sdkMetaPkg == null) {
            return null;
        }
        for (Map.Entry entry : sdkMetaPkg.entrySet()) {
            String pkgVersion;
            ISDKPackage pkg = (ISDKPackage)entry.getValue();
            if (ISDKPackage.Type.WEB_IDE != pkg.getType() && ISDKPackage.Type.NATIVE_IDE != pkg.getType()) continue;
            String profile = null;
            profile = pkg.isExtension() ? pkg.getExtensionProfile() : pkg.getProfile().name().toLowerCase();
            if (!profile.equalsIgnoreCase(profileName) && (!profileName.equals("tv") || !profile.equals("tv-samsung")) || !(pkgVersion = pkg.getPlatformVersion().toString()).equalsIgnoreCase(version)) continue;
            File versionFilePath = new File(pkg.getPlatformPath());
            File toolFilePath = new File(versionFilePath.getParent(), DIR_PLATFORM_COMMON);
            File openShellFilePath = new File(toolFilePath.getPath(), OPEN_SHELL_SCRIPT_PATH_MAC);
            if (!openShellFilePath.exists()) break;
            platformScriptCommonPath = openShellFilePath.getPath();
            break;
        }
        return platformScriptCommonPath;
    }

    public static String getTerminalDefaultPath() {
        String termPath = null;
        termPath = OSUtil.isWin() ? System.getenv("ComSpec") + " /c start" : (OSUtil.isMac() ? toolEmulatorBinPath + File.separatorChar + "sdbscript" : "/usr/bin/gnome-terminal -x");
        return termPath;
    }

    public static String getSingletonToolPath() {
        InstallDeviceInfo.checkInitialize();
        return InstallDeviceInfo.getToolDeviceBinPath() + TOOLS_SUFFIX;
    }

    static {
        TOOLS_SUFFIX = File.separator + "tools";
        BIN_SUFFIX = File.separator + "bin";
        DEVICE_SUFFIX = File.separator + "device-manager";
        EMULATOR_SUFFIX = File.separator + "emulator";
        CERTIFICATE_SUFFIX = File.separator + "certificate-manager";
        SDB_SUFFIX = File.separator + "sdb" + (OSUtil.isWin() ? ".exe" : "");
        EMULATOR_MANAGER_SUFFIX = File.separator + "emulator-manager" + (OSUtil.isWin() ? ".exe" : "");
        CERTFICATE_MANAGER_SUFFIX = File.separator + (OSUtil.isMac() ? "Certificate-manager.app" : "certificate-manager") + (OSUtil.isWin() ? ".exe" : "");
        isInitialized = false;
    }
}

