/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.logview.view;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.control.ImageButton;
import org.tizen.device.manager.resources.ImageKind;

public class LogTabToolBar
extends HBox {
    private HBox left;
    private Label messageLabel;
    private TextField messageTextField;
    private HBox right;
    private ImageButton editTabButton;
    private ImageButton clearLogButton;
    private ImageButton exportLogButton;
    private ImageButton scrollLockButton;
    private final String LABEL_MESSAGE = Messages.LOG_TAB_LABEL_MESSAGE;
    private final String PLACEHOLDER_MESSAGE = Messages.LOG_TAB_TOOLBAR_MESSAGE_BOX_MESSAGE;
    private final String TOOLTIP_EDIT_TAB = Messages.LOG_TAB_TOOLBAR_EDIT_LOG_TAB_TOOLTIP;
    private final String TOOLTIP_CLEAR_LOG = Messages.LOG_TAB_TOOLBAR_CLEAR_LOGS_TOOLTIP;
    private final String TOOLTIP_EXPORT_LOG = Messages.LOG_TAB_TOOLBAR_EXPORT_LOGS_TOOLTIP;
    private final String TOOLTIP_SCROLL_LOCK = Messages.LOG_TAB_TOOLBAR_SCROLL_LOCK_TOOLTIP;

    public LogTabToolBar() {
        this.setPrefHeight(35.0);
        this.setSpacing(10.0);
        this.setPadding(new Insets(0.0, 12.0, 0.0, 12.0));
        this.addMessageTextField();
        this.addSpacer();
        this.addIconButtons();
    }

    private void addMessageTextField() {
        this.left = new HBox();
        this.left.setAlignment(Pos.CENTER_LEFT);
        this.left.setSpacing(10.0);
        this.messageLabel = new Label(this.LABEL_MESSAGE);
        this.messageLabel.setMinWidth(50.0);
        this.messageTextField = new TextField();
        this.messageTextField.prefHeightProperty().bind((ObservableValue)this.heightProperty().multiply(0.7));
        this.messageTextField.prefWidthProperty().bind((ObservableValue)this.widthProperty().multiply(0.9));
        this.messageTextField.setPromptText(this.PLACEHOLDER_MESSAGE);
        this.left.getChildren().addAll((Object[])new Node[]{this.messageLabel, this.messageTextField});
        this.getChildren().add((Object)this.left);
    }

    private void addSpacer() {
        HBox rightSpacer = new HBox();
        HBox.setHgrow((Node)rightSpacer, (Priority)Priority.SOMETIMES);
        this.getChildren().add((Object)rightSpacer);
    }

    private void addIconButtons() {
        this.right = new HBox();
        this.right.setAlignment(Pos.CENTER_RIGHT);
        this.right.setSpacing(10.0);
        this.editTabButton = new ImageButton(ImageKind.ICON_LOGVIEW_EDIT_TAB_NOR, ImageKind.ICON_LOGVIEW_EDIT_TAB_OVER, ImageKind.ICON_LOGVIEW_EDIT_TAB_DIM);
        this.editTabButton.setTooltipText(this.TOOLTIP_EDIT_TAB);
        this.clearLogButton = new ImageButton(ImageKind.ICON_LOGVIEW_CLEAR_LOG_NOR, ImageKind.ICON_LOGVIEW_CLEAR_LOG_OVER, ImageKind.ICON_LOGVIEW_CLEAR_LOG_DIM);
        this.clearLogButton.setTooltipText(this.TOOLTIP_CLEAR_LOG);
        this.exportLogButton = new ImageButton(ImageKind.ICON_LOGVIEW_EXPORT_LOG_NOR, ImageKind.ICON_LOGVIEW_EXPORT_LOG_OVER, ImageKind.ICON_LOGVIEW_EXPORT_LOG_DIM);
        this.exportLogButton.setTooltipText(this.TOOLTIP_EXPORT_LOG);
        this.scrollLockButton = new ImageButton(ImageKind.ICON_LOGVIEW_SCROLL_LOCK_NOR, ImageKind.ICON_LOGVIEW_SCROLL_LOCK_OVER, ImageKind.ICON_LOGVIEW_SCROLL_LOCK_DIM, ImageKind.ICON_LOGVIEW_SCROLL_LOCK_SEL);
        this.scrollLockButton.setTooltipText(this.TOOLTIP_SCROLL_LOCK);
        this.right.getChildren().addAll((Object[])new Node[]{this.editTabButton.getPane(), this.clearLogButton.getPane(), this.exportLogButton.getPane(), this.scrollLockButton.getPane()});
        this.getChildren().add((Object)this.right);
    }

    public void addMessageTextFieldChangedEventListener(ChangeListener<String> listener) {
        this.messageTextField.textProperty().addListener(listener);
    }

    public void addEditTabButtonClickedEventHandler(EventHandler<MouseEvent> handler) {
        this.editTabButton.setOnMouseClicked(handler);
    }

    public void addClearLogButtonClickedEventHandler(EventHandler<MouseEvent> handler) {
        this.clearLogButton.setOnMouseClicked(handler);
    }

    public void addExportLogButtonClickedEventHandler(EventHandler<MouseEvent> handler) {
        this.exportLogButton.setOnMouseClicked(handler);
    }

    public void addScrollLockButtonClickedEventHandler(EventHandler<MouseEvent> handler) {
        this.scrollLockButton.setOnMouseClicked(handler);
    }
}

