/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.List;
import java.util.logging.Level;
import org.tizen.device.manager.InstallDeviceInfo;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.util.OSUtil;

public class SingletonFocusManager {
    private static FileChannel singletonChannel = null;
    private static FileLock singletonLock = null;
    public static final String WINDOW_ACTIVATOR_LINUX = "windowactivator.sh";
    public static final String WINDOW_ACTIVATOR_WINDOWS = "windowactivator.bat";
    public static final String WINDOW_ACTIVATOR_MACOS = "macoswindowactivator.sh";
    private static final String SINGLETON_LOCK_FILE = "RunningFileLock";
    private static final String SINGLETON_PID_FILE = "RunningPID";
    private static String toolsPath = null;
    private static String dataPath = null;

    private static String[] getSaveFocusPath() {
        String[] returnStr = null;
        String strPid = SingletonFocusManager.getPidFromSingletonFile();
        String activator = SingletonFocusManager.getWindowActivatorPath();
        if (strPid != null) {
            returnStr = new String[]{activator, strPid};
        }
        return returnStr;
    }

    public static void setFocusToRCP() {
        SingletonFocusManager.executeCommand(SingletonFocusManager.getSaveFocusPath());
    }

    public static boolean executeCommand(String[] cmds) {
        return SingletonFocusManager.executeCommand(cmds, null, null);
    }

    public static String getWindowActivatorPath() {
        if (OSUtil.isWin()) {
            return toolsPath + File.separator + WINDOW_ACTIVATOR_WINDOWS;
        }
        if (OSUtil.isMac()) {
            return toolsPath + File.separator + WINDOW_ACTIVATOR_MACOS;
        }
        return toolsPath + File.separator + WINDOW_ACTIVATOR_LINUX;
    }

    private static String getPidFromSingletonFile() {
        String pid = null;
        File singletonFile = new File(dataPath + File.separator + SINGLETON_PID_FILE);
        if (!singletonFile.isFile()) {
            DeviceLogger.getLogger().log(Level.WARNING, "Failed to get pid - dose not exist the file: " + singletonFile.getAbsolutePath());
        } else {
            try (BufferedReader in = new BufferedReader(new FileReader(singletonFile));){
                pid = in.readLine();
            }
            catch (FileNotFoundException e) {
                System.out.println(e);
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
        return pid;
    }

    public static void saveSingletonPid() {
        File savefile = new File(dataPath + File.separator + SINGLETON_PID_FILE);
        try (FileWriter fileWriter = new FileWriter(savefile);
             BufferedWriter buffWriter = new BufferedWriter(fileWriter);
             PrintWriter printWriter = new PrintWriter(buffWriter);){
            printWriter.println(SingletonFocusManager.getCurrentPid());
            printWriter.checkError();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean acquireSingleton() {
        boolean isFileLock = true;
        String dataPath = InstallDeviceInfo.getDeviceDataPath();
        File file = new File(dataPath + File.separator + SINGLETON_LOCK_FILE);
        try {
            singletonChannel = new RandomAccessFile(file, "rw").getChannel();
            singletonLock = singletonChannel.tryLock();
        }
        catch (FileNotFoundException e) {
            DeviceLogger.getLogger().log(Level.WARNING, e.getMessage());
        }
        catch (IOException e) {
            DeviceLogger.getLogger().log(Level.WARNING, e.getMessage());
        }
        finally {
            isFileLock = singletonLock != null;
        }
        return isFileLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeCommand(String[] cmd, List<String> stdoutput, List<String> stderror) {
        boolean bret = false;
        Process process = null;
        if (cmd != null && cmd.length > 0) {
            try {
                process = Runtime.getRuntime().exec(cmd);
                if (process != null) {
                    StreamReader inputReader = new StreamReader(process.getInputStream(), stdoutput);
                    StreamReader errorReader = new StreamReader(process.getErrorStream(), stderror);
                    inputReader.start();
                    errorReader.start();
                    process.waitFor();
                    inputReader.join();
                    errorReader.join();
                    bret = true;
                }
            }
            catch (IOException e) {
                System.out.println(e);
            }
            catch (InterruptedException e) {
                System.out.println(e);
                Thread.currentThread().interrupt();
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
        return bret;
    }

    public static void releaseSingleton() {
        try {
            if (singletonLock != null) {
                singletonLock.release();
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        try {
            if (singletonChannel != null) {
                singletonChannel.close();
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public static String getCurrentPid() {
        ManagementFactory.getRuntimeMXBean();
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        String Processid = rt.getName();
        return Processid.substring(0, Processid.indexOf("@"));
    }

    static {
        toolsPath = InstallDeviceInfo.getSingletonToolPath();
        dataPath = InstallDeviceInfo.getDeviceDataPath();
    }

    private static class StreamReader
    extends Thread {
        private InputStream is = null;
        private List<String> outputArray = null;

        protected StreamReader(InputStream is, List<String> outputArray) {
            super(StreamReader.class.getSimpleName() + is.getClass().getSimpleName());
            this.is = is;
            this.outputArray = outputArray;
        }

        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.is));){
                String line = null;
                while (null != (line = reader.readLine())) {
                    if (this.outputArray == null) continue;
                    this.outputArray.add(line);
                }
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }
}

