/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.control;

import javafx.application.Platform;
import javafx.scene.control.Label;
import org.tizen.device.manager.ui.diaglog.FilePushProgressDialog;
import org.tizen.sdblib.service.ISyncProgressMonitor;

public class SDBSyncProgressMonitor
implements ISyncProgressMonitor {
    private FilePushProgressDialog progrssMonitor;
    protected static String[] UNITS = new String[]{"B", "KB", "MB", "GB"};
    protected static String[] FORMATS = new String[]{"%.0f %s", "%.0f %s", "%.0f %s", "%.2f %s"};
    private long totalWork;
    private long worked;
    private int rate;
    private String labelFrom = "From: ";
    private String labelTo = "To: ";
    private String labelSize = "Size: ";
    private String name;
    private String lastFromStr = "";
    private String lastToStr = "";
    private String lastSizeStr = "";
    private String lastMsgStr = "";

    public SDBSyncProgressMonitor(FilePushProgressDialog progrssMonitor, String name) {
        this.progrssMonitor = progrssMonitor;
        this.name = name;
    }

    protected void apply(final int work) {
        String fromStr;
        String toStr;
        String sizeStr;
        String msgStr;
        final Label msgLabel = this.progrssMonitor.getMsgLabel();
        final Label fromLabel = this.progrssMonitor.getFromLabel();
        final Label toLabel = this.progrssMonitor.getToLabel();
        final Label sizeLabel = this.progrssMonitor.getSizeLabel();
        if (this.name == null) {
            msgStr = "";
            sizeStr = "";
            toStr = "";
            fromStr = "";
        } else {
            String[] subTasks = this.name.split("\t");
            if (subTasks.length != 2) {
                msgStr = subTasks[0];
                fromStr = "";
                toStr = "";
                sizeStr = "";
            } else {
                msgStr = this.lastMsgStr;
                fromStr = this.labelFrom + subTasks[0];
                toStr = this.labelTo + subTasks[1];
                sizeStr = this.labelSize + String.format("( %s / %s )", SDBSyncProgressMonitor.getSizeAndUnit(this.getWorked()), SDBSyncProgressMonitor.getSizeAndUnit(this.getTotal()));
            }
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SDBSyncProgressMonitor.this.progrssMonitor.setProgressBar(Double.valueOf(work));
                if (!SDBSyncProgressMonitor.this.lastMsgStr.equals(msgStr)) {
                    msgLabel.setText(msgStr);
                    SDBSyncProgressMonitor.this.lastMsgStr = fromStr;
                }
                if (!SDBSyncProgressMonitor.this.lastFromStr.equals(fromStr)) {
                    fromLabel.setText(fromStr);
                    SDBSyncProgressMonitor.this.lastFromStr = fromStr;
                }
                if (!SDBSyncProgressMonitor.this.lastToStr.equals(toStr)) {
                    toLabel.setText(toStr);
                    SDBSyncProgressMonitor.this.lastToStr = toStr;
                }
                if (!sizeStr.contains("KB") && !SDBSyncProgressMonitor.this.lastSizeStr.equals(sizeStr)) {
                    sizeLabel.setText(sizeStr);
                    SDBSyncProgressMonitor.this.lastSizeStr = sizeStr;
                }
            }
        });
    }

    protected static String getSizeAndUnit(long size) {
        double value;
        int index = 0;
        for (value = (double)size; index < UNITS.length - 1 && value >= 1000.0; value /= 1000.0, ++index) {
        }
        return String.format(FORMATS[index], value, UNITS[index]);
    }

    @Override
    public void advance(long work) {
        this.worked += work;
        this.apply((int)work / this.rate);
    }

    @Override
    public void start(long totalWork) {
        this.totalWork = totalWork;
        this.progrssMonitor.setTotalWork(Double.valueOf(totalWork));
        this.rate = 1;
        while (totalWork > Integer.MAX_VALUE) {
            totalWork /= 10L;
            this.rate *= 10;
        }
        this.apply(0);
    }

    @Override
    public void startSubTask(String name) {
        this.name = name;
        this.apply(0);
    }

    @Override
    public void stop() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SDBSyncProgressMonitor.this.progrssMonitor.setDone();
            }
        });
    }

    @Override
    public long getTotal() {
        return this.totalWork;
    }

    @Override
    public long getWorked() {
        return this.worked;
    }

    @Override
    public boolean isCanceled() {
        return this.progrssMonitor.isCanceled();
    }

    @Override
    public void printLog(String arg0) {
    }
}

