/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.logview.data;

public enum LogLevel {
    VERBOSE(2, "Verbose"),
    DEBUG(3, "Debug"),
    INFO(4, "Info"),
    WARN(5, "Warning"),
    ERROR(6, "Error"),
    FATAL(7, "Fatal"),
    SILENT(8, "Silent");

    private final int priority;
    private final String name;
    private char letter;

    private LogLevel(int priority, String name) {
        this.priority = priority;
        this.name = name;
        this.letter = name.charAt(0);
    }

    public static LogLevel getByName(String name) {
        for (LogLevel mode : LogLevel.values()) {
            if (!mode.name.equalsIgnoreCase(name)) continue;
            return mode;
        }
        return null;
    }

    public static LogLevel getByLetter(String val) {
        if (val.length() > 0) {
            char ch = val.charAt(0);
            for (LogLevel mode : LogLevel.values()) {
                if (mode.letter != ch) continue;
                return mode;
            }
            return null;
        }
        return null;
    }

    public char getLetter() {
        return this.letter;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getName() {
        return this.name;
    }
}

