/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.swing.JOptionPane;
import org.tizen.device.manager.InstallDeviceInfo;
import org.tizen.device.manager.SDBConnectionService;
import org.tizen.device.manager.SingletonFocusManager;
import org.tizen.device.manager.StringResources;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.service.impl.DeviceChangedListenerManager;
import org.tizen.device.manager.util.MacUtil;
import org.tizen.device.manager.util.OSUtil;
import org.tizen.library.sdkutils.util.RemoteLogger;

public class Main
extends Application {
    public static final String ICON_FILE_NAME = "/res/device-256.png";
    private static final String PRODUCT_NAME = "Device Manager";
    private static long startTime;
    private static final URL BASE_CSS_URL;
    private static final int MIN_WIDTH = 450;
    private static final int MIN_HEIGHT = 450;
    private static final int PREF_WIDTH = 654;
    private static final int PREF_HEIGHT = 610;
    private static Stage primaryStage;
    private static Window mainWindow;
    private static Pane root;

    private static void initializeLogger() {
        File logFile = new File(InstallDeviceInfo.getDeviceLogFilePath());
        DeviceLogger.makeBackupLog(Paths.get(logFile.getAbsolutePath(), new String[0]));
        DeviceLogger.getInstance().initialize();
        DeviceLogger.getInstance().setFileLogger(logFile);
        DeviceLogger.getInstance().setLevel(Level.ALL);
        DeviceLogger.getLogger().log(Level.INFO, "Start Device Manager!!");
    }

    static void obtainLockFile() {
        if (SingletonFocusManager.acquireSingleton()) {
            System.out.println("The First Device Manager Running");
            DeviceLogger.getLogger().log(Level.INFO, "The First Device Manager Running");
            SingletonFocusManager.saveSingletonPid();
        } else {
            System.out.println("Already Device Manager Running");
            DeviceLogger.getLogger().log(Level.INFO, "Already Device Manager Running");
            SingletonFocusManager.setFocusToRCP();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        try {
            InputStream is;
            if (OSUtil.isWin()) {
                OSUtil.setProcessAppUserModelID("DeviceManager");
            }
            InstallDeviceInfo.initialize();
            Main.initializeLogger();
            Main.obtainLockFile();
            startTime = System.currentTimeMillis() / 1000L;
            RemoteLogger.logAccess((String)PRODUCT_NAME);
            if (OSUtil.isMac() && (is = Main.class.getResourceAsStream(ICON_FILE_NAME)) != null) {
                try {
                    MacUtil.setDockIcon(is);
                }
                catch (Exception e) {
                    DeviceLogger.getLogger().warning("Throw exception: " + e.getMessage());
                }
                is.close();
            }
            Main.launch((String[])args);
        }
        catch (Throwable e) {
            DeviceLogger.getLogger().warning("Throw exception: " + e.getMessage());
            DeviceLogger.printStackTrace(e);
            JOptionPane.showMessageDialog(null, "Unexpected exception occured." + StringResources.NEW_LINE + StringResources.NEW_LINE + "Exception: " + StringResources.NEW_LINE + e.getMessage(), PRODUCT_NAME, 2);
            System.exit(1);
        }
    }

    public void start(Stage stage) throws Exception {
        primaryStage = stage;
        root = (Pane)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("/view/DeviceManager.fxml"));
        root.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/view/table_view.css").toExternalForm());
        root.prefHeight(610.0);
        root.prefWidth(654.0);
        Scene scene = new Scene((Parent)root);
        scene.getStylesheets().addAll(Main.getBaseCssUrl());
        stage.setTitle(PRODUCT_NAME);
        InputStream is = Main.class.getResourceAsStream(ICON_FILE_NAME);
        if (is != null) {
            stage.getIcons().add((Object)new Image(is));
            is.close();
        }
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                DeviceLogger.getLogger().log(Level.INFO, "Exit Device Manager!!");
                long endTime = System.currentTimeMillis() / 1000L;
                long usage = endTime - startTime;
                RemoteLogger.logUsage((String)Main.PRODUCT_NAME, (long)usage);
                SingletonFocusManager.releaseSingleton();
                Platform.exit();
                System.exit(0);
            }
        });
        stage.setScene(scene);
        stage.setMinHeight(450.0);
        stage.setMinWidth(450.0);
        mainWindow = scene.getWindow();
        stage.show();
        SDBConnectionService.initializeSmartDeviceBridge();
        new DeviceChangedListenerManager();
        SDBConnectionService.startSDBProcess();
    }

    public static Stage getPrimaryStage() {
        return primaryStage;
    }

    public static Window getMainWindow() {
        return mainWindow;
    }

    public static List<String> getBaseCssUrl() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(BASE_CSS_URL.toExternalForm());
        return list;
    }

    static {
        BASE_CSS_URL = Main.class.getResource("/view/base.css");
    }
}

