/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.logview.view;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.data.DeviceDescriptor;
import org.tizen.device.manager.logview.view.LogTab;
import org.tizen.device.manager.ui.diaglog.ButtonBar;
import org.tizen.device.manager.ui.diaglog.ButtonType;
import org.tizen.device.manager.ui.diaglog.Dialog;

public class CustomLogTabDialog
extends Dialog<String> {
    private DeviceDescriptor device;
    private TextField tabname;
    private ComboBox<DeviceDescriptor> targets;
    private final String LABEL_TITLE = Messages.LOG_TAB_DIALOG_TITLE_ADD_LOG_TAB;
    private final String LABEL_NAME = Messages.LOG_TAB_DIALOG_LABEL_TAB_NAME;
    private final String LABEL_TARGET = Messages.LOG_TAB_DIALOG_LABEL_DEVICE;
    private StringConverter<DeviceDescriptor> deviceNameConverter = new StringConverter<DeviceDescriptor>(){
        private Map<String, DeviceDescriptor> map = new HashMap<String, DeviceDescriptor>();

        public String toString(DeviceDescriptor device) {
            this.map.put(device.getSerialId(), device);
            return device.getSerialId();
        }

        public DeviceDescriptor fromString(String name) {
            if (this.map.containsKey(name)) {
                return this.map.get(name);
            }
            return null;
        }
    };

    public CustomLogTabDialog(DeviceDescriptor selectedDevice) {
        this.device = selectedDevice;
        this.createContents();
        this.setResultConverter(new Callback<ButtonType, String>(){

            public String call(ButtonType btn) {
                if (btn.getButtonData().equals((Object)ButtonBar.ButtonData.OK_DONE)) {
                    if (CustomLogTabDialog.this.tabname.getText().isEmpty()) {
                        return LogTab.generateDefaultTabName(CustomLogTabDialog.this.device);
                    }
                    return CustomLogTabDialog.this.tabname.getText();
                }
                return null;
            }
        });
    }

    private void createContents() {
        this.setTitle(this.LABEL_TITLE);
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        this.tabname = new TextField();
        this.tabname.setPromptText(LogTab.generateDefaultTabName(this.device));
        this.tabname.prefWidthProperty().bind((ObservableValue)this.widthProperty().multiply(0.6));
        this.targets = new ComboBox();
        this.targets.setConverter(this.deviceNameConverter);
        this.targets.getItems().add((Object)this.device);
        this.targets.getSelectionModel().select((Object)this.device);
        this.targets.setDisable(true);
        this.targets.prefWidthProperty().bind((ObservableValue)this.widthProperty().multiply(0.6));
        grid.add((Node)new Label(this.LABEL_NAME), 0, 1);
        grid.add((Node)this.tabname, 1, 1);
        grid.add((Node)new Label(this.LABEL_TARGET), 0, 3);
        grid.add(this.targets, 1, 3);
        grid.add((Node)new Label(""), 0, 4);
        this.getDialogPane().setContent((Node)grid);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.setResizable(false);
    }
}

