/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.resources;

import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.tizen.device.manager.resources.FontSupplier;
import org.tizen.device.manager.resources.ResourceKind;
import org.tizen.device.manager.resources.Supplier;
import org.tizen.device.manager.util.OSUtil;

public class FontKind
implements ResourceKind {
    private static final String FONT_SUPPLIER_BREEZESANS_BOLD = "BreezeSans-Bold";
    private static final String FONT_SUPPLIER_BREEZESANS = "BreezeSans";
    private static final String FONT_ARIAL = "Arial";
    public static FontKind FONT_38_BOLD = new FontKind(new FontSupplier("BreezeSans-Bold", 38.0), () -> Font.font((String)FONT_ARIAL, (FontWeight)FontWeight.BOLD, (double)37.0), new FontSupplier("BreezeSans-Bold", 38.0));
    public static FontKind FONT_32_BOLD = new FontKind(new FontSupplier("BreezeSans-Bold", 32.0), () -> Font.font((String)FONT_ARIAL, (FontWeight)FontWeight.BOLD, (double)31.0), new FontSupplier("BreezeSans-Bold", 32.0));
    public static FontKind FONT_34_BOLD = new FontKind(new FontSupplier("BreezeSans-Bold", 34.0), () -> Font.font((String)FONT_ARIAL, (FontWeight)FontWeight.BOLD, (double)33.0), new FontSupplier("BreezeSans-Bold", 34.0));
    public static final FontKind FONT_16 = new FontKind(new FontSupplier("BreezeSans", 16.0), () -> Font.font((String)FONT_ARIAL, (FontWeight)FontWeight.NORMAL, (double)15.0), new FontSupplier("BreezeSans", 16.0));
    public static final FontKind FONT_14 = new FontKind(new FontSupplier("BreezeSans", 14.0), () -> Font.font((String)FONT_ARIAL, (FontWeight)FontWeight.NORMAL, (double)13.0), new FontSupplier("BreezeSans", 14.0));
    public static final FontKind FONT_21 = new FontKind(new FontSupplier("BreezeSans", 21.0), () -> Font.font((String)FONT_ARIAL, (FontWeight)FontWeight.NORMAL, (double)20.0), new FontSupplier("BreezeSans", 21.0));
    public static final FontKind FONT_18 = new FontKind(new FontSupplier("BreezeSans", 18.0), () -> Font.font((String)FONT_ARIAL, (FontWeight)FontWeight.NORMAL, (double)17.0), new FontSupplier("BreezeSans", 18.0));
    private final Supplier<Font> linuxSupplier;
    private final Supplier<Font> winSupplier;
    private final Supplier<Font> macSupplier;

    public FontKind(Supplier<Font> supplier) {
        this.linuxSupplier = supplier;
        this.winSupplier = supplier;
        this.macSupplier = supplier;
    }

    public FontKind(Supplier<Font> linuxSupplier, Supplier<Font> winSupplier, Supplier<Font> macSupplier) {
        this.linuxSupplier = linuxSupplier;
        this.winSupplier = winSupplier;
        this.macSupplier = macSupplier;
    }

    public Supplier<Font> getSupplier() {
        if (OSUtil.isMac()) {
            return this.macSupplier;
        }
        if (OSUtil.isWin()) {
            return this.winSupplier;
        }
        return this.linuxSupplier;
    }
}

