/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.ui.diaglog;

import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import org.tizen.device.manager.InstallDeviceInfo;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.controller.SettingsPageChangeListener;
import org.tizen.device.manager.data.SettingsPageInfo;
import org.tizen.device.manager.ui.diaglog.ISettingsPropertyPage;

public class SettingsDevicePropertyPage
implements ISettingsPropertyPage {
    private GridPane gridPane;
    private TextField textFieldTimeout;
    private Text textTimeout;
    private TextField textFieldTerminalPath;
    private ArrayList<SettingsPageChangeListener> pageChangeListeners = new ArrayList();

    public SettingsDevicePropertyPage() {
        this.createContent();
        this.addChangeListener();
    }

    private void createContent() {
        this.gridPane = new GridPane();
        this.gridPane.setPadding(new Insets(20.0, 10.0, 10.0, 10.0));
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        Label labelTimeout = new Label(Messages.SETTINGS_DIALOG_LABEL_TIMEOUT);
        labelTimeout.setMinWidth(90.0);
        this.textFieldTimeout = new TextField();
        this.textFieldTimeout.setMinWidth(450.0);
        this.textFieldTimeout.setText(Integer.toString(SettingsPageInfo.getInstance().getConnectionTimeout()));
        this.textFieldTimeout.setEditable(true);
        this.textTimeout = new Text();
        this.textTimeout.setText(Messages.SETTINGS_DIALOG_TIMOUT_GUIDE_MESSAGE);
        this.gridPane.add((Node)labelTimeout, 0, 1);
        this.gridPane.add((Node)this.textFieldTimeout, 1, 1);
        this.gridPane.add((Node)this.textTimeout, 1, 2);
        Label labelTerminalPath = new Label(Messages.SETTINGS_DIALOG_LABEL_TERMINAL_PATH);
        labelTerminalPath.setMinWidth(80.0);
        this.textFieldTerminalPath = new TextField();
        this.textFieldTerminalPath.setMinWidth(450.0);
        this.textFieldTerminalPath.setText(InstallDeviceInfo.getTerminalDefaultPath());
        this.textFieldTerminalPath.setEditable(false);
        this.gridPane.add((Node)labelTerminalPath, 0, 6);
        this.gridPane.add((Node)this.textFieldTerminalPath, 1, 6);
    }

    private void addChangeListener() {
        this.textFieldTimeout.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    for (SettingsPageChangeListener listener : SettingsDevicePropertyPage.this.pageChangeListeners) {
                        listener.pageValueChanged();
                    }
                    if (SettingsDevicePropertyPage.this.isValidTimeout()) {
                        SettingsDevicePropertyPage.this.textTimeout.setText(Messages.SETTINGS_DIALOG_TIMOUT_GUIDE_MESSAGE);
                        SettingsDevicePropertyPage.this.textTimeout.setFill((Paint)Color.BLACK);
                    } else {
                        SettingsDevicePropertyPage.this.textTimeout.setText(Messages.SETTINGS_DIALOG_INVALID_TIMOUT_MESSAGE);
                        SettingsDevicePropertyPage.this.textTimeout.setFill((Paint)Color.RED);
                    }
                }
            }
        });
    }

    private boolean isValidTimeout() {
        try {
            int timeout = Integer.parseInt(this.textFieldTimeout.getText());
            return SettingsPageInfo.getInstance().isValidTimeout(timeout);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getTimeout() {
        return this.textFieldTimeout.getText();
    }

    @Override
    public Node getNode() {
        return this.gridPane;
    }

    @Override
    public String getTitle() {
        return TAB_NAME_DEVICE;
    }

    @Override
    public String getDescription() {
        return TAB_NAME_DEVICE;
    }

    @Override
    public boolean isPageValueValidate() {
        return this.isValidTimeout();
    }

    @Override
    public void addSettingsPageChangeListener(SettingsPageChangeListener listener) {
        this.pageChangeListeners.add(listener);
    }
}

