/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.tizen.device.manager.InstallDeviceInfo;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.service.impl.SettingsInfoChangedListener;
import org.tizen.device.manager.util.IOUtil;

public class SettingsPageInfo {
    private static SettingsPageInfo settingsPageInfo = null;
    private int connectionTimeout;
    private int logBufferSize;
    private ArrayList<SettingsInfoChangedListener> changedListeners = new ArrayList();
    public static int DEFAULT_CONNECTION_TIMEOUT = 30000;
    public static int DEFAULT_LOG_BUFFER_SIZE = 20000;

    public static SettingsPageInfo getInstance() {
        if (settingsPageInfo == null) {
            settingsPageInfo = new SettingsPageInfo();
        }
        return settingsPageInfo;
    }

    private SettingsPageInfo() {
        this.readFromFile();
    }

    private void readFromFile() {
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(InstallDeviceInfo.getDeviceSettingsFilePath());){
            props.load(fis);
            String strTimeout = props.getProperty("DEVICE_CONNECTION_TIMEOUT");
            String strBufferSize = props.getProperty("LOG_BUFFER_SIZE");
            this.connectionTimeout = strTimeout == null ? DEFAULT_CONNECTION_TIMEOUT : Integer.parseInt(strTimeout);
            this.logBufferSize = strBufferSize == null ? DEFAULT_LOG_BUFFER_SIZE : Integer.parseInt(strBufferSize);
        }
        catch (FileNotFoundException e) {
            this.connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
            this.logBufferSize = DEFAULT_LOG_BUFFER_SIZE;
            this.writeToFile();
        }
        catch (Exception e) {
            this.connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
            this.logBufferSize = DEFAULT_LOG_BUFFER_SIZE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile() {
        File newfile = null;
        PrintStream printStream = null;
        try {
            Properties props = new Properties();
            props.put("DEVICE_CONNECTION_TIMEOUT", Integer.toString(this.connectionTimeout));
            props.put("LOG_BUFFER_SIZE", Integer.toString(this.logBufferSize));
            newfile = new File(InstallDeviceInfo.getDeviceSettingsFilePath());
            printStream = new PrintStream(newfile);
            props.list(printStream);
        }
        catch (Exception e) {
            try {
                DeviceLogger.getLogger().log(Level.SEVERE, "Failed to make the settings file.", e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(printStream);
                IOUtil.tryClose(newfile);
                throw throwable;
            }
            IOUtil.tryClose(printStream);
            IOUtil.tryClose(newfile);
        }
        IOUtil.tryClose(printStream);
        IOUtil.tryClose(newfile);
    }

    public int getConnectionTimeout() {
        this.readFromFile();
        return this.connectionTimeout;
    }

    public int getLogBufferSize() {
        this.readFromFile();
        return this.logBufferSize;
    }

    public boolean isValidBufferSize(int size) {
        return 5000 <= size && size <= 100000;
    }

    public boolean isValidTimeout(int timeout) {
        return timeout == 0 || 30000 <= timeout && timeout <= 600000;
    }

    public void setDeviceConnectionTimeout(int newTimeout) {
        this.connectionTimeout = newTimeout;
        this.writeToFile();
        for (SettingsInfoChangedListener listener : this.changedListeners) {
            listener.settingsInfoChanged(this);
        }
    }

    public void setLogBufferSize(int newSize) {
        this.logBufferSize = newSize;
        this.writeToFile();
        for (SettingsInfoChangedListener listener : this.changedListeners) {
            listener.settingsInfoChanged(this);
        }
    }

    public void addChangedListener(SettingsInfoChangedListener listener) {
        this.changedListeners.add(listener);
    }

    public void removeChangedListener(SettingsInfoChangedListener listener) {
        this.changedListeners.remove(listener);
    }
}

