/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.service.impl;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import org.tizen.device.manager.data.DeviceDescriptor;
import org.tizen.device.manager.data.DeviceStateType;
import org.tizen.device.manager.data.DeviceType;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.service.impl.DeviceChangedListenerManager;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;

public class DeviceChangedListener
implements IDeviceChangeListener {
    private DeviceChangedListenerManager deviceListenerManager = DeviceChangedListenerManager.getInstance();

    public DeviceChangedListener() {
        SmartDevelopmentBridge.addDeviceChangeListener((IDeviceChangeListener)this);
    }

    public void onChanged(IDevice device, int changeMask) {
        if (changeMask == 1) {
            this.onConnected(device);
        }
    }

    public void onConnected(IDevice device) {
        Map<String, DeviceDescriptor> deviceDescriptors = this.deviceListenerManager.getDeviceDescriptors();
        String deviceName = device.getDeviceName();
        DeviceDescriptor deviceDesc = null;
        DeviceType deviceType = DeviceType.LOCAL_EMULATOR;
        if (!deviceDescriptors.containsKey(deviceName)) {
            deviceDesc = new DeviceDescriptor(device.getSerialNumber(), device);
            try {
                if (device.isRemote()) {
                    deviceType = device.isEmulator() ? DeviceType.REMOTE_EMULATOR : DeviceType.REMOTE_DEVICE;
                } else if (!device.isEmulator()) {
                    deviceType = DeviceType.LOCAL_DEVICE;
                }
                deviceDesc.setDeviceType(deviceType);
                deviceDesc.setDeviceName(deviceName);
                deviceDesc.setProfileName(device.getPlatformInfo().getProfileName());
                String profileName = device.getPlatformInfo().getProfileName();
                String platformVersion = device.getPlatformInfo().getPlatformVersion();
                if (profileName.startsWith("unknown")) {
                    profileName = device.getPlatformCapability().getProfileName();
                    platformVersion = device.getPlatformCapability().getPlatformVersion();
                }
                if (profileName.startsWith("unknown")) {
                    deviceDesc.setPlatformName("Unkown");
                } else {
                    deviceDesc.setPlatformName(String.format("%s-%s", profileName, platformVersion));
                }
                deviceDesc.setDeviceStateType(DeviceStateType.ONLINE);
                deviceDesc.setIDevice(device);
                deviceDesc.setTooltipName(String.format("%s (%s-%s)", deviceDesc.getSerialId(), deviceDesc.getPlatformName(), device.getArch().name()));
            }
            catch (TimeoutException e) {
                DeviceLogger.getLogger().log(Level.SEVERE, "Failed to sdb connection by TimeoutException: " + (Object)((Object)e));
            }
            catch (SdbCommandRejectedException e) {
                DeviceLogger.getLogger().log(Level.SEVERE, "Failed to sdb connection by SdbCommandRejectedException: " + (Object)((Object)e));
            }
            catch (IOException e) {
                DeviceLogger.getLogger().log(Level.SEVERE, "Failed to sdb connection by IOException: " + e);
            }
            this.deviceListenerManager.addDeviceDescriptor(deviceDesc);
            this.deviceListenerManager.fireLaunchTargetsChanged(deviceDesc, DeviceStateType.ONLINE);
        } else {
            deviceDesc = deviceDescriptors.get(deviceName);
            this.deviceListenerManager.fireLaunchTargetsChanged(deviceDesc, DeviceStateType.ONLINE);
        }
        deviceDesc.notifyIDeviceCreated();
    }

    public void onDisconnected(IDevice device) {
        Map<String, DeviceDescriptor> deviceDescriptors = this.deviceListenerManager.getDeviceDescriptors();
        DeviceDescriptor descriptor = deviceDescriptors.get(device.getSerialNumber());
        descriptor.setDescriptorName(String.format("%s (%s-%s)", device.getDeviceName(), "offline", device.getArchString()));
        descriptor.setDeviceStateType(DeviceStateType.OFFLINE);
        descriptor.setIDevice(null);
        if (descriptor.getDeviceType() != DeviceType.LOCAL_EMULATOR) {
            this.deviceListenerManager.removeDeviceDescriptor(device.getSerialNumber());
        }
        this.deviceListenerManager.fireLaunchTargetsChanged(descriptor, DeviceStateType.OFFLINE);
    }
}

