/*
 * Decompiled with CFR 0.152.
 */
package security;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ProfileParser {
    private static Logger log = LoggerFactory.getLogger(ProfileParser.class);

    public static ArrayList<String> getDUID(String xmlPath) throws FileNotFoundException, DOMException {
        ArrayList<String> duidList = new ArrayList<String>();
        try {
            if (!new File(xmlPath).exists()) {
                log.error("Can not find profilePath : " + xmlPath);
                throw new FileNotFoundException("Can not find profilePath : " + xmlPath);
            }
            File xmlFile = new File(xmlPath);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xmlFile);
            doc.getDocumentElement().normalize();
            NodeList CertNodeList = doc.getElementsByTagName("TestDevice");
            int i = 0;
            while (i < CertNodeList.getLength()) {
                Node itemNode = CertNodeList.item(i);
                if (itemNode.getNodeType() == 1) {
                    Element element = (Element)CertNodeList.item(i);
                    Text elementData = (Text)element.getFirstChild();
                    duidList.add(elementData.getData());
                }
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage());
            throw new FileNotFoundException();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new DOMException(4, "Failed to parse profile.xml");
        }
        return duidList;
    }

    public static String getPrivilegeLevel(String xmlPath) throws FileNotFoundException, DOMException {
        String privilegeLevel;
        try {
            if (!new File(xmlPath).exists()) {
                log.error("Can not find profilePath : " + xmlPath);
                throw new FileNotFoundException("Can not find profilePath : " + xmlPath);
            }
            File xmlFile = new File(xmlPath);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xmlFile);
            doc.getDocumentElement().normalize();
            NodeList list = doc.getElementsByTagName("GrantedPrivilege");
            Element element = (Element)list.item(0);
            Text elementData = (Text)element.getFirstChild();
            privilegeLevel = elementData.getData();
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage());
            throw new FileNotFoundException();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new DOMException(4, "Failed to parse profile.xml");
        }
        return privilegeLevel;
    }
}

