/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.control;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.ui.diaglog.FileDialogUtils;
import org.tizen.device.manager.util.IOUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;

public final class SDBAppLaunchCommand {
    private static final String VERSION_3 = "3.0";
    private static final String WEB_APP_INSTALL_COMMAND = "/usr/bin/pkgcmd -i -q -t wgt -p %widgetPath";
    private static final String TEMPORARY_DIR_PATH = "/tmp";
    private static final String CMD_RESULT_PREFIX = "cmd_ret:";
    private static final String CMD_SUFFIX = "; echo cmd_ret:$?;";
    private static final String DELIMETER_REGEXP = "\\.";
    private static final String XWALK_LAUNCHER = "xwalk-launcher";
    private static final int DEFAULT_TIME_OUT = 300;
    private static String errorMsg = "";

    public static String installApp(IDevice selectDevice, File appFile) {
        errorMsg = "";
        try {
            SDBAppLaunchCommand.appTransferPackageToDevice(selectDevice, appFile);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        String cmd = SDBAppLaunchCommand.getInstallCommand(selectDevice, appFile);
        String pkgCmdDebugModeSupport = null;
        try {
            pkgCmdDebugModeSupport = selectDevice.getPlatformCapability().getPkgcmdDebugModeSupport();
        }
        catch (Exception e) {
            DeviceLogger.getLogger().log(Level.INFO, "Failed to get platform capability", e);
        }
        if (pkgCmdDebugModeSupport != null && pkgCmdDebugModeSupport.equals("enabled")) {
            cmd = cmd + " -G";
        }
        MultiLineReceiver receiver = new MultiLineReceiver(){

            @Override
            public void processNewLines(String[] lines) {
                SDBAppLaunchCommand.sayError(lines, Messages.FILEDIALOG_SDB_COMMAND_INSTALL_ERROR_MESSAGE);
            }
        };
        try {
            selectDevice.executeShellCommand(SDBAppLaunchCommand.makeCommandWithExitcode(cmd), receiver, 300000);
        }
        catch (IOException e) {
            try {
                DeviceLogger.getLogger().log(Level.SEVERE, Messages.FILEDIALOG_SDB_COMMAND_INSTALL_ERROR_MESSAGE, e.getMessage());
                DeviceLogger.getLogger().log(Level.SEVERE, Messages.FILEDIALOG_SDB_COMMAND_INSTALL_ERROR_MESSAGE, cmd);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                SDBAppLaunchCommand.deleteDir(selectDevice, appFile);
                IOUtil.tryClose(receiver);
                throw throwable;
            }
        }
        SDBAppLaunchCommand.deleteDir(selectDevice, appFile);
        IOUtil.tryClose(receiver);
        return errorMsg;
    }

    public static void appTransferPackageToDevice(IDevice selectDevice, File appFile) throws Exception {
        if (selectDevice == null || appFile == null) {
            return;
        }
        SDBAppLaunchCommand.makeTmpDir(selectDevice);
        if (!errorMsg.isEmpty()) {
            throw new Exception(errorMsg);
        }
        SDBAppLaunchCommand.pushAppFile(selectDevice, appFile);
        if (!errorMsg.isEmpty()) {
            throw new Exception(errorMsg);
        }
    }

    private static void makeTmpDir(IDevice selectDevice) {
        MultiLineReceiver receiver;
        block5: {
            String cmd = "";
            String dirPKG = SDBAppLaunchCommand.getAppTmpDirectory(selectDevice);
            cmd = "mkdir -p " + dirPKG;
            receiver = new MultiLineReceiver(){

                @Override
                public void processNewLines(String[] lines) {
                    SDBAppLaunchCommand.sayError(lines, Messages.FILEDDIALOG_SDB_COMMAND_MAKE_DIR_ERROR_MESSAGE);
                }
            };
            try {
                if (cmd.indexOf(XWALK_LAUNCHER) != -1) {
                    selectDevice.executeShellCommand(cmd, receiver, 3000);
                    break block5;
                }
                selectDevice.executeShellCommand(cmd, receiver, 300000);
            }
            catch (IOException e) {
                try {
                    DeviceLogger.getLogger().log(Level.SEVERE, Messages.FILEDDIALOG_SDB_COMMAND_MAKE_DIR_ERROR_MESSAGE, e.getMessage());
                    DeviceLogger.getLogger().log(Level.SEVERE, Messages.FILEDDIALOG_SDB_COMMAND_MAKE_DIR_ERROR_MESSAGE, cmd);
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose(receiver);
                    throw throwable;
                }
            }
        }
        IOUtil.tryClose(receiver);
    }

    private static void deleteDir(IDevice selectDevice, File appFile) {
        MultiLineReceiver receiver;
        block5: {
            String cmd = "";
            String dirPKG = SDBAppLaunchCommand.getAppTmpDirectory(selectDevice);
            cmd = "rm -f " + dirPKG + "/" + appFile.getName();
            receiver = new MultiLineReceiver(){

                @Override
                public void processNewLines(String[] lines) {
                    SDBAppLaunchCommand.sayError(lines, Messages.FILEDIALOG_SDB_COMMAND_DELETE_DIR_ERROR_MESSAGE);
                }
            };
            try {
                if (cmd.indexOf(XWALK_LAUNCHER) != -1) {
                    selectDevice.executeShellCommand(cmd, receiver, 3000);
                    break block5;
                }
                selectDevice.executeShellCommand(cmd, receiver, 300000);
            }
            catch (IOException e) {
                try {
                    DeviceLogger.getLogger().log(Level.SEVERE, Messages.FILEDIALOG_SDB_COMMAND_DELETE_DIR_ERROR_MESSAGE, e.getMessage());
                    DeviceLogger.getLogger().log(Level.SEVERE, Messages.FILEDIALOG_SDB_COMMAND_DELETE_DIR_ERROR_MESSAGE, cmd);
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose(receiver);
                    throw throwable;
                }
            }
        }
        IOUtil.tryClose(receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void pushAppFile(IDevice selectDevice, File appFile) {
        SyncService service;
        block6: {
            service = null;
            try {
                String destPath = SDBAppLaunchCommand.getAppTmpDirectory(selectDevice) + "/" + appFile.getName();
                service = selectDevice.getSyncService();
                SyncResult result = service.push(appFile.getAbsolutePath(), selectDevice.getFileEntry(destPath).getParent());
                if (result.isOk()) break block6;
                FileDialogUtils.pushFileErrorMessage(result.getMessage());
            }
            catch (FileNotFoundException e) {
                FileDialogUtils.pushFileErrorMessage(e.getMessage());
                IOUtil.tryClose(service);
            }
            catch (IOException e2) {
                FileDialogUtils.pushFileErrorMessage(e2.getMessage());
                {
                    catch (Throwable throwable) {
                        IOUtil.tryClose(service);
                        throw throwable;
                    }
                }
                IOUtil.tryClose(service);
            }
        }
        IOUtil.tryClose(service);
    }

    private static String getInstallCommand(IDevice selectDevice, File appFile) {
        String cmd = WEB_APP_INSTALL_COMMAND;
        StringBuffer sbcmd = new StringBuffer(WEB_APP_INSTALL_COMMAND);
        String regex = "%widgetPath";
        Pattern pattern = Pattern.compile(regex);
        Matcher match = pattern.matcher(sbcmd);
        while (match.find()) {
            cmd = cmd.replace(regex, "\"" + SDBAppLaunchCommand.getAbsolutePathTmpAppFile(selectDevice, appFile) + "\"");
        }
        return cmd;
    }

    private static String getAbsolutePathTmpAppFile(IDevice selectDevice, File appFile) {
        return selectDevice.getAppInstallPath() + TEMPORARY_DIR_PATH + "/" + appFile.getName();
    }

    private static String getAppTmpDirectory(IDevice device) {
        return device.getAppInstallPath() + TEMPORARY_DIR_PATH;
    }

    public static boolean isSameOrBiggerThanVersion3(String checkVersion) {
        String[] thisParts = checkVersion.split(DELIMETER_REGEXP);
        String[] thatParts = VERSION_3.split(DELIMETER_REGEXP);
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
            int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
            if (thisPart < thatPart) {
                return false;
            }
            if (thisPart <= thatPart) continue;
            return true;
        }
        return true;
    }

    private static String makeCommandWithExitcode(String command) {
        return command + CMD_SUFFIX;
    }

    private static void sayError(String[] lines, String message) {
        if (lines[0].contains("failed")) {
            errorMsg = message + "\n\nReason:\n" + lines[0];
        }
    }
}

