/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.logview.controller;

import java.io.BufferedWriter;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import javafx.stage.FileChooser;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.data.DeviceDescriptor;
import org.tizen.device.manager.logview.data.Log;
import org.tizen.device.manager.logview.data.LogModel;
import org.tizen.device.manager.logview.view.EditLogTabDialog;

public class LogTabToolBarController {
    private LogModel logModel;
    private String FILE_DIALOG_TITLE = Messages.LOG_TAB_DIALOG_TITLE_EXPORT_LOGS;
    private String FILE_DIALOG_EXTENSION_TXT = Messages.LOG_TAB_DIALOG_EXTENSION_TXT;
    private String FILE_DIALOG_FILE_NAME_POST_FIX = Messages.LOG_TAB_DIALOG_FILE_NAME_POSTFIX;

    public LogTabToolBarController(LogModel model) {
        this.logModel = model;
    }

    public void changeMessageFilter(String newValue) {
        ArrayList<String> messages = new ArrayList<String>();
        if (!newValue.isEmpty()) {
            messages.add(newValue);
        }
        this.logModel.setMessageCriterion(messages);
    }

    public String getNewTabName(String tabname, DeviceDescriptor deviceDescriptor) {
        EditLogTabDialog dialog = new EditLogTabDialog(tabname, deviceDescriptor);
        return (String)dialog.showAndWait();
    }

    public void clearLog() {
        this.logModel.clearAllLogs();
    }

    public void exportLogToFile(String tabname) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.FILE_DIALOG_TITLE);
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(this.FILE_DIALOG_EXTENSION_TXT, new String[]{"*." + this.FILE_DIALOG_EXTENSION_TXT}));
        fileChooser.setInitialFileName(tabname + this.FILE_DIALOG_FILE_NAME_POST_FIX + "." + this.FILE_DIALOG_EXTENSION_TXT);
        File file = fileChooser.showSaveDialog(null);
        if (file != null) {
            String filename = file.getAbsolutePath();
            try (PrintWriter fw = new PrintWriter(filename);
                 BufferedWriter bw = new BufferedWriter(fw);){
                ArrayList<Log> logs = this.logModel.getMatchedLogs();
                for (Log log : logs) {
                    bw.write(log.toString());
                    bw.newLine();
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

