/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.ui.diaglog;

import org.tizen.device.manager.Messages;
import org.tizen.device.manager.ui.diaglog.ButtonType;
import org.tizen.device.manager.ui.diaglog.CheckReturn;
import org.tizen.device.manager.ui.diaglog.MessageBox;

public class FileDialogUtils {
    public static final int YES_ID = 0;
    public static final int YES_TO_ALL_ID = 1;
    public static final int NO_ID = 2;
    public static final int CANCEL_ID = 3;

    public static ButtonType pushFileErrorMessage(String errorMsg) {
        String message = Messages.FILEDIALOG_PUSH_FAIL_ITEMS + "\n" + errorMsg;
        return MessageBox.error(Messages.FILEDIALOG_ERROR_TITLE, message);
    }

    public static ButtonType pullFileErrorMessage(String errorMsg) {
        String message = Messages.FILEDIALOG_PULL_FAIL_ITEMS + "\n" + errorMsg;
        return MessageBox.error(Messages.FILEDIALOG_ERROR_TITLE, message);
    }

    public static ButtonType permitErrorMessage(String errorMsg) {
        String message = Messages.FILEDIALOG_PERMIT_FAIL_ITEMS + "\n" + errorMsg;
        return MessageBox.error(Messages.FILEDIALOG_ERROR_TITLE, message);
    }

    public static ButtonType successPopupMessage(String popupMessage) {
        return MessageBox.error(Messages.FILEDIALOG_MESSAGE_TITLE, popupMessage);
    }

    public static ButtonType confirmPushDirectory(String selectName) {
        String message = String.format(Messages.FILEDIALOG_PUSH_SELECT_DIRECTORY, selectName);
        ButtonType resultBtn = MessageBox.confirm(Messages.FILEDIALOG_MESSAGE_TITLE, message, ButtonType.OK);
        return resultBtn;
    }

    public static ButtonType checkOverwrite(String filename) {
        String message = String.format(Messages.FILEDIALOG_OVERWRITE_MESSAGE, filename);
        ButtonType resultBtn = MessageBox.confirm(Messages.FILEDIALOG_MESSAGE_TITLE, message, ButtonType.YES, ButtonType.YESTOALL, ButtonType.NO);
        return resultBtn;
    }

    public static ButtonType allowFileOverwrite(String filename) {
        String message = String.format(Messages.FILEDIALOG_OVERWRITE_MESSAGE, filename);
        ButtonType resultBtn = MessageBox.confirm(Messages.FILEDIALOG_MESSAGE_TITLE, message, ButtonType.OK);
        return resultBtn;
    }

    public static ButtonType remoteDeviceConnectErrorMessage(String errorMsg) {
        String message = errorMsg + "\n\n" + Messages.REMOTE_DEVICE_MANAGER_CONNECT_FAILURE;
        return MessageBox.error(Messages.FILEDIALOG_ERROR_TITLE, message);
    }

    public static ButtonType remoteAddDeviceErrorMessage(String ipPort) {
        String message = ipPort + "\n" + Messages.REMOTE_DEVICE_MANAGER_ADD_DEVICE_SAMEVALUE;
        return MessageBox.error(Messages.FILEDIALOG_ERROR_TITLE, message);
    }

    public static ButtonType remoteAddDeviceInvalidPortErrorMessage(String port) {
        String message = "\"" + port + "\" " + Messages.REMOTE_DEVICE_MANAGER_INVALIDPORT;
        return MessageBox.error(Messages.FILEDIALOG_ERROR_TITLE, message);
    }

    public static ButtonType remoteAddDeviceInvalidIpErrorMessage(String ip) {
        String message = "\"" + ip + "\" " + Messages.REMOTE_DEVICE_MANAGER_INVALIDIP;
        return MessageBox.error(Messages.FILEDIALOG_ERROR_TITLE, message);
    }

    public static ButtonType remoteAddDeviceEmptyNameErrorMessage() {
        String message = Messages.REMOTE_DEVICE_MANAGER_EMPTYNAME;
        return MessageBox.error(Messages.FILEDIALOG_ERROR_TITLE, message);
    }

    public static ButtonType allowDeleteAllLogTabs(String deviceSerialName) {
        String message = String.format(Messages.FILEDIALOG_DELETE_ALL_LOG_TABS_MESSAGE, deviceSerialName);
        ButtonType resultBtn = MessageBox.confirm(Messages.FILEDIALOG_MESSAGE_TITLE, message, ButtonType.OK);
        return resultBtn;
    }

    public static ButtonType impossibleDeleteAllLogTabs(String deviceSerialName) {
        String message = String.format(Messages.FILEDIALOG_DELETE_ALL_LOG_TABS_IMPOSSIBLE_MESSAGE, deviceSerialName);
        ButtonType resultBtn = MessageBox.confirm(Messages.FILEDIALOG_MESSAGE_TITLE, message, ButtonType.OK);
        return resultBtn;
    }

    public static CheckReturn inputMessageBox(String title, String guideMessage, String initInputMessage) {
        CheckReturn ret = MessageBox.fileExplorerInputBox(title, guideMessage, initInputMessage);
        return ret;
    }

    public static ButtonType notifyDuplication(String filename) {
        String message = String.format(Messages.FILEDIALOG_DUPLICATE_MESSAGE, filename);
        ButtonType resultBtn = MessageBox.confirm(Messages.FILEDIALOG_MESSAGE_TITLE, message, ButtonType.OK);
        return resultBtn;
    }

    public static ButtonType fileExplorerErrorMessage(String errorMsg, String detailErrorMsg) {
        String message = errorMsg + "\n\nReason:\n" + detailErrorMsg;
        return MessageBox.error(Messages.FILEDIALOG_ERROR_TITLE, message);
    }

    public static ButtonType allowDeleteToFileAndFolder(String deleteName) {
        String message = String.format(Messages.FILEDIALOG_DELETE_MESSAGE, deleteName);
        ButtonType resultBtn = MessageBox.confirm(Messages.FILEDIALOG_MESSAGE_TITLE, message, ButtonType.OK);
        return resultBtn;
    }

    public static ButtonType openShellErrorMessage(String errorMsg) {
        String message = Messages.FILEDIALOG_OPEN_SHELL_ERROR_MESSAGE + "\n" + errorMsg;
        return MessageBox.error(Messages.FILEDIALOG_ERROR_TITLE, message);
    }

    public static ButtonType permitToInstallErrorMessageToPopup(String errorMsg) {
        return MessageBox.popupToCertificate(Messages.FILEDIALOG_ERROR_TITLE, errorMsg);
    }

    public static ButtonType permitToInstallInfoMessageToPopup(String errorMsg) {
        return MessageBox.popupToCertificate(Messages.FILEDIALOG_MESSAGE_TITLE, errorMsg);
    }

    public static ButtonType permitToInstallErrorMessage(String errorMsg) {
        String message = Messages.FILEDIALOG_PERMIT_TO_INSTALL_ERROR_MESSAGE + "\n" + errorMsg;
        return MessageBox.error(Messages.FILEDIALOG_ERROR_TITLE, message);
    }

    public static ButtonType permitToInstallInfoMessage(String errorMsg) {
        return MessageBox.error(Messages.FILEDIALOG_MESSAGE_TITLE, errorMsg);
    }

    public static ButtonType permitToInstallSuccessMessage(String msg) {
        return MessageBox.error(Messages.FILEDIALOG_MESSAGE_TITLE, msg);
    }
}

