/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.ui.diaglog;

import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.model.FileEntryPermissionItem;
import org.tizen.device.manager.ui.diaglog.IFileEntryPropertyPage;
import org.tizen.sdblib.service.FileEntry;

public class FileEntryPropertyPermissionPage
extends TableView<FileEntryPermissionItem>
implements IFileEntryPropertyPage {
    private BorderPane borderPane;
    private FileEntry fileEntry;
    private TableView<FileEntryPermissionItem> tableView;
    private TableColumn<FileEntryPermissionItem, String> item;
    private TableColumn<FileEntryPermissionItem, String> read;
    private TableColumn<FileEntryPermissionItem, String> write;
    private TableColumn<FileEntryPermissionItem, String> execute;
    private static String LABEL_ITEM = "";
    private static String LABEL_READ = Messages.PROPERTIES_DIALOG_LABEL_READ;
    private static String LABEL_WRITE = Messages.PROPERTIES_DIALOG_LABEL_WRITE;
    private static String LABEL_EXECUTE = Messages.PROPERTIES_DIALOG_LABEL_EXECUTE;
    private static String ITEM_USER = Messages.PROPERTIES_DIALOG_LABEL_USER;
    private static String ITEM_GROUP = Messages.PROPERTIES_DIALOG_LABEL_GROUP;
    private static String ITEM_OTHER = Messages.PROPERTIES_DIALOG_LABEL_OTHER;
    private static final String FX_ALIGNMENT_CENTER = "-fx-alignment: CENTER;";
    private final ObservableList<FileEntryPermissionItem> permissionItems = FXCollections.observableArrayList();

    public FileEntryPropertyPermissionPage(FileEntry fileEntry) {
        this.fileEntry = fileEntry;
        this.createContent();
        this.createTableData();
    }

    private void createContent() {
        this.borderPane = new BorderPane();
        this.tableView = new TableView();
        this.tableView.getStylesheets().add((Object)this.getClass().getResource("/view/table_view_property.css").toExternalForm());
        this.tableView.setPrefSize(330.0, 140.0);
        this.tableView.setMaxWidth(320.0);
        VBox vbox = new VBox();
        vbox.setPadding(new Insets(30.0, 50.0, 0.0, 20.0));
        vbox.setSpacing(8.0);
        this.item = new TableColumn(LABEL_ITEM);
        this.read = new TableColumn(LABEL_READ);
        this.write = new TableColumn(LABEL_WRITE);
        this.execute = new TableColumn(LABEL_EXECUTE);
        this.item.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<FileEntryPermissionItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<FileEntryPermissionItem, String> param) {
                return ((FileEntryPermissionItem)param.getValue()).itemProperty();
            }
        });
        this.read.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<FileEntryPermissionItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<FileEntryPermissionItem, String> param) {
                return ((FileEntryPermissionItem)param.getValue()).readProperty();
            }
        });
        this.write.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<FileEntryPermissionItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<FileEntryPermissionItem, String> param) {
                return ((FileEntryPermissionItem)param.getValue()).writeProperty();
            }
        });
        this.execute.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<FileEntryPermissionItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<FileEntryPermissionItem, String> param) {
                return ((FileEntryPermissionItem)param.getValue()).executeProperty();
            }
        });
        this.item.setMinWidth(80.0);
        this.item.setMaxWidth(90.0);
        this.item.setSortable(false);
        this.item.setEditable(false);
        this.item.setStyle(FX_ALIGNMENT_CENTER);
        this.read.setMinWidth(80.0);
        this.read.setMaxWidth(90.0);
        this.read.setSortable(false);
        this.read.setEditable(false);
        this.read.setStyle(FX_ALIGNMENT_CENTER);
        this.write.setMinWidth(80.0);
        this.write.setMaxWidth(90.0);
        this.write.setSortable(false);
        this.write.setEditable(false);
        this.write.setStyle(FX_ALIGNMENT_CENTER);
        this.execute.setMinWidth(80.0);
        this.execute.setMaxWidth(90.0);
        this.execute.setSortable(false);
        this.execute.setEditable(false);
        this.execute.setStyle(FX_ALIGNMENT_CENTER);
        this.execute.setResizable(false);
        this.tableView.getColumns().addAll((Object[])new TableColumn[]{this.item, this.read, this.write, this.execute});
        Separator separator = new Separator();
        separator.setOrientation(Orientation.HORIZONTAL);
        separator.setMinWidth(450.0);
        vbox.getChildren().addAll((Object[])new Node[]{this.tableView, separator});
        this.borderPane.setCenter((Node)vbox);
    }

    private void createTableData() {
        String permission = this.fileEntry.getPermissions();
        String readStr = permission.charAt(1) != '-' ? "O" : "X";
        String writeStr = permission.charAt(2) != '-' ? "O" : "X";
        String executeStr = permission.charAt(3) != '-' ? "O" : "X";
        FileEntryPermissionItem itemUser = new FileEntryPermissionItem(ITEM_USER, readStr, writeStr, executeStr);
        readStr = permission.charAt(4) != '-' ? "O" : "X";
        writeStr = permission.charAt(5) != '-' ? "O" : "X";
        executeStr = permission.charAt(6) != '-' ? "O" : "X";
        FileEntryPermissionItem itemGroup = new FileEntryPermissionItem(ITEM_GROUP, readStr, writeStr, executeStr);
        readStr = permission.charAt(7) != '-' ? "O" : "X";
        writeStr = permission.charAt(8) != '-' ? "O" : "X";
        executeStr = permission.charAt(9) != '-' ? "O" : "X";
        FileEntryPermissionItem itemOther = new FileEntryPermissionItem(ITEM_OTHER, readStr, writeStr, executeStr);
        this.permissionItems.addAll((Object[])new FileEntryPermissionItem[]{itemUser, itemGroup, itemOther});
        this.tableView.setItems(this.permissionItems);
    }

    @Override
    public Node getNode() {
        return this.borderPane;
    }

    @Override
    public String getTitle() {
        return "Permission";
    }

    @Override
    public String getDescription() {
        return "Permission";
    }
}

