/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.ui.diaglog;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.control.DeviceCheckBox;
import org.tizen.device.manager.resources.FontKind;
import org.tizen.device.manager.resources.Fonts;
import org.tizen.device.manager.resources.SimpleExecutor;
import org.tizen.device.manager.service.impl.ActionProcessor;
import org.tizen.device.manager.ui.diaglog.ButtonBar;
import org.tizen.device.manager.ui.diaglog.ButtonType;
import org.tizen.device.manager.ui.diaglog.CheckReturn;
import org.tizen.device.manager.ui.diaglog.Dialog;
import org.tizen.device.manager.ui.diaglog.FileDialogUtils;
import org.tizen.device.manager.util.FilenameUtil;

public class MessageBox {
    public static ButtonType confirm(String message) {
        return MessageBox.confirm(Messages.DEVICE_MANAGER, message, ButtonType.OK);
    }

    public static ButtonType confirm(String title, String message) {
        return MessageBox.confirm(title, message, ButtonType.OK);
    }

    public static ButtonType confirm(String message, ButtonType type) {
        return MessageBox.confirm(Messages.DEVICE_MANAGER, message, type);
    }

    public static ButtonType confirm(String title, String message, ButtonType ... types) {
        Dialog dialog = new Dialog();
        dialog.setContentText(message);
        dialog.setTitle(title);
        dialog.getDialogPane().addButonType(ButtonType.CANCEL);
        for (ButtonType type : types) {
            dialog.getDialogPane().addButonType(type);
        }
        return (ButtonType)dialog.showAndWait();
    }

    public static ButtonType error(String message) {
        return MessageBox.error(Messages.DEVICE_MANAGER, message);
    }

    public static ButtonType error(String title, String message) {
        Dialog dialog = new Dialog();
        dialog.setContentText(message);
        dialog.setTitle(title);
        dialog.getDialogPane().addButonType(ButtonType.OK);
        return (ButtonType)dialog.showAndWait();
    }

    public static CheckReturn check(String message, String checkMessage, boolean isChecked, ButtonType ... types) {
        return MessageBox.check(Messages.DEVICE_MANAGER, message, checkMessage, isChecked, types);
    }

    public static CheckReturn check(String message, String checkMessage, ButtonType ... types) {
        return MessageBox.check(Messages.DEVICE_MANAGER, message, checkMessage, true, types);
    }

    public static CheckReturn check(String title, String message, String checkMessage, boolean isChecked, ButtonType ... types) {
        Dialog<CheckReturn> dialog = new Dialog<CheckReturn>();
        VBox content = new VBox();
        content.getStyleClass().add((Object)"content-pane");
        Label labMsg = new Label(message);
        labMsg.getStyleClass().add((Object)"content-label");
        GridPane grid = new GridPane();
        grid.setPadding(new Insets(20.0, 20.0, 15.0, 15.0));
        final DeviceCheckBox checkBox = new DeviceCheckBox(checkMessage);
        checkBox.setSelected(isChecked);
        grid.add((Node)checkBox.getPane(), 1, 1);
        content.getChildren().add((Object)labMsg);
        content.getChildren().add((Object)grid);
        content.layout();
        dialog.getDialogPane().setContent((Node)content);
        dialog.setTitle(title);
        for (ButtonType type : types) {
            dialog.getDialogPane().addButonType(type);
        }
        dialog.setResultConverter(new Callback<ButtonType, CheckReturn>(){

            public CheckReturn call(ButtonType param) {
                CheckReturn re = new CheckReturn();
                re.setButtonType(param);
                re.setChecked(checkBox.isSelected());
                return re;
            }
        });
        return (CheckReturn)dialog.showAndWait();
    }

    public static CheckReturn fileExplorerInputBox(String title, String guidMessage, String initMessage) {
        Dialog<CheckReturn> dialog = new Dialog<CheckReturn>();
        dialog.setTitle(title);
        BorderPane borderPane = new BorderPane();
        VBox mainVBox = new VBox();
        mainVBox.getStyleClass().add((Object)"content-pane");
        mainVBox.setAlignment(Pos.BASELINE_LEFT);
        mainVBox.setSpacing(5.0);
        mainVBox.setPadding(new Insets(100.0, 100.0, 100.0, 100.0));
        HBox guideHBox = new HBox();
        Label guidLabel = new Label(guidMessage);
        guideHBox.getChildren().addAll((Object[])new Node[]{guidLabel});
        guideHBox.setSpacing(10.0);
        guideHBox.setPadding(new Insets(5.0, 5.0, 0.0, 5.0));
        HBox nameHBox = new HBox();
        final TextField nameTextField = new TextField();
        nameTextField.setPrefWidth(300.0);
        nameTextField.setText(initMessage);
        nameHBox.getChildren().addAll((Object[])new Node[]{nameTextField});
        nameHBox.setSpacing(10.0);
        nameHBox.setAlignment(Pos.CENTER_LEFT);
        nameHBox.setPadding(new Insets(5.0, 5.0, 0.0, 5.0));
        HBox errorHBox = new HBox();
        Label errorLabel = new Label();
        errorLabel.getStyleClass().add((Object)"content-error-label");
        errorHBox.getChildren().addAll((Object[])new Node[]{errorLabel});
        errorHBox.setSpacing(10.0);
        errorHBox.setPadding(new Insets(0.0, 5.0, 5.0, 5.0));
        dialog.getDialogPane().addButonType(ButtonType.OK);
        dialog.getDialogPane().addButonType(ButtonType.CANCEL);
        mainVBox.getChildren().addAll((Object[])new Node[]{guideHBox, nameHBox, errorHBox});
        borderPane.setCenter((Node)mainVBox);
        dialog.getDialogPane().setContent((Node)borderPane);
        Button okButton = dialog.getDialogPane().getButton(ButtonType.OK);
        okButton.setDisable(true);
        nameTextField.requestFocus();
        nameTextField.end();
        dialog.setResultConverter(new Callback<ButtonType, CheckReturn>(){

            public CheckReturn call(ButtonType param) {
                CheckReturn re = new CheckReturn();
                re.setButtonType(param);
                re.setMessage(nameTextField.getText());
                return re;
            }
        });
        nameTextField.textProperty().addListener((obs, oldValue, newValue) -> {
            errorLabel.setText("");
            if (newValue.isEmpty()) {
                okButton.setDisable(true);
                return;
            }
            boolean isValidCheck = FilenameUtil.isVaildName(newValue, "Linux".toString());
            if (!isValidCheck) {
                okButton.setDisable(true);
                String message = Messages.FILEDIALOG_FILE_NAME_ERROR_MESSAGE + " " + FilenameUtil.getInvalidCharacters("Linux".toString());
                errorLabel.setText(message);
                return;
            }
            okButton.setDisable(false);
            okButton.requestFocus();
            nameTextField.requestFocus();
        });
        return (CheckReturn)dialog.showAndWait();
    }

    public static ButtonType popupToCertificate(String title, String message) {
        Dialog dialog = new Dialog();
        dialog.setContentText(message);
        dialog.setTitle(title);
        Hyperlink linkTizenSite = new Hyperlink(Messages.GO_TO_THE_CERTIFICATE_MANAGER);
        linkTizenSite.setPadding(new Insets(0.0, 5.0, 15.0, 15.0));
        linkTizenSite.setFont(Fonts.get(FontKind.FONT_14));
        linkTizenSite.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                SimpleExecutor.asynExecute(new Callable<Void>(){

                    @Override
                    public Void call() {
                        try {
                            ActionProcessor.startCertificateManager();
                        }
                        catch (IOException e) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    FileDialogUtils.permitToInstallErrorMessage(Messages.CERTIFICATE_MANAGER_EXECUTABLE_START_ERROR);
                                }
                            });
                        }
                        return null;
                    }
                });
            }
        });
        dialog.getDialogPane().addContentPane((Node)linkTizenSite);
        dialog.getDialogPane().addButonType(ButtonType.RETRY);
        dialog.getDialogPane().addButonType(ButtonType.CANCEL);
        return (ButtonType)dialog.showAndWait();
    }

    public static Optional<ButtonType> displayDUIDAlert(String title, String header, String message) {
        ButtonType copyButton = new ButtonType(Messages.DUID_ALERT_COPY_BUTTON, ButtonBar.ButtonData.OK_DONE);
        Dialog dialog = new Dialog();
        dialog.setTitle(title);
        dialog.addButonType(copyButton);
        dialog.initStyle(StageStyle.DECORATED);
        Label serialLabel = new Label();
        serialLabel.setStyle("-fx-font-weight: bold;");
        serialLabel.textProperty().set((Object)Messages.DUID_ALERT_SERIAL_LABEL);
        Label serial = new Label();
        serial.textProperty().set((Object)header);
        Label duidLabel = new Label();
        duidLabel.setStyle("-fx-font-weight: bold;");
        duidLabel.textProperty().set((Object)Messages.DUID_ALERT_DUID_LABEL);
        Label duid = new Label();
        duid.textProperty().set((Object)message);
        GridPane gridPane = new GridPane();
        gridPane.setMinHeight(100.0);
        gridPane.setVgap(10.0);
        gridPane.setHgap(20.0);
        gridPane.add((Node)serialLabel, 0, 0, 2, 2);
        gridPane.add((Node)duidLabel, 0, 2, 2, 2);
        gridPane.add((Node)serial, 2, 0, 2, 2);
        gridPane.add((Node)duid, 2, 2, 2, 2);
        dialog.getDialogPane().setContent((Node)gridPane);
        Optional<ButtonType> result = Optional.ofNullable(dialog.showAndWait());
        if (result.isPresent() && result.get() == copyButton) {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(message);
            clipboard.setContent((Map)content);
        }
        return result;
    }
}

